/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.storage.datastructures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.wikidata.wdtk.storage.datastructures.BitVector;

class FindPositionArray {
    final boolean bit;
    final BitVector bitVector;
    final int blockSize;
    boolean hasChanged;
    long[] positionArray;

    public FindPositionArray(BitVector bitVector, boolean bit, int blockSizeGTE64) {
        this(blockSizeGTE64, bitVector, bit);
        if (blockSizeGTE64 < 64) {
            throw new IllegalArgumentException("The block size must be greater than or equal to 64. The received value was " + blockSizeGTE64 + ".");
        }
    }

    FindPositionArray(int blockSize, BitVector bitVector, boolean bit) {
        if (blockSize < 1) {
            throw new IllegalArgumentException("The block size must be a positive number. The received value was: " + blockSize + ".");
        }
        this.bitVector = bitVector;
        this.hasChanged = true;
        this.bit = bit;
        this.blockSize = blockSize;
    }

    public long findPosition(long nOccurrence) {
        this.updateCount();
        if (nOccurrence <= 0L) {
            return -1L;
        }
        int findPos = (int)(nOccurrence / (long)this.blockSize);
        if (findPos < this.positionArray.length) {
            long pos0 = this.positionArray[findPos];
            long leftOccurrences = nOccurrence - (long)(findPos * this.blockSize);
            if (leftOccurrences == 0L) {
                return pos0;
            }
            for (long index = pos0 + 1L; index < this.bitVector.size(); ++index) {
                if (this.bitVector.getBit(index) == this.bit) {
                    --leftOccurrences;
                }
                if (leftOccurrences != 0L) continue;
                return index;
            }
        }
        return -1L;
    }

    List<Long> getPositionList() {
        ArrayList<Long> ret = new ArrayList<Long>();
        ret.add(-1L);
        long count = 0L;
        for (long index = 0L; index < this.bitVector.size(); ++index) {
            if (this.bitVector.getBit(index) == this.bit) {
                ++count;
            }
            if (count < (long)this.blockSize) continue;
            count = 0L;
            ret.add(index);
        }
        return ret;
    }

    public String toString() {
        this.updateCount();
        return Arrays.toString(this.positionArray);
    }

    public void update() {
        this.hasChanged = true;
    }

    void updateCount() {
        if (this.hasChanged) {
            this.positionArray = ArrayUtils.toPrimitive(this.getPositionList().toArray(new Long[0]));
            this.hasChanged = false;
        }
    }
}

