/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf.values;

import org.openrdf.model.Value;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.values.AbstractValueConverter;

public class StringValueConverter
extends AbstractValueConverter<StringValue> {
    public StringValueConverter(RdfWriter rdfWriter, PropertyRegister propertyRegister, OwlDeclarationBuffer rdfConversionBuffer) {
        super(rdfWriter, propertyRegister, rdfConversionBuffer);
    }

    @Override
    public Value getRdfValue(StringValue value, PropertyIdValue propertyIdValue, boolean simple) {
        String valueUriString;
        String datatype;
        switch (datatype = this.propertyRegister.setPropertyTypeFromStringValue(propertyIdValue, value)) {
            case "http://www.wikidata.org/ontology#propertyTypeString": {
                valueUriString = null;
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeCommonsMedia": {
                valueUriString = StringValueConverter.getCommonsUrl(value.getString());
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeUrl": {
                valueUriString = value.getString();
                break;
            }
            default: {
                this.logIncompatibleValueError(propertyIdValue, datatype, "string");
                return null;
            }
        }
        if (valueUriString == null) {
            this.rdfConversionBuffer.addDatatypeProperty(propertyIdValue);
            return this.rdfWriter.getLiteral(value.getString());
        }
        this.rdfConversionBuffer.addObjectProperty(propertyIdValue);
        try {
            return this.rdfWriter.getUri(valueUriString);
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid URI \"" + valueUriString + "\". Not serializing value.");
            return null;
        }
    }

    static String getCommonsUrl(String pageName) {
        return "http://commons.wikimedia.org/wiki/File:" + pageName.replace(' ', '_');
    }
}

