/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf.values;

import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFHandlerException;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.Vocabulary;
import org.wikidata.wdtk.rdf.values.BufferedValueConverter;

public class QuantityValueConverter
extends BufferedValueConverter<QuantityValue> {
    public QuantityValueConverter(RdfWriter rdfWriter, PropertyRegister propertyRegister, OwlDeclarationBuffer rdfConversionBuffer) {
        super(rdfWriter, propertyRegister, rdfConversionBuffer);
    }

    @Override
    public Value getRdfValue(QuantityValue value, PropertyIdValue propertyIdValue, boolean simple) {
        String datatype;
        switch (datatype = this.propertyRegister.setPropertyTypeFromQuantityValue(propertyIdValue, value)) {
            case "http://www.wikidata.org/ontology#propertyTypeQuantity": {
                if (simple) {
                    this.rdfConversionBuffer.addDatatypeProperty(propertyIdValue);
                    return this.rdfWriter.getLiteral(value.getNumericValue().toString(), RdfWriter.XSD_DECIMAL);
                }
                URI valueUri = this.rdfWriter.getUri(Vocabulary.getQuantityValueUri(value, this.propertyRegister.getUriPrefix()));
                this.rdfConversionBuffer.addObjectProperty(propertyIdValue);
                this.addValue(value, valueUri);
                return valueUri;
            }
        }
        this.logIncompatibleValueError(propertyIdValue, datatype, "quantity");
        return null;
    }

    @Override
    public void writeValue(QuantityValue value, Resource resource) throws RDFHandlerException {
        this.rdfWriter.writeTripleValueObject(resource, RdfWriter.RDF_TYPE, (Value)RdfWriter.WB_QUANTITY_VALUE);
        this.rdfWriter.writeTripleLiteralObject(resource, RdfWriter.WB_NUMERIC_VALUE, value.getNumericValue().toString(), RdfWriter.XSD_DECIMAL);
        this.rdfWriter.writeTripleLiteralObject(resource, RdfWriter.WB_LOWER_BOUND, value.getLowerBound().toString(), RdfWriter.XSD_DECIMAL);
        this.rdfWriter.writeTripleLiteralObject(resource, RdfWriter.WB_UPPER_BOUND, value.getUpperBound().toString(), RdfWriter.XSD_DECIMAL);
        String unitIri = "".equals(value.getUnit()) ? "http://www.wikidata.org/entity/Q199" : value.getUnit();
        this.rdfWriter.writeTripleUriObject(resource, RdfWriter.WB_QUANTITY_UNIT, unitIri);
    }
}

