/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf.values;

import org.openrdf.model.Value;
import org.openrdf.rio.RDFHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.values.EntityIdValueConverter;
import org.wikidata.wdtk.rdf.values.GlobeCoordinatesValueConverter;
import org.wikidata.wdtk.rdf.values.MonolingualTextValueConverter;
import org.wikidata.wdtk.rdf.values.QuantityValueConverter;
import org.wikidata.wdtk.rdf.values.StringValueConverter;
import org.wikidata.wdtk.rdf.values.TimeValueConverter;
import org.wikidata.wdtk.rdf.values.ValueConverter;

public class AnyValueConverter
implements ValueConverter<org.wikidata.wdtk.datamodel.interfaces.Value>,
ValueVisitor<Value> {
    final EntityIdValueConverter entityIdValueConverter;
    final StringValueConverter stringValueConverter;
    final TimeValueConverter timeValueConverter;
    final GlobeCoordinatesValueConverter globeCoordinatesValueConverter;
    final QuantityValueConverter quantityValueConverter;
    final MonolingualTextValueConverter monolingualTextValueConverter;
    PropertyIdValue currentPropertyIdValue;
    boolean simple;
    static final Logger logger = LoggerFactory.getLogger(AnyValueConverter.class);

    public AnyValueConverter(RdfWriter rdfWriter, OwlDeclarationBuffer rdfConversionBuffer, PropertyRegister propertyRegister) {
        this.entityIdValueConverter = new EntityIdValueConverter(rdfWriter, propertyRegister, rdfConversionBuffer);
        this.stringValueConverter = new StringValueConverter(rdfWriter, propertyRegister, rdfConversionBuffer);
        this.timeValueConverter = new TimeValueConverter(rdfWriter, propertyRegister, rdfConversionBuffer);
        this.globeCoordinatesValueConverter = new GlobeCoordinatesValueConverter(rdfWriter, propertyRegister, rdfConversionBuffer);
        this.quantityValueConverter = new QuantityValueConverter(rdfWriter, propertyRegister, rdfConversionBuffer);
        this.monolingualTextValueConverter = new MonolingualTextValueConverter(rdfWriter, propertyRegister, rdfConversionBuffer);
    }

    @Override
    public Value getRdfValue(org.wikidata.wdtk.datamodel.interfaces.Value value, PropertyIdValue propertyIdValue, boolean simple) {
        this.currentPropertyIdValue = propertyIdValue;
        this.simple = simple;
        return value.accept(this);
    }

    @Override
    public Value visit(DatatypeIdValue value) {
        throw new RuntimeException("DatatypeIdValue cannot be processed like a value of a user-defined property. Use getDatatypeIdValueLiteral() to get a Literal for such values.");
    }

    @Override
    public Value visit(EntityIdValue value) {
        return this.entityIdValueConverter.getRdfValue(value, this.currentPropertyIdValue, this.simple);
    }

    @Override
    public Value visit(GlobeCoordinatesValue value) {
        return this.globeCoordinatesValueConverter.getRdfValue(value, this.currentPropertyIdValue, this.simple);
    }

    @Override
    public Value visit(MonolingualTextValue value) {
        return this.monolingualTextValueConverter.getRdfValue(value, this.currentPropertyIdValue, this.simple);
    }

    @Override
    public Value visit(QuantityValue value) {
        return this.quantityValueConverter.getRdfValue(value, this.currentPropertyIdValue, this.simple);
    }

    @Override
    public Value visit(StringValue value) {
        return this.stringValueConverter.getRdfValue(value, this.currentPropertyIdValue, this.simple);
    }

    @Override
    public Value visit(TimeValue value) {
        return this.timeValueConverter.getRdfValue(value, this.currentPropertyIdValue, this.simple);
    }

    @Override
    public void writeAuxiliaryTriples() throws RDFHandlerException {
        this.entityIdValueConverter.writeAuxiliaryTriples();
        this.stringValueConverter.writeAuxiliaryTriples();
        this.globeCoordinatesValueConverter.writeAuxiliaryTriples();
        this.timeValueConverter.writeAuxiliaryTriples();
        this.quantityValueConverter.writeAuxiliaryTriples();
    }
}

