/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf.values;

import org.openrdf.rio.RDFHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.rdf.OwlDeclarationBuffer;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.values.ValueConverter;

public abstract class AbstractValueConverter<V extends Value>
implements ValueConverter<V> {
    final PropertyRegister propertyRegister;
    final RdfWriter rdfWriter;
    final OwlDeclarationBuffer rdfConversionBuffer;
    static final Logger logger = LoggerFactory.getLogger(ValueConverter.class);

    public AbstractValueConverter(RdfWriter rdfWriter, PropertyRegister propertyRegister, OwlDeclarationBuffer rdfConversionBuffer) {
        this.rdfWriter = rdfWriter;
        this.propertyRegister = propertyRegister;
        this.rdfConversionBuffer = rdfConversionBuffer;
    }

    @Override
    public void writeAuxiliaryTriples() throws RDFHandlerException {
    }

    protected void logIncompatibleValueError(PropertyIdValue propertyIdValue, String datatype, String valueType) {
        logger.warn("Property " + propertyIdValue.getId() + " has type \"" + datatype + "\" but a value of type " + valueType + ". Data ignored.");
    }
}

