/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import java.io.OutputStream;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.openrdf.rio.UnsupportedRDFormatException;

public class RdfWriter {
    static final ValueFactory factory = ValueFactoryImpl.getInstance();
    public static final URI RDF_TYPE = factory.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    public static final URI RDFS_LABEL = factory.createURI("http://www.w3.org/2000/01/rdf-schema#label");
    public static final URI RDFS_SEE_ALSO = factory.createURI("http://www.w3.org/2000/01/rdf-schema#seeAlso");
    public static final URI RDFS_LITERAL = factory.createURI("http://www.w3.org/2000/01/rdf-schema#Literal");
    public static final URI RDFS_SUBCLASS_OF = factory.createURI("http://www.w3.org/2000/01/rdf-schema#subClassOf");
    public static final URI RDFS_SUBPROPERTY_OF = factory.createURI("http://www.w3.org/2000/01/rdf-schema#subPropertyOf");
    public static final URI OWL_THING = factory.createURI("http://www.w3.org/2002/07/owl#Thing");
    public static final URI OWL_CLASS = factory.createURI("http://www.w3.org/2002/07/owl#Class");
    public static final URI OWL_OBJECT_PROPERTY = factory.createURI("http://www.w3.org/2002/07/owl#ObjectProperty");
    public static final URI OWL_DATATYPE_PROPERTY = factory.createURI("http://www.w3.org/2002/07/owl#DatatypeProperty");
    public static final URI OWL_RESTRICTION = factory.createURI("http://www.w3.org/2002/07/owl#Restriction");
    public static final URI OWL_SOME_VALUES_FROM = factory.createURI("http://www.w3.org/2002/07/owl#someValuesFrom");
    public static final URI OWL_ON_PROPERTY = factory.createURI("http://www.w3.org/2002/07/owl#onProperty");
    public static final URI OWL_COMPLEMENT_OF = factory.createURI("http://www.w3.org/2002/07/owl#complementOf");
    public static final URI XSD_DOUBLE = factory.createURI("http://www.w3.org/2001/XMLSchema#double");
    public static final URI XSD_DECIMAL = factory.createURI("http://www.w3.org/2001/XMLSchema#decimal");
    public static final URI XSD_INT = factory.createURI("http://www.w3.org/2001/XMLSchema#int");
    public static final URI XSD_DATE = factory.createURI("http://www.w3.org/2001/XMLSchema#date");
    public static final URI XSD_G_YEAR = factory.createURI("http://www.w3.org/2001/XMLSchema#gYear");
    public static final URI XSD_G_YEAR_MONTH = factory.createURI("http://www.w3.org/2001/XMLSchema#gYearMonth");
    public static final URI XSD_DATETIME = factory.createURI("http://www.w3.org/2001/XMLSchema#dateTime");
    public static final URI XSD_STRING = factory.createURI("http://www.w3.org/2001/XMLSchema#string");
    public static final URI SKOS_ALT_LABEL = factory.createURI("http://www.w3.org/2004/02/skos/core#altLabel");
    public static final URI SCHEMA_ABOUT = factory.createURI("http://schema.org/about");
    public static final URI SCHEMA_DESCRIPTION = factory.createURI("http://schema.org/description");
    public static final URI SCHEMA_IN_LANGUAGE = factory.createURI("http://schema.org/inLanguage");
    public static final URI PROV_WAS_DERIVED_FROM = factory.createURI("http://www.w3.org/ns/prov#wasDerivedFrom");
    public static final URI WB_ITEM = factory.createURI("http://www.wikidata.org/ontology#Item");
    public static final URI WB_REFERENCE = factory.createURI("http://www.wikidata.org/ontology#Reference");
    public static final URI WB_PROPERTY = factory.createURI("http://www.wikidata.org/ontology#Property");
    public static final URI WB_STATEMENT = factory.createURI("http://www.wikidata.org/ontology#Statement");
    public static final URI WB_ARTICLE = factory.createURI("http://www.wikidata.org/ontology#Article");
    public static final URI WB_QUANTITY_VALUE = factory.createURI("http://www.wikidata.org/ontology#QuantityValue");
    public static final URI WB_TIME_VALUE = factory.createURI("http://www.wikidata.org/ontology#TimeValue");
    public static final URI WB_GLOBE_COORDINATES_VALUE = factory.createURI("http://www.wikidata.org/ontology#GlobeCoordinatesValue");
    public static final URI WB_PROPERTY_TYPE = factory.createURI("http://www.wikidata.org/ontology#propertyType");
    public static final URI WB_GLOBE = factory.createURI("http://www.wikidata.org/ontology#globe");
    public static final URI WB_LATITUDE = factory.createURI("http://www.wikidata.org/ontology#latitude");
    public static final URI WB_LONGITUDE = factory.createURI("http://www.wikidata.org/ontology#longitude");
    public static final URI WB_GC_PRECISION = factory.createURI("http://www.wikidata.org/ontology#gcPrecision");
    public static final URI WB_TIME = factory.createURI("http://www.wikidata.org/ontology#time");
    public static final URI WB_TIME_PRECISION = factory.createURI("http://www.wikidata.org/ontology#timePrecision");
    public static final URI WB_PREFERRED_CALENDAR = factory.createURI("http://www.wikidata.org/ontology#preferredCalendar");
    public static final URI WB_NUMERIC_VALUE = factory.createURI("http://www.wikidata.org/ontology#numericValue");
    public static final URI WB_LOWER_BOUND = factory.createURI("http://www.wikidata.org/ontology#lowerBound");
    public static final URI WB_UPPER_BOUND = factory.createURI("http://www.wikidata.org/ontology#upperBound");
    public static final URI WB_QUANTITY_UNIT = factory.createURI("http://www.wikidata.org/ontology#quantityUnit");
    public static final URI WB_RANK = factory.createURI("http://www.wikidata.org/ontology#rank");
    RDFWriter writer;
    long tripleCount = 0L;

    public RdfWriter(RDFFormat format, OutputStream output) throws UnsupportedRDFormatException {
        this.writer = Rio.createWriter(format, output);
    }

    public long getTripleCount() {
        return this.tripleCount;
    }

    public void start() throws RDFHandlerException {
        this.tripleCount = 0L;
        this.writer.startRDF();
    }

    public void finish() throws RDFHandlerException {
        this.writer.endRDF();
    }

    public BNode getFreshBNode() {
        return factory.createBNode();
    }

    public URI getUri(String uri) {
        return factory.createURI(uri);
    }

    public Literal getLiteral(String value) {
        return factory.createLiteral(value);
    }

    public Literal getLiteral(String value, String languageCode) {
        return factory.createLiteral(value, languageCode);
    }

    public Literal getLiteral(String value, URI datatypeUri) {
        return factory.createLiteral(value, datatypeUri);
    }

    public void writeNamespaceDeclaration(String prefix, String uri) throws RDFHandlerException {
        this.writer.handleNamespace(prefix, uri);
    }

    public void writeTripleStringObject(Resource subject, URI predicate, String objectLiteral) throws RDFHandlerException {
        this.writeTripleValueObject(subject, predicate, (Value)factory.createLiteral(objectLiteral));
    }

    public void writeTripleIntegerObject(Resource subject, URI predicate, int objectLiteral) throws RDFHandlerException {
        this.writeTripleValueObject(subject, predicate, (Value)factory.createLiteral(objectLiteral));
    }

    public void writeTripleUriObject(String subjectUri, URI predicate, String objectUri) throws RDFHandlerException {
        this.writeTripleValueObject(subjectUri, predicate, (Value)factory.createURI(objectUri));
    }

    public void writeTripleUriObject(Resource subject, URI predicate, String objectUri) throws RDFHandlerException {
        this.writeTripleValueObject(subject, predicate, (Value)factory.createURI(objectUri));
    }

    public void writeTripleValueObject(String subjectUri, URI predicate, Value object) throws RDFHandlerException {
        URI subject = factory.createURI(subjectUri);
        ++this.tripleCount;
        this.writer.handleStatement(factory.createStatement(subject, predicate, object));
    }

    public void writeTripleValueObject(Resource subject, URI predicate, Value object) throws RDFHandlerException {
        ++this.tripleCount;
        this.writer.handleStatement(factory.createStatement(subject, predicate, object));
    }

    public void writeTripleLiteralObject(Resource subject, URI predicate, String objectLexicalValue, URI datatype) throws RDFHandlerException {
        Literal object = factory.createLiteral(objectLexicalValue, datatype);
        ++this.tripleCount;
        this.writer.handleStatement(factory.createStatement(subject, predicate, object));
    }
}

