/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import java.io.IOException;
import java.io.OutputStream;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentDumpProcessor;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.Sites;
import org.wikidata.wdtk.rdf.PropertyRegister;
import org.wikidata.wdtk.rdf.RdfConverter;
import org.wikidata.wdtk.rdf.RdfWriter;

public class RdfSerializer
implements EntityDocumentDumpProcessor {
    static final Logger logger = LoggerFactory.getLogger(RdfSerializer.class);
    public static final int TASK_STATEMENTS = 1;
    public static final int TASK_SITELINKS = 2;
    public static final int TASK_DATATYPES = 4;
    public static final int TASK_PROPERTY_LINKS = 128;
    public static final int TASK_LABELS = 16;
    public static final int TASK_DESCRIPTIONS = 32;
    public static final int TASK_ALIASES = 64;
    public static final int TASK_TERMS = 112;
    public static final int TASK_ALL_EXACT_DATA = 247;
    public static final int TASK_TAXONOMY = 65536;
    public static final int TASK_INSTANCE_OF = 131072;
    public static final int TASK_SIMPLE_STATEMENTS = 262144;
    public static final int TASK_SUBPROPERTIES = 0x100000;
    public static final int TASK_ITEMS = 256;
    public static final int TASK_PROPERTIES = 512;
    public static final int TASK_ALL_ENTITIES = 768;
    final OutputStream output;
    final RdfConverter rdfConverter;
    final RdfWriter rdfWriter;

    public RdfSerializer(RDFFormat format, OutputStream output, Sites sites, PropertyRegister propertyRegister) {
        this.output = output;
        this.rdfWriter = new RdfWriter(format, output);
        this.rdfConverter = new RdfConverter(this.rdfWriter, sites, propertyRegister);
    }

    public void setTasks(int tasks) {
        this.rdfConverter.setTasks(tasks);
    }

    public int getTasks() {
        return this.rdfConverter.getTasks();
    }

    public long getTripleCount() {
        return this.rdfWriter.getTripleCount();
    }

    @Override
    public void open() {
        try {
            this.rdfWriter.start();
            this.rdfConverter.writeNamespaceDeclarations();
            this.rdfConverter.writeBasicDeclarations();
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    @Override
    public void processItemDocument(ItemDocument itemDocument) {
        try {
            this.rdfConverter.writeItemDocument(itemDocument);
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    @Override
    public void processPropertyDocument(PropertyDocument propertyDocument) {
        try {
            this.rdfConverter.writePropertyDocument(propertyDocument);
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    @Override
    public void close() {
        try {
            this.rdfWriter.finish();
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e.toString(), e);
        }
        try {
            this.output.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }
}

