/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.rdf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFHandlerException;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.rdf.PropertyContext;
import org.wikidata.wdtk.rdf.RdfWriter;
import org.wikidata.wdtk.rdf.Vocabulary;

public class OwlDeclarationBuffer {
    final List<PropertyIdValue> objectPropertyQueue = new ArrayList<PropertyIdValue>();
    final List<PropertyIdValue> datatypePropertyQueue = new ArrayList<PropertyIdValue>();
    final List<URI> objectPropertyUriQueue = new ArrayList<URI>();
    final List<URI> datatypePropertyUriQueue = new ArrayList<URI>();
    final HashSet<PropertyIdValue> declaredProperties = new HashSet();
    final HashSet<URI> declaredPropertyUris = new HashSet();
    final List<EntityIdValue> classEntityQueue = new ArrayList<EntityIdValue>();
    final HashSet<EntityIdValue> declaredClassEntities = new HashSet();

    public void addObjectProperty(PropertyIdValue propertyIdValue) {
        if (!this.declaredProperties.contains(propertyIdValue)) {
            this.objectPropertyQueue.add(propertyIdValue);
        }
    }

    public void addObjectProperty(URI propertyUri) {
        if (!this.declaredPropertyUris.contains(propertyUri)) {
            this.objectPropertyUriQueue.add(propertyUri);
        }
    }

    public void addDatatypeProperty(PropertyIdValue propertyIdValue) {
        if (!this.declaredProperties.contains(propertyIdValue)) {
            this.datatypePropertyQueue.add(propertyIdValue);
        }
    }

    public void addDatatypeProperty(URI propertyUri) {
        if (!this.declaredPropertyUris.contains(propertyUri)) {
            this.datatypePropertyUriQueue.add(propertyUri);
        }
    }

    public void addClass(EntityIdValue entityIdValue) {
        if (!this.declaredClassEntities.contains(entityIdValue)) {
            this.classEntityQueue.add(entityIdValue);
        }
    }

    public void writePropertyDeclarations(RdfWriter rdfWriter, boolean fullStatements, boolean simpleClaims) throws RDFHandlerException {
        for (PropertyIdValue propertyIdValue : this.objectPropertyQueue) {
            if (!this.declaredProperties.add(propertyIdValue)) continue;
            if (fullStatements) {
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.STATEMENT), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.VALUE), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.QUALIFIER), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.REFERENCE), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
            }
            if (!simpleClaims) continue;
            rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.SIMPLE_CLAIM), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
        }
        this.objectPropertyQueue.clear();
        for (PropertyIdValue propertyIdValue : this.datatypePropertyQueue) {
            if (!this.declaredProperties.add(propertyIdValue)) continue;
            if (fullStatements) {
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.STATEMENT), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.VALUE), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_DATATYPE_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.QUALIFIER), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_DATATYPE_PROPERTY);
                rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.REFERENCE), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_DATATYPE_PROPERTY);
            }
            if (!simpleClaims) continue;
            rdfWriter.writeTripleValueObject(Vocabulary.getPropertyUri(propertyIdValue, PropertyContext.SIMPLE_CLAIM), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_DATATYPE_PROPERTY);
        }
        this.datatypePropertyQueue.clear();
        for (URI propertyUri : this.objectPropertyUriQueue) {
            if (!this.declaredPropertyUris.add(propertyUri)) continue;
            rdfWriter.writeTripleValueObject(propertyUri, RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_OBJECT_PROPERTY);
        }
        this.objectPropertyUriQueue.clear();
        for (URI propertyUri : this.datatypePropertyUriQueue) {
            if (!this.declaredPropertyUris.add(propertyUri)) continue;
            rdfWriter.writeTripleValueObject(propertyUri, RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_DATATYPE_PROPERTY);
        }
        this.datatypePropertyUriQueue.clear();
    }

    public void writeClassDeclarations(RdfWriter rdfWriter) throws RDFHandlerException {
        for (EntityIdValue entityIdValue : this.classEntityQueue) {
            if (!this.declaredClassEntities.add(entityIdValue)) continue;
            rdfWriter.writeTripleValueObject(entityIdValue.getIri(), RdfWriter.RDF_TYPE, (Value)RdfWriter.OWL_CLASS);
        }
        this.classEntityQueue.clear();
    }
}

