/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles.constraint.template;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.Validate;

public class Template {
    final String name;
    final TreeMap<String, String> parameters = new TreeMap();

    public Template(String name, Map<String, String> parameters) {
        Validate.notNull(name, "Name cannot be null.", new Object[0]);
        Validate.notNull(parameters, "Parameters cannot be null.", new Object[0]);
        this.name = name.trim();
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            value = value == null ? "" : value.trim();
            this.parameters.put(key.trim(), value);
        }
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public String getValue(String parameterName) {
        return this.parameters.get(parameterName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{{");
        sb.append(this.name);
        for (String key : this.parameters.keySet()) {
            sb.append("|");
            sb.append(key);
            String value = this.parameters.get(key);
            if (value == null || value.isEmpty()) continue;
            sb.append("=");
            sb.append(value);
        }
        sb.append("}}");
        return sb.toString();
    }
}

