/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentProcessor;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonItemDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonPropertyDocument;
import org.wikidata.wdtk.dumpfiles.MwRevision;
import org.wikidata.wdtk.dumpfiles.MwRevisionProcessor;

public class WikibaseRevisionProcessor
implements MwRevisionProcessor {
    static final Logger logger = LoggerFactory.getLogger(WikibaseRevisionProcessor.class);
    final String siteIri;
    final ObjectMapper mapper = new ObjectMapper();
    final EntityDocumentProcessor entityDocumentProcessor;

    public WikibaseRevisionProcessor(EntityDocumentProcessor entityDocumentProcessor, String siteIri) {
        this.entityDocumentProcessor = entityDocumentProcessor;
        this.siteIri = siteIri;
    }

    @Override
    public void startRevisionProcessing(String siteName, String baseUrl, Map<Integer, String> namespaces) {
    }

    @Override
    public void processRevision(MwRevision mwRevision) {
        if ("wikibase-item".equals(mwRevision.getModel())) {
            this.processItemRevision(mwRevision);
        } else if ("wikibase-property".equals(mwRevision.getModel())) {
            this.processPropertyRevision(mwRevision);
        }
    }

    public void processItemRevision(MwRevision mwRevision) {
        try {
            JacksonItemDocument document = this.mapper.readValue(mwRevision.getText(), JacksonItemDocument.class);
            document.setSiteIri(this.siteIri);
            this.entityDocumentProcessor.processItemDocument(document);
            return;
        }
        catch (JsonParseException e1) {
            logger.error("Failed to parse JSON for item " + mwRevision.getPrefixedTitle() + ": " + e1.getMessage());
        }
        catch (JsonMappingException e1) {
            logger.error("Failed to map JSON for item " + mwRevision.getPrefixedTitle() + ": " + e1.getMessage());
            e1.printStackTrace();
            System.out.print(mwRevision.getText());
        }
        catch (IOException e1) {
            logger.error("Failed to read revision: " + e1.getMessage());
        }
    }

    public void processPropertyRevision(MwRevision mwRevision) {
        try {
            JacksonPropertyDocument document = this.mapper.readValue(mwRevision.getText(), JacksonPropertyDocument.class);
            document.setSiteIri(this.siteIri);
            this.entityDocumentProcessor.processPropertyDocument(document);
            return;
        }
        catch (JsonParseException e1) {
            logger.error("Failed to parse JSON for property " + mwRevision.getPrefixedTitle() + ": " + e1.getMessage());
        }
        catch (JsonMappingException e1) {
            logger.error("Failed to map JSON for property " + mwRevision.getPrefixedTitle() + ": " + e1.getMessage());
            e1.printStackTrace();
            System.out.print(mwRevision.getText());
        }
        catch (IOException e1) {
            logger.error("Failed to read revision: " + e1.getMessage());
        }
    }

    @Override
    public void finishRevisionProcessing() {
    }
}

