/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.interfaces.DocumentDataFilter;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentProcessor;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentProcessorBroker;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentProcessorFilter;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Sites;
import org.wikidata.wdtk.dumpfiles.DumpContentType;
import org.wikidata.wdtk.dumpfiles.JsonDumpFileProcessor;
import org.wikidata.wdtk.dumpfiles.MwDumpFile;
import org.wikidata.wdtk.dumpfiles.MwDumpFileProcessor;
import org.wikidata.wdtk.dumpfiles.MwRevisionDumpFileProcessor;
import org.wikidata.wdtk.dumpfiles.MwRevisionProcessor;
import org.wikidata.wdtk.dumpfiles.MwRevisionProcessorBroker;
import org.wikidata.wdtk.dumpfiles.MwSitesDumpFileProcessor;
import org.wikidata.wdtk.dumpfiles.WikibaseRevisionProcessor;
import org.wikidata.wdtk.dumpfiles.wmf.WmfDumpFileManager;
import org.wikidata.wdtk.util.DirectoryManager;
import org.wikidata.wdtk.util.DirectoryManagerFactory;
import org.wikidata.wdtk.util.WebResourceFetcher;
import org.wikidata.wdtk.util.WebResourceFetcherImpl;

public class DumpProcessingController {
    static final Logger logger = LoggerFactory.getLogger(DumpProcessingController.class);
    final HashMap<ListenerRegistration, List<EntityDocumentProcessor>> entityDocumentProcessors;
    final HashMap<ListenerRegistration, List<MwRevisionProcessor>> mwRevisionProcessors;
    final String projectName;
    boolean preferCurrent = true;
    WebResourceFetcher webResourceFetcher;
    DirectoryManager downloadDirectoryManager;
    DocumentDataFilter filter = new DocumentDataFilter();

    public DumpProcessingController(String projectName) {
        this.projectName = projectName;
        this.entityDocumentProcessors = new HashMap();
        this.mwRevisionProcessors = new HashMap();
        try {
            this.setDownloadDirectory(System.getProperty("user.dir"));
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
        this.setOfflineMode(false);
    }

    public void setDownloadDirectory(String downloadDirectory) throws IOException {
        this.downloadDirectoryManager = DirectoryManagerFactory.createDirectoryManager(downloadDirectory, false);
    }

    public void setOfflineMode(boolean offlineModeEnabled) {
        this.webResourceFetcher = offlineModeEnabled ? null : new WebResourceFetcherImpl();
    }

    public void setPropertyFilter(Set<PropertyIdValue> propertyFilter) {
        this.filter.setPropertyFilter(propertyFilter);
    }

    public void setSiteLinkFilter(Set<String> siteLinkFilter) {
        this.filter.setSiteLinkFilter(siteLinkFilter);
    }

    public void setLanguageFilter(Set<String> languageFilter) {
        this.filter.setLanguageFilter(languageFilter);
    }

    public void registerMwRevisionProcessor(MwRevisionProcessor mwRevisionProcessor, String model, boolean onlyCurrentRevisions) {
        this.registerProcessor(mwRevisionProcessor, model, onlyCurrentRevisions, this.mwRevisionProcessors);
    }

    public void registerEntityDocumentProcessor(EntityDocumentProcessor entityDocumentProcessor, String model, boolean onlyCurrentRevisions) {
        this.registerProcessor(entityDocumentProcessor, model, onlyCurrentRevisions, this.entityDocumentProcessors);
    }

    public Sites getSitesInformation() throws IOException {
        MwDumpFile sitesTableDump = this.getMostRecentDump(DumpContentType.SITES);
        if (sitesTableDump == null) {
            return null;
        }
        MwSitesDumpFileProcessor sitesDumpFileProcessor = new MwSitesDumpFileProcessor();
        sitesDumpFileProcessor.processDumpFileContents(sitesTableDump.getDumpFileStream(), sitesTableDump);
        return sitesDumpFileProcessor.getSites();
    }

    public void processAllRecentRevisionDumps() {
        WmfDumpFileManager wmfDumpFileManager = this.getWmfDumpFileManager();
        if (wmfDumpFileManager == null) {
            return;
        }
        MwDumpFileProcessor dumpFileProcessor = this.getRevisionDumpFileProcessor();
        for (MwDumpFile dumpFile : wmfDumpFileManager.findAllRelevantRevisionDumps(this.preferCurrent)) {
            this.processDumpFile(dumpFile, dumpFileProcessor);
        }
    }

    @Deprecated
    public void processMostRecentDailyDump() {
        this.processDump(this.getMostRecentDump(DumpContentType.JSON));
    }

    public void processMostRecentMainDump() {
        DumpContentType dumpContentType = this.preferCurrent ? DumpContentType.CURRENT : DumpContentType.FULL;
        this.processDump(this.getMostRecentDump(dumpContentType));
    }

    public void processMostRecentJsonDump() {
        this.processDump(this.getMostRecentDump(DumpContentType.JSON));
    }

    public void processDump(MwDumpFile dumpFile) {
        MwDumpFileProcessor dumpFileProcessor;
        if (dumpFile == null) {
            return;
        }
        switch (dumpFile.getDumpContentType()) {
            case CURRENT: 
            case DAILY: 
            case FULL: {
                dumpFileProcessor = this.getRevisionDumpFileProcessor();
                break;
            }
            case JSON: {
                dumpFileProcessor = this.getJsonDumpFileProcessor();
                break;
            }
            default: {
                logger.error("Dumps of type " + (Object)((Object)dumpFile.getDumpContentType()) + " cannot be processed as entity-document dumps.");
                return;
            }
        }
        this.processDumpFile(dumpFile, dumpFileProcessor);
    }

    @Deprecated
    public void processMostRecentDump(DumpContentType dumpContentType, MwDumpFileProcessor dumpFileProcessor) {
        MwDumpFile dumpFile = this.getMostRecentDump(dumpContentType);
        if (dumpFile != null) {
            this.processDumpFile(dumpFile, dumpFileProcessor);
        }
    }

    public MwDumpFile getMostRecentDump(DumpContentType dumpContentType) {
        WmfDumpFileManager wmfDumpFileManager = this.getWmfDumpFileManager();
        if (wmfDumpFileManager == null) {
            return null;
        }
        MwDumpFile result = wmfDumpFileManager.findMostRecentDump(dumpContentType);
        if (result == null) {
            logger.warn("Could not find any dump of type " + dumpContentType.toString() + ".");
        }
        return result;
    }

    void processDumpFile(MwDumpFile dumpFile, MwDumpFileProcessor dumpFileProcessor) {
        try (InputStream inputStream = dumpFile.getDumpFileStream();){
            dumpFileProcessor.processDumpFileContents(inputStream, dumpFile);
        }
        catch (FileAlreadyExistsException e) {
            logger.error("Dump file " + dumpFile.toString() + " could not be processed since file " + e.getFile() + " already exists. Try deleting the file or dumpfile directory to attempt a new download.");
        }
        catch (IOException e) {
            logger.error("Dump file " + dumpFile.toString() + " could not be processed: " + e.toString());
        }
    }

    public WmfDumpFileManager getWmfDumpFileManager() {
        try {
            return new WmfDumpFileManager(this.projectName, this.downloadDirectoryManager, this.webResourceFetcher);
        }
        catch (IOException e) {
            logger.error("Could not create dump file manager: " + e.toString());
            return null;
        }
    }

    MwDumpFileProcessor getRevisionDumpFileProcessor() {
        return new MwRevisionDumpFileProcessor(this.getMasterMwRevisionProcessor());
    }

    MwDumpFileProcessor getJsonDumpFileProcessor() {
        return new JsonDumpFileProcessor(this.getMasterEntityDocumentProcessor(), Datamodel.SITE_WIKIDATA);
    }

    private <T> void registerProcessor(T processor, String model, boolean onlyCurrentRevisions, Map<ListenerRegistration, List<T>> processors) {
        this.preferCurrent = this.preferCurrent && onlyCurrentRevisions;
        ListenerRegistration listenerRegistration = new ListenerRegistration(model, onlyCurrentRevisions);
        if (!processors.containsKey(listenerRegistration)) {
            processors.put(listenerRegistration, new ArrayList());
        }
        processors.get(listenerRegistration).add(processor);
    }

    private EntityDocumentProcessor getMasterEntityDocumentProcessor() {
        EntityDocumentProcessor result = null;
        EntityDocumentProcessorBroker broker = null;
        for (Map.Entry<ListenerRegistration, List<EntityDocumentProcessor>> entry : this.entityDocumentProcessors.entrySet()) {
            for (EntityDocumentProcessor edp : entry.getValue()) {
                if (result == null) {
                    result = edp;
                    continue;
                }
                if (broker == null) {
                    broker = new EntityDocumentProcessorBroker();
                    broker.registerEntityDocumentProcessor(result);
                    result = broker;
                }
                broker.registerEntityDocumentProcessor(edp);
            }
        }
        return this.filterEntityDocumentProcessor(result);
    }

    private EntityDocumentProcessor filterEntityDocumentProcessor(EntityDocumentProcessor processor) {
        if (this.filter.getPropertyFilter() == null && this.filter.getSiteLinkFilter() == null && this.filter.getLanguageFilter() == null) {
            return processor;
        }
        EntityDocumentProcessorFilter filter = new EntityDocumentProcessorFilter(processor, this.filter);
        return filter;
    }

    private MwRevisionProcessor getMasterMwRevisionProcessor() {
        MwRevisionProcessorBroker result = new MwRevisionProcessorBroker();
        for (Map.Entry<ListenerRegistration, List<MwRevisionProcessor>> entry : this.mwRevisionProcessors.entrySet()) {
            for (MwRevisionProcessor mrp : entry.getValue()) {
                result.registerMwRevisionProcessor(mrp, entry.getKey().model, entry.getKey().onlyCurrentRevisions);
            }
        }
        for (Map.Entry<ListenerRegistration, List<Object>> entry : this.entityDocumentProcessors.entrySet()) {
            EntityDocumentProcessor resultEdp = null;
            if (entry.getValue().size() == 1) {
                resultEdp = (EntityDocumentProcessor)entry.getValue().get(0);
            } else {
                EntityDocumentProcessorBroker edpb = new EntityDocumentProcessorBroker();
                for (EntityDocumentProcessor entityDocumentProcessor : entry.getValue()) {
                    edpb.registerEntityDocumentProcessor(entityDocumentProcessor);
                }
                resultEdp = edpb;
            }
            result.registerMwRevisionProcessor(new WikibaseRevisionProcessor(this.filterEntityDocumentProcessor(resultEdp), Datamodel.SITE_WIKIDATA), entry.getKey().model, entry.getKey().onlyCurrentRevisions);
        }
        return result;
    }

    class ListenerRegistration {
        final String model;
        final boolean onlyCurrentRevisions;

        ListenerRegistration(String model, boolean onlyCurrentRevisions) {
            this.model = model;
            this.onlyCurrentRevisions = onlyCurrentRevisions;
        }

        public int hashCode() {
            if (this.model == null) {
                return this.onlyCurrentRevisions ? 1 : 0;
            }
            return 2 * this.model.hashCode() + (this.onlyCurrentRevisions ? 1 : 0);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ListenerRegistration)) {
                return false;
            }
            ListenerRegistration other = (ListenerRegistration)obj;
            if (this.model == null) {
                return other.model == null && this.onlyCurrentRevisions == other.onlyCurrentRevisions;
            }
            return this.model.equals(other.model) && this.onlyCurrentRevisions == other.onlyCurrentRevisions;
        }
    }
}

