/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson.datavalues;

import com.fasterxml.jackson.annotation.JsonIgnore;

public class JacksonInnerTime {
    private String time;
    private int timezone;
    private int before;
    private int after;
    private int precision;
    private String calendarmodel;
    @JsonIgnore
    private long year;
    @JsonIgnore
    private byte month;
    @JsonIgnore
    private byte day;
    @JsonIgnore
    private byte hour;
    @JsonIgnore
    private byte minute;
    @JsonIgnore
    private byte second;

    public JacksonInnerTime() {
    }

    public JacksonInnerTime(String time, int timezoneOffset, int beforeTolerance, int afterTolerance, int precision, String calendarModel) {
        this.time = time;
        this.timezone = timezoneOffset;
        this.before = beforeTolerance;
        this.after = afterTolerance;
        this.precision = precision;
        this.calendarmodel = calendarModel;
        this.decomposeTimeString();
    }

    public JacksonInnerTime(long year, byte month, byte day, byte hour, byte minute, byte second, int timezone, int before, int after, int precision, String calendarmodel) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.timezone = timezone;
        this.before = before;
        this.after = after;
        this.precision = precision;
        this.calendarmodel = calendarmodel;
        this.composeTimeString();
    }

    private void decomposeTimeString() {
        String[] substrings = this.time.split("(?<!\\A)[\\-\\:TZ]");
        this.year = Long.parseLong(substrings[0]);
        this.month = Byte.parseByte(substrings[1]);
        this.day = Byte.parseByte(substrings[2]);
        this.hour = Byte.parseByte(substrings[3]);
        this.minute = Byte.parseByte(substrings[4]);
        this.second = Byte.parseByte(substrings[5]);
    }

    private void composeTimeString() {
        this.time = String.format("%+012d-%02d-%02dT%02d:%02d:%02dZ", this.year, this.month, this.day, this.hour, this.minute, this.second);
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
        this.decomposeTimeString();
    }

    public int getTimezone() {
        return this.timezone;
    }

    public void setTimezone(int timezone) {
        this.timezone = timezone;
    }

    public int getBefore() {
        return this.before;
    }

    public void setBefore(int before) {
        this.before = before;
    }

    public int getAfter() {
        return this.after;
    }

    public void setAfter(int after) {
        this.after = after;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public String getCalendarmodel() {
        return this.calendarmodel;
    }

    public void setCalendarmodel(String calendarmodel) {
        this.calendarmodel = calendarmodel;
    }

    @JsonIgnore
    public byte getSecond() {
        return this.second;
    }

    @JsonIgnore
    public byte getMinute() {
        return this.minute;
    }

    @JsonIgnore
    public byte getHour() {
        return this.hour;
    }

    @JsonIgnore
    public byte getDay() {
        return this.day;
    }

    @JsonIgnore
    public byte getMonth() {
        return this.month;
    }

    @JsonIgnore
    public long getYear() {
        return this.year;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JacksonInnerTime)) {
            return false;
        }
        JacksonInnerTime other = (JacksonInnerTime)o;
        return this.calendarmodel.equals(other.calendarmodel) && this.year == other.year && this.month == other.month && this.day == other.day && this.hour == other.hour && this.minute == other.minute && this.second == other.second && this.before == other.before && this.after == other.after && this.timezone == other.timezone && this.precision == other.precision;
    }
}

