/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonStatement;

public class StatementGroupFromJson
implements StatementGroup {
    final List<Statement> statements;

    public StatementGroupFromJson(List<JacksonStatement> jacksonStatements) {
        this.statements = Collections.unmodifiableList(jacksonStatements);
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.statements.iterator();
    }

    @Override
    public List<Statement> getStatements() {
        return this.statements;
    }

    @Override
    public PropertyIdValue getProperty() {
        return this.statements.get(0).getClaim().getMainSnak().getPropertyId();
    }

    @Override
    public EntityIdValue getSubject() {
        return this.statements.get(0).getClaim().getSubject();
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsStatementGroup(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

