/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.interfaces;

import org.wikidata.wdtk.datamodel.helpers.DatamodelConverter;
import org.wikidata.wdtk.datamodel.implementation.DataObjectFactoryImpl;
import org.wikidata.wdtk.datamodel.interfaces.DocumentDataFilter;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentProcessor;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;

public class EntityDocumentProcessorFilter
implements EntityDocumentProcessor {
    final DatamodelConverter converter = new DatamodelConverter(new DataObjectFactoryImpl());
    final EntityDocumentProcessor entityDocumentProcessor;

    public EntityDocumentProcessorFilter(EntityDocumentProcessor entityDocumentProcessor, DocumentDataFilter filter) {
        this.converter.setOptionFilter(filter);
        this.entityDocumentProcessor = entityDocumentProcessor;
    }

    @Override
    public void processItemDocument(ItemDocument itemDocument) {
        itemDocument = this.converter.copy(itemDocument);
        this.entityDocumentProcessor.processItemDocument(itemDocument);
    }

    @Override
    public void processPropertyDocument(PropertyDocument propertyDocument) {
        propertyDocument = this.converter.copy(propertyDocument);
        this.entityDocumentProcessor.processPropertyDocument(propertyDocument);
    }
}

