/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.io.Serializable;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public class TimeValueImpl
implements TimeValue,
Serializable {
    private static final long serialVersionUID = 3969248626709737997L;
    final long year;
    final byte month;
    final byte day;
    final byte hour;
    final byte minute;
    final byte second;
    final byte precision;
    final int timezoneOffset;
    final int beforeTolerance;
    final int afterTolerance;
    final String calendarModel;

    TimeValueImpl(long year, byte month, byte day, byte hour, byte minute, byte second, byte precision, int beforeTolerance, int afterTolerance, int timezoneOffset, String calendarModel) {
        Validate.notNull(calendarModel, "Calendar model must not be null", new Object[0]);
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.precision = precision;
        this.beforeTolerance = beforeTolerance;
        this.afterTolerance = afterTolerance;
        this.timezoneOffset = timezoneOffset;
        this.calendarModel = calendarModel;
    }

    @Override
    public long getYear() {
        return this.year;
    }

    @Override
    public byte getMonth() {
        return this.month;
    }

    @Override
    public byte getDay() {
        return this.day;
    }

    @Override
    public byte getHour() {
        return this.hour;
    }

    @Override
    public byte getMinute() {
        return this.minute;
    }

    @Override
    public byte getSecond() {
        return this.second;
    }

    @Override
    public int getTimezoneOffset() {
        return this.timezoneOffset;
    }

    @Override
    public String getPreferredCalendarModel() {
        return this.calendarModel;
    }

    @Override
    public byte getPrecision() {
        return this.precision;
    }

    @Override
    public int getBeforeTolerance() {
        return this.beforeTolerance;
    }

    @Override
    public int getAfterTolerance() {
        return this.afterTolerance;
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsTimeValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

