/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;

public class StatementImpl
implements Statement,
Serializable {
    private static final long serialVersionUID = -9151463996806807715L;
    final Claim claim;
    final List<? extends Reference> references;
    final StatementRank rank;
    final String statementId;

    StatementImpl(Claim claim, List<? extends Reference> references, StatementRank rank, String statementId) {
        Validate.notNull(claim, "Statement main claim cannot be null", new Object[0]);
        Validate.notNull(references, "Statement references cannot be null", new Object[0]);
        Validate.notNull(rank, "Statement ranks cannot be null", new Object[0]);
        Validate.notNull(statementId, "Statement ids cannot be null", new Object[0]);
        this.claim = claim;
        this.references = references;
        this.rank = rank;
        this.statementId = statementId;
    }

    @Override
    public Claim getClaim() {
        return this.claim;
    }

    @Override
    public StatementRank getRank() {
        return this.rank;
    }

    @Override
    public List<? extends Reference> getReferences() {
        return Collections.unmodifiableList(this.references);
    }

    @Override
    public String getStatementId() {
        return this.statementId;
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsStatement(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

