/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.DataObjectFactory;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.DocumentDataFilter;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.SnakVisitor;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public class DatamodelConverter
implements SnakVisitor<Snak>,
ValueVisitor<Value> {
    static final Logger logger = LoggerFactory.getLogger(DatamodelConverter.class);
    private final DataObjectFactory dataObjectFactory;
    private boolean deepCopy = true;
    private boolean deepCopyReferences = true;
    private DocumentDataFilter filter = new DocumentDataFilter();

    public DatamodelConverter(DataObjectFactory dataObjectFactory) {
        this.dataObjectFactory = dataObjectFactory;
    }

    public boolean hasOptionDeepCopy() {
        return this.deepCopy;
    }

    public void setOptionDeepCopy(boolean value) {
        this.deepCopy = value;
    }

    public boolean hasOptionDeepCopyReferences() {
        return this.deepCopyReferences;
    }

    public void setOptionDeepCopyReferences(boolean value) {
        this.deepCopyReferences = value;
    }

    public void setOptionFilter(DocumentDataFilter filter) {
        this.filter = filter;
    }

    public Set<String> getOptionLanguageFilter() {
        return this.filter.getLanguageFilter();
    }

    public void setOptionLanguageFilter(Set<String> languageFilter) {
        this.filter.setLanguageFilter(languageFilter);
    }

    public Set<PropertyIdValue> getOptionPropertyFilter() {
        return this.filter.getPropertyFilter();
    }

    public void setOptionPropertyFilter(Set<PropertyIdValue> propertyFilter) {
        this.filter.setPropertyFilter(propertyFilter);
    }

    public Set<String> getOptionSiteLinkFilter() {
        return this.filter.getSiteLinkFilter();
    }

    public void setOptionSiteLinkFilter(Set<String> siteLinkFilter) {
        this.filter.setSiteLinkFilter(siteLinkFilter);
    }

    public ItemIdValue copy(ItemIdValue object) {
        return this.dataObjectFactory.getItemIdValue(object.getId(), object.getSiteIri());
    }

    public PropertyIdValue copy(PropertyIdValue object) {
        return this.dataObjectFactory.getPropertyIdValue(object.getId(), object.getSiteIri());
    }

    public DatatypeIdValue copy(DatatypeIdValue object) {
        return this.dataObjectFactory.getDatatypeIdValue(object.getIri());
    }

    public TimeValue copy(TimeValue object) {
        return this.dataObjectFactory.getTimeValue(object.getYear(), object.getMonth(), object.getDay(), object.getHour(), object.getMinute(), object.getSecond(), object.getPrecision(), object.getBeforeTolerance(), object.getAfterTolerance(), object.getTimezoneOffset(), object.getPreferredCalendarModel());
    }

    public GlobeCoordinatesValue copy(GlobeCoordinatesValue object) {
        return this.dataObjectFactory.getGlobeCoordinatesValue(object.getLatitude(), object.getLongitude(), object.getPrecision(), object.getGlobe());
    }

    public StringValue copy(StringValue object) {
        return this.dataObjectFactory.getStringValue(object.getString());
    }

    public MonolingualTextValue copy(MonolingualTextValue object) {
        return this.dataObjectFactory.getMonolingualTextValue(object.getText(), object.getLanguageCode());
    }

    public QuantityValue copy(QuantityValue object) {
        return this.dataObjectFactory.getQuantityValue(object.getNumericValue(), object.getLowerBound(), object.getUpperBound(), object.getUnit());
    }

    public ValueSnak copy(ValueSnak object) {
        if (this.deepCopy) {
            return this.dataObjectFactory.getValueSnak(this.copy(object.getPropertyId()), this.copyValue(object.getValue()));
        }
        return this.dataObjectFactory.getValueSnak(object.getPropertyId(), object.getValue());
    }

    public SomeValueSnak copy(SomeValueSnak object) {
        return this.dataObjectFactory.getSomeValueSnak(this.innerCopyPropertyIdValue(object.getPropertyId()));
    }

    public NoValueSnak copy(NoValueSnak object) {
        return this.dataObjectFactory.getNoValueSnak(this.innerCopyPropertyIdValue(object.getPropertyId()));
    }

    public SnakGroup copy(SnakGroup object) {
        if (this.deepCopy) {
            return this.deepCopySnakGroup(object);
        }
        return this.dataObjectFactory.getSnakGroup(object.getSnaks());
    }

    public Claim copy(Claim object) {
        if (this.deepCopy) {
            return this.deepCopyClaim(object);
        }
        return this.dataObjectFactory.getClaim(object.getSubject(), object.getMainSnak(), object.getQualifiers());
    }

    public Reference copy(Reference object) {
        if (this.deepCopy) {
            return this.dataObjectFactory.getReference(this.deepCopySnakGroups(object.getSnakGroups()));
        }
        return this.dataObjectFactory.getReference(object.getSnakGroups());
    }

    public Statement copy(Statement object) {
        if (this.deepCopy) {
            return this.deepCopyStatement(object);
        }
        return this.dataObjectFactory.getStatement(object.getClaim(), object.getReferences(), object.getRank(), object.getStatementId());
    }

    public StatementGroup copy(StatementGroup object) {
        if (this.deepCopy) {
            return this.deepCopyStatementGroup(object);
        }
        return this.dataObjectFactory.getStatementGroup(object.getStatements());
    }

    public SiteLink copy(SiteLink object) {
        return this.dataObjectFactory.getSiteLink(object.getPageTitle(), object.getSiteKey(), object.getBadges());
    }

    public PropertyDocument copy(PropertyDocument object) {
        if (this.deepCopy) {
            return this.dataObjectFactory.getPropertyDocument(this.copy(object.getPropertyId()), this.deepCopyMonoLingualTextValues(object.getLabels().values()), this.deepCopyMonoLingualTextValues(object.getDescriptions().values()), this.flattenDeepCopyAliasMap(object.getAliases()), this.deepCopyStatementGroups(object.getStatementGroups()), this.copy(object.getDatatype()), object.getRevisionId());
        }
        return this.dataObjectFactory.getPropertyDocument(object.getPropertyId(), this.copyMonoLingualTextValues(object.getLabels().values()), this.copyMonoLingualTextValues(object.getDescriptions().values()), this.flattenAliasMap(object.getAliases()), this.copyStatementGroups(object.getStatementGroups()), object.getDatatype(), object.getRevisionId());
    }

    public ItemDocument copy(ItemDocument object) {
        if (this.deepCopy) {
            return this.dataObjectFactory.getItemDocument(this.copy(object.getItemId()), this.deepCopyMonoLingualTextValues(object.getLabels().values()), this.deepCopyMonoLingualTextValues(object.getDescriptions().values()), this.flattenDeepCopyAliasMap(object.getAliases()), this.deepCopyStatementGroups(object.getStatementGroups()), this.deepCopySiteLinks(object.getSiteLinks()), object.getRevisionId());
        }
        return this.dataObjectFactory.getItemDocument(object.getItemId(), this.copyMonoLingualTextValues(object.getLabels().values()), this.copyMonoLingualTextValues(object.getDescriptions().values()), this.flattenAliasMap(object.getAliases()), this.copyStatementGroups(object.getStatementGroups()), this.copySiteLinks(object.getSiteLinks()), object.getRevisionId());
    }

    public Snak copySnak(Snak snak) {
        return snak.accept(this);
    }

    @Override
    public Snak visit(ValueSnak snak) {
        return this.copy(snak);
    }

    @Override
    public Snak visit(SomeValueSnak snak) {
        return this.copy(snak);
    }

    @Override
    public Snak visit(NoValueSnak snak) {
        return this.copy(snak);
    }

    public Value copyValue(Value value) {
        return value.accept(this);
    }

    @Override
    public Value visit(DatatypeIdValue value) {
        return this.copy(value);
    }

    @Override
    public Value visit(EntityIdValue value) {
        if (value instanceof ItemIdValue) {
            return this.copy((ItemIdValue)value);
        }
        if (value instanceof PropertyIdValue) {
            return this.copy((PropertyIdValue)value);
        }
        throw new UnsupportedOperationException("Cannot convert entity id value: " + value.getClass());
    }

    @Override
    public Value visit(GlobeCoordinatesValue value) {
        return this.copy(value);
    }

    @Override
    public Value visit(MonolingualTextValue value) {
        return this.copy(value);
    }

    @Override
    public Value visit(QuantityValue value) {
        return this.copy(value);
    }

    @Override
    public Value visit(StringValue value) {
        return this.copy(value);
    }

    @Override
    public Value visit(TimeValue value) {
        return this.copy(value);
    }

    private List<MonolingualTextValue> flattenAliasMap(Map<String, List<MonolingualTextValue>> aliasMap) {
        ArrayList<MonolingualTextValue> aliases = new ArrayList<MonolingualTextValue>();
        for (Map.Entry<String, List<MonolingualTextValue>> langAliases : aliasMap.entrySet()) {
            if (!this.filter.includeLanguage(langAliases.getKey())) continue;
            aliases.addAll((Collection<MonolingualTextValue>)langAliases.getValue());
        }
        return aliases;
    }

    private List<MonolingualTextValue> flattenDeepCopyAliasMap(Map<String, List<MonolingualTextValue>> aliasMap) {
        ArrayList<MonolingualTextValue> aliases = new ArrayList<MonolingualTextValue>();
        for (Map.Entry<String, List<MonolingualTextValue>> langAliases : aliasMap.entrySet()) {
            if (!this.filter.includeLanguage(langAliases.getKey())) continue;
            for (MonolingualTextValue mtv : langAliases.getValue()) {
                aliases.add(this.copy(mtv));
            }
        }
        return aliases;
    }

    private PropertyIdValue innerCopyPropertyIdValue(PropertyIdValue propertyIdValue) {
        return this.deepCopy ? this.copy(propertyIdValue) : propertyIdValue;
    }

    private Snak deepCopySnak(Snak snak) {
        if (snak instanceof ValueSnak) {
            return this.dataObjectFactory.getValueSnak(this.copy(snak.getPropertyId()), this.copyValue(((ValueSnak)snak).getValue()));
        }
        if (snak instanceof NoValueSnak) {
            return this.dataObjectFactory.getNoValueSnak(this.copy(snak.getPropertyId()));
        }
        if (snak instanceof SomeValueSnak) {
            return this.dataObjectFactory.getSomeValueSnak(this.copy(snak.getPropertyId()));
        }
        throw new IllegalArgumentException("I don't know how to copy snaks of type " + snak.getClass());
    }

    private SnakGroup deepCopySnakGroup(SnakGroup snakGroup) {
        ArrayList<Snak> snaks = new ArrayList<Snak>(snakGroup.getSnaks().size());
        for (Snak snak : snakGroup.getSnaks()) {
            snaks.add(this.deepCopySnak(snak));
        }
        return this.dataObjectFactory.getSnakGroup(snaks);
    }

    private List<SnakGroup> deepCopySnakGroups(List<SnakGroup> snakGroups) {
        ArrayList<SnakGroup> result = new ArrayList<SnakGroup>(snakGroups.size());
        for (SnakGroup snakGroup : snakGroups) {
            result.add(this.deepCopySnakGroup(snakGroup));
        }
        return result;
    }

    private Claim deepCopyClaim(Claim claim) {
        return this.dataObjectFactory.getClaim((EntityIdValue)this.visit(claim.getSubject()), this.deepCopySnak(claim.getMainSnak()), this.deepCopySnakGroups(claim.getQualifiers()));
    }

    private List<Reference> deepCopyReferences(List<? extends Reference> references) {
        if (!this.deepCopyReferences) {
            return Collections.emptyList();
        }
        ArrayList<Reference> result = new ArrayList<Reference>(references.size());
        for (Reference reference : references) {
            result.add(this.dataObjectFactory.getReference(this.deepCopySnakGroups(reference.getSnakGroups())));
        }
        return result;
    }

    private Statement deepCopyStatement(Statement statement) {
        return this.dataObjectFactory.getStatement(this.deepCopyClaim(statement.getClaim()), this.deepCopyReferences(statement.getReferences()), statement.getRank(), statement.getStatementId());
    }

    private StatementGroup deepCopyStatementGroup(StatementGroup statementGroup) {
        ArrayList<Statement> statements = new ArrayList<Statement>(statementGroup.getStatements().size());
        for (Statement statement : statementGroup.getStatements()) {
            try {
                statements.add(this.deepCopyStatement(statement));
            }
            catch (IllegalArgumentException e) {
                logger.error("A statement could not be copied and was dropped.\nError: " + e.getMessage() + "\nStatement:\n" + statement.toString());
            }
        }
        if (statements.isEmpty()) {
            return null;
        }
        return this.dataObjectFactory.getStatementGroup(statements);
    }

    private List<StatementGroup> deepCopyStatementGroups(List<StatementGroup> statementGroups) {
        if (this.filter.excludeAllProperties()) {
            return Collections.emptyList();
        }
        ArrayList<StatementGroup> result = new ArrayList<StatementGroup>(statementGroups.size());
        for (StatementGroup statementGroup : statementGroups) {
            StatementGroup copiedStatementGroup;
            if (!this.filter.includePropertyId(statementGroup.getProperty()) || (copiedStatementGroup = this.deepCopyStatementGroup(statementGroup)) == null) continue;
            result.add(copiedStatementGroup);
        }
        return result;
    }

    private List<StatementGroup> copyStatementGroups(List<StatementGroup> statementGroups) {
        if (this.filter.getPropertyFilter() == null) {
            return statementGroups;
        }
        if (this.filter.getPropertyFilter().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StatementGroup> result = new ArrayList<StatementGroup>(statementGroups.size());
        for (StatementGroup statementGroup : statementGroups) {
            if (!this.filter.getPropertyFilter().contains(statementGroup.getProperty())) continue;
            result.add(statementGroup);
        }
        return result;
    }

    private List<MonolingualTextValue> deepCopyMonoLingualTextValues(Collection<MonolingualTextValue> monoLingualTextValues) {
        if (this.filter.excludeAllLanguages()) {
            return Collections.emptyList();
        }
        ArrayList<MonolingualTextValue> result = new ArrayList<MonolingualTextValue>(monoLingualTextValues.size());
        for (MonolingualTextValue mtv : monoLingualTextValues) {
            if (!this.filter.includeLanguage(mtv.getLanguageCode())) continue;
            result.add(this.copy(mtv));
        }
        return result;
    }

    private List<MonolingualTextValue> copyMonoLingualTextValues(Collection<MonolingualTextValue> monoLingualTextValues) {
        if (this.filter.getLanguageFilter() == null) {
            return new ArrayList<MonolingualTextValue>(monoLingualTextValues);
        }
        if (this.filter.getLanguageFilter().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MonolingualTextValue> result = new ArrayList<MonolingualTextValue>(monoLingualTextValues.size());
        for (MonolingualTextValue mtv : monoLingualTextValues) {
            if (!this.filter.getLanguageFilter().contains(mtv.getLanguageCode())) continue;
            result.add(mtv);
        }
        return result;
    }

    private Map<String, SiteLink> deepCopySiteLinks(Map<String, SiteLink> siteLinks) {
        if (this.filter.excludeAllSiteLinks()) {
            return Collections.emptyMap();
        }
        HashMap<String, SiteLink> result = new HashMap<String, SiteLink>(siteLinks.size());
        for (Map.Entry<String, SiteLink> entry : siteLinks.entrySet()) {
            if (!this.filter.includeSiteLink(entry.getKey())) continue;
            result.put(entry.getKey(), this.copy(entry.getValue()));
        }
        return result;
    }

    private Map<String, SiteLink> copySiteLinks(Map<String, SiteLink> siteLinks) {
        if (this.filter.getSiteLinkFilter() == null) {
            return siteLinks;
        }
        if (this.filter.getSiteLinkFilter().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, SiteLink> result = new HashMap<String, SiteLink>(siteLinks.size());
        for (Map.Entry<String, SiteLink> entry : siteLinks.entrySet()) {
            if (!this.filter.getSiteLinkFilter().contains(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

