/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.client;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.varia.LevelRangeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.client.ClientConfiguration;
import org.wikidata.wdtk.client.DumpProcessingAction;
import org.wikidata.wdtk.datamodel.interfaces.Sites;
import org.wikidata.wdtk.dumpfiles.DumpContentType;
import org.wikidata.wdtk.dumpfiles.DumpProcessingController;
import org.wikidata.wdtk.dumpfiles.EntityTimerProcessor;
import org.wikidata.wdtk.dumpfiles.MwDumpFile;
import org.wikidata.wdtk.util.DirectoryManager;
import org.wikidata.wdtk.util.DirectoryManagerFactory;

public class Client {
    static final Logger logger = LoggerFactory.getLogger(Client.class);
    static final String LOG_PATTERN = "%d{yyyy-MM-dd HH:mm:ss} %-5p - %m%n";
    static ConsoleAppender errorAppender = null;
    static ConsoleAppender consoleAppender = null;
    private Sites sites = null;
    final DumpProcessingController dumpProcessingController;
    protected final ClientConfiguration clientConfiguration;

    public Client(DumpProcessingController dumpProcessingController, String[] args) {
        this.initializeLogging();
        this.dumpProcessingController = dumpProcessingController;
        this.clientConfiguration = new ClientConfiguration(args);
        if (this.clientConfiguration.isQuiet()) {
            consoleAppender.setThreshold(Level.OFF);
        } else {
            consoleAppender.setThreshold(Level.INFO);
        }
    }

    public void performActions() {
        if (this.clientConfiguration.getActions().isEmpty()) {
            this.clientConfiguration.printHelp();
            return;
        }
        this.dumpProcessingController.setOfflineMode(this.clientConfiguration.getOfflineMode());
        if (this.clientConfiguration.getDumpDirectoryLocation() != null) {
            try {
                this.dumpProcessingController.setDownloadDirectory(this.clientConfiguration.getDumpDirectoryLocation());
            }
            catch (IOException e) {
                logger.error("Could not set download directory to " + this.clientConfiguration.getDumpDirectoryLocation() + ": " + e.getMessage());
                logger.error("Aborting");
                return;
            }
        }
        this.dumpProcessingController.setLanguageFilter(this.clientConfiguration.getFilterLanguages());
        this.dumpProcessingController.setSiteLinkFilter(this.clientConfiguration.getFilterSiteKeys());
        this.dumpProcessingController.setPropertyFilter(this.clientConfiguration.getFilterProperties());
        MwDumpFile dumpFile = this.clientConfiguration.getLocalDumpFile();
        if (dumpFile == null) {
            dumpFile = this.dumpProcessingController.getMostRecentDump(DumpContentType.JSON);
        } else if (!dumpFile.isAvailable()) {
            logger.error("Dump file not found or not readable: " + dumpFile.toString());
            return;
        }
        boolean hasReadyProcessor = false;
        for (DumpProcessingAction props : this.clientConfiguration.getActions()) {
            if (!props.isReady()) continue;
            if (props.needsSites()) {
                this.prepareSites();
                if (this.sites == null) continue;
                props.setSites(this.sites);
            }
            props.setDumpInformation(dumpFile.getProjectName(), dumpFile.getDateStamp());
            this.dumpProcessingController.registerEntityDocumentProcessor(props, null, true);
            hasReadyProcessor = true;
        }
        if (!hasReadyProcessor) {
            return;
        }
        if (!this.clientConfiguration.isQuiet()) {
            EntityTimerProcessor entityTimerProcessor = new EntityTimerProcessor(0);
            this.dumpProcessingController.registerEntityDocumentProcessor(entityTimerProcessor, null, true);
        }
        this.openActions();
        this.dumpProcessingController.processDump(dumpFile);
        this.closeActions();
        try {
            this.writeReport();
        }
        catch (IOException e) {
            logger.error("Could not print report file: " + e.getMessage());
        }
    }

    private void prepareSites() {
        if (this.sites == null) {
            try {
                this.sites = this.dumpProcessingController.getSitesInformation();
            }
            catch (IOException e) {
                logger.error("Failed to get sites information: " + e.getMessage());
            }
        }
    }

    private void initializeLogging() {
        if (consoleAppender != null) {
            return;
        }
        consoleAppender = new ConsoleAppender();
        consoleAppender.setLayout(new PatternLayout(LOG_PATTERN));
        consoleAppender.setThreshold(Level.INFO);
        LevelRangeFilter filter = new LevelRangeFilter();
        filter.setLevelMin(Level.TRACE);
        filter.setLevelMax(Level.INFO);
        consoleAppender.addFilter(filter);
        consoleAppender.activateOptions();
        org.apache.log4j.Logger.getRootLogger().addAppender(consoleAppender);
        errorAppender = new ConsoleAppender();
        errorAppender.setLayout(new PatternLayout(LOG_PATTERN));
        errorAppender.setThreshold(Level.WARN);
        errorAppender.setTarget("System.err");
        errorAppender.activateOptions();
        org.apache.log4j.Logger.getRootLogger().addAppender(errorAppender);
    }

    private void openActions() {
        for (DumpProcessingAction action : this.clientConfiguration.getActions()) {
            action.open();
        }
    }

    void writeReport() throws IOException {
        StringBuilder builder = new StringBuilder();
        for (DumpProcessingAction action : this.clientConfiguration.getActions()) {
            if (this.clientConfiguration.getReportFileName() != null) {
                builder.append(action.getActionName() + ": ");
                builder.append(action.getReport());
                builder.append(System.getProperty("line.separator"));
                continue;
            }
            logger.info(action.getActionName() + ": " + action.getReport());
        }
        if (this.clientConfiguration.getReportFileName() != null) {
            Path outputDirectory = Paths.get(this.clientConfiguration.getReportFileName(), new String[0]).getParent();
            if (outputDirectory == null) {
                outputDirectory = Paths.get(".", new String[0]);
            }
            DirectoryManager dm = DirectoryManagerFactory.createDirectoryManager(outputDirectory, false);
            OutputStream out = dm.getOutputStreamForFile(Paths.get(this.clientConfiguration.getReportFileName(), new String[0]).getFileName().toString());
            out.write(builder.toString().getBytes(StandardCharsets.UTF_8));
            out.close();
        }
    }

    private void closeActions() {
        for (DumpProcessingAction action : this.clientConfiguration.getActions()) {
            action.close();
        }
    }

    public static void main(String[] args) throws ParseException, IOException {
        Client client = new Client(new DumpProcessingController("wikidatawiki"), args);
        client.performActions();
    }
}

