/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.federation.evaluation;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.LookAheadIteration;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.sail.federation.evaluation.QueueCursor;

public class ParallelJoinCursor
extends LookAheadIteration<BindingSet, QueryEvaluationException>
implements Runnable {
    private final EvaluationStrategy strategy;
    private final TupleExpr rightArg;
    private volatile Thread evaluationThread;
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private CloseableIteration<BindingSet, QueryEvaluationException> rightIter;
    private volatile boolean closed;
    private final QueueCursor<CloseableIteration<BindingSet, QueryEvaluationException>> rightQueue = new QueueCursor(1024);

    public ParallelJoinCursor(EvaluationStrategy strategy, CloseableIteration<BindingSet, QueryEvaluationException> leftIter, TupleExpr rightArg) throws QueryEvaluationException {
        this.strategy = strategy;
        this.leftIter = leftIter;
        this.rightArg = rightArg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.evaluationThread = Thread.currentThread();
        try {
            while (!this.closed && this.leftIter.hasNext()) {
                this.rightQueue.put(this.strategy.evaluate(this.rightArg, (BindingSet)this.leftIter.next()));
            }
        }
        catch (RuntimeException e) {
            this.rightQueue.toss(e);
        }
        catch (QueryEvaluationException e) {
            this.rightQueue.toss(e);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.evaluationThread = null;
            this.rightQueue.done();
        }
    }

    @Override
    public synchronized BindingSet getNextElement() throws QueryEvaluationException {
        BindingSet result = null;
        while (this.rightIter != null || this.rightQueue.hasNext()) {
            if (this.rightIter == null) {
                this.rightIter = (CloseableIteration)this.rightQueue.next();
            }
            if (this.rightIter.hasNext()) {
                result = (BindingSet)this.rightIter.next();
                break;
            }
            this.rightIter.close();
            this.rightIter = null;
        }
        return result;
    }

    @Override
    public synchronized void handleClose() throws QueryEvaluationException {
        this.closed = true;
        if (this.evaluationThread != null) {
            this.evaluationThread.interrupt();
        }
        if (this.rightIter != null) {
            this.rightIter.close();
            this.rightIter = null;
        }
        this.leftIter.close();
    }

    public String toString() {
        String left = this.leftIter.toString().replace("\n", "\n\t");
        String right = null == this.rightIter ? this.rightArg.toString() : this.rightIter.toString();
        return "ParallelJoin\n\t" + left + "\n\t" + right.replace("\n", "\n\t");
    }
}

