/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.helpers;

import info.aduna.net.ParsedURI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParseLocationListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.helpers.NTriplesParserSettings;
import org.openrdf.rio.helpers.RDFParserHelper;
import org.openrdf.rio.helpers.RDFaParserSettings;

public abstract class RDFParserBase
implements RDFParser {
    private static final Map<String, String> defaultPrefix;
    protected RDFHandler rdfHandler;
    private ParseErrorListener errListener;
    private ParseLocationListener locationListener;
    protected ValueFactory valueFactory;
    private ParsedURI baseURI;
    private String nextBNodePrefix;
    private Map<String, String> namespaceTable = new HashMap<String, String>(16);
    private ParserConfig parserConfig;

    public RDFParserBase() {
        this(new ValueFactoryImpl());
    }

    public RDFParserBase(ValueFactory valueFactory) {
        this.nextBNodePrefix = this.createUniqueBNodePrefix();
        this.setValueFactory(valueFactory);
        this.setParserConfig(new ParserConfig());
    }

    @Override
    public void setValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    @Override
    public void setRDFHandler(RDFHandler handler) {
        this.rdfHandler = handler;
    }

    public RDFHandler getRDFHandler() {
        return this.rdfHandler;
    }

    @Override
    public void setParseErrorListener(ParseErrorListener el) {
        this.errListener = el;
    }

    public ParseErrorListener getParseErrorListener() {
        return this.errListener;
    }

    @Override
    public void setParseLocationListener(ParseLocationListener el) {
        this.locationListener = el;
    }

    public ParseLocationListener getParseLocationListener() {
        return this.locationListener;
    }

    @Override
    public void setParserConfig(ParserConfig config) {
        this.parserConfig = config;
    }

    @Override
    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet result = new HashSet();
        result.add(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        result.add(BasicParserSettings.VERIFY_DATATYPE_VALUES);
        result.add(BasicParserSettings.NORMALIZE_DATATYPE_VALUES);
        result.add(BasicParserSettings.DATATYPE_HANDLERS);
        result.add(BasicParserSettings.FAIL_ON_UNKNOWN_LANGUAGES);
        result.add(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
        result.add(BasicParserSettings.NORMALIZE_LANGUAGE_TAGS);
        result.add(BasicParserSettings.LANGUAGE_HANDLERS);
        result.add(BasicParserSettings.VERIFY_RELATIVE_URIS);
        result.add(BasicParserSettings.PRESERVE_BNODE_IDS);
        result.add(RDFaParserSettings.FAIL_ON_RDFA_UNDEFINED_PREFIXES);
        return result;
    }

    @Override
    public void setVerifyData(boolean verifyData) {
        this.parserConfig.set(BasicParserSettings.VERIFY_RELATIVE_URIS, verifyData);
    }

    @Deprecated
    public boolean verifyData() {
        return this.parserConfig.verifyData();
    }

    @Override
    public void setPreserveBNodeIDs(boolean preserveBNodeIDs) {
        this.parserConfig.set(BasicParserSettings.PRESERVE_BNODE_IDS, preserveBNodeIDs);
    }

    public boolean preserveBNodeIDs() {
        return this.parserConfig.get(BasicParserSettings.PRESERVE_BNODE_IDS);
    }

    @Override
    @Deprecated
    public void setStopAtFirstError(boolean stopAtFirstError) {
        this.getParserConfig().set(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES, stopAtFirstError);
        if (!stopAtFirstError) {
            this.getParserConfig().addNonFatalError(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        } else {
            HashSet set = new HashSet(this.getParserConfig().getNonFatalErrors());
            set.remove(NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
            this.getParserConfig().setNonFatalErrors(set);
        }
    }

    @Deprecated
    public boolean stopAtFirstError() {
        return this.parserConfig.stopAtFirstError();
    }

    @Override
    public void setDatatypeHandling(RDFParser.DatatypeHandling datatypeHandling) {
        if (datatypeHandling == RDFParser.DatatypeHandling.VERIFY) {
            this.parserConfig.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, true);
            this.parserConfig.set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, true);
        } else if (datatypeHandling == RDFParser.DatatypeHandling.NORMALIZE) {
            this.parserConfig.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, true);
            this.parserConfig.set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, true);
            this.parserConfig.set(BasicParserSettings.NORMALIZE_DATATYPE_VALUES, true);
        } else if (!(this.parserConfig.isSet(BasicParserSettings.NORMALIZE_DATATYPE_VALUES) || this.parserConfig.isSet(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES) || this.parserConfig.isSet(BasicParserSettings.NORMALIZE_DATATYPE_VALUES))) {
            this.parserConfig.set(BasicParserSettings.VERIFY_DATATYPE_VALUES, false);
            this.parserConfig.set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, false);
            this.parserConfig.set(BasicParserSettings.NORMALIZE_DATATYPE_VALUES, false);
        }
    }

    @Deprecated
    public RDFParser.DatatypeHandling datatypeHandling() {
        return this.parserConfig.datatypeHandling();
    }

    protected void setBaseURI(String uriSpec) {
        ParsedURI baseURI = new ParsedURI(uriSpec);
        baseURI.normalize();
        this.setBaseURI(baseURI);
    }

    protected void setBaseURI(ParsedURI baseURI) {
        this.baseURI = baseURI;
    }

    protected void setNamespace(String prefix, String namespace) {
        this.namespaceTable.put(prefix, namespace);
    }

    protected String getNamespace(String prefix) throws RDFParseException {
        if (this.namespaceTable.containsKey(prefix)) {
            return this.namespaceTable.get(prefix);
        }
        String msg = "Namespace prefix '" + prefix + "' used but not defined";
        if (defaultPrefix.containsKey(prefix)) {
            this.reportError(msg, RDFaParserSettings.FAIL_ON_RDFA_UNDEFINED_PREFIXES);
            return defaultPrefix.get(prefix);
        }
        if ("".equals(prefix)) {
            msg = "Default namespace used but not defined";
        }
        this.reportFatalError(msg);
        throw new RDFParseException(msg);
    }

    protected void clear() {
        this.baseURI = null;
        this.nextBNodePrefix = this.createUniqueBNodePrefix();
        this.namespaceTable.clear();
    }

    @Deprecated
    protected void clearBNodeIDMap() {
    }

    protected URI resolveURI(String uriSpec) throws RDFParseException {
        ParsedURI uri = new ParsedURI(uriSpec);
        if (uri.isRelative()) {
            if (this.baseURI == null) {
                this.reportFatalError("Unable to resolve URIs, no base URI has been set");
            }
            if (this.getParserConfig().get(BasicParserSettings.VERIFY_RELATIVE_URIS).booleanValue() && uri.isRelative() && !uri.isSelfReference() && this.baseURI.isOpaque()) {
                this.reportError("Relative URI '" + uriSpec + "' cannot be resolved using the opaque base URI '" + this.baseURI + "'", BasicParserSettings.VERIFY_RELATIVE_URIS);
            }
            uri = this.baseURI.resolve(uri);
        }
        return this.createURI(uri.toString());
    }

    protected URI createURI(String uri) throws RDFParseException {
        try {
            return this.valueFactory.createURI(uri);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected BNode createBNode() throws RDFParseException {
        try {
            return this.valueFactory.createBNode();
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected BNode createBNode(String nodeID) throws RDFParseException {
        if (this.preserveBNodeIDs()) {
            return this.valueFactory.createBNode(nodeID);
        }
        return this.valueFactory.createBNode(this.nextBNodePrefix + nodeID);
    }

    protected Literal createLiteral(String label, String lang, URI datatype) throws RDFParseException {
        return RDFParserHelper.createLiteral(label, lang, datatype, this.getParserConfig(), this.getParseErrorListener(), this.valueFactory);
    }

    protected Literal createLiteral(String label, String lang, URI datatype, int lineNo, int columnNo) throws RDFParseException {
        return RDFParserHelper.createLiteral(label, lang, datatype, this.getParserConfig(), this.getParseErrorListener(), this.valueFactory, lineNo, columnNo);
    }

    protected Statement createStatement(Resource subj, URI pred, Value obj) throws RDFParseException {
        try {
            return this.valueFactory.createStatement(subj, pred, obj);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected Statement createStatement(Resource subj, URI pred, Value obj, Resource context) throws RDFParseException {
        try {
            return this.valueFactory.createStatement(subj, pred, obj, context);
        }
        catch (Exception e) {
            this.reportFatalError(e);
            return null;
        }
    }

    protected void reportLocation(int lineNo, int columnNo) {
        if (this.locationListener != null) {
            this.locationListener.parseLocationUpdate(lineNo, columnNo);
        }
    }

    protected void reportWarning(String msg) {
        this.reportWarning(msg, -1, -1);
    }

    protected void reportWarning(String msg, int lineNo, int columnNo) {
        if (this.errListener != null) {
            this.errListener.warning(msg, lineNo, columnNo);
        }
    }

    protected void reportError(String msg, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(msg, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportError(String msg, int lineNo, int columnNo, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(msg, lineNo, columnNo, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportError(Exception e, int lineNo, int columnNo, RioSetting<Boolean> relevantSetting) throws RDFParseException {
        RDFParserHelper.reportError(e, lineNo, columnNo, relevantSetting, this.getParserConfig(), this.getParseErrorListener());
    }

    protected void reportFatalError(String msg) throws RDFParseException {
        RDFParserHelper.reportFatalError(msg, this.getParseErrorListener());
    }

    protected void reportFatalError(String msg, int lineNo, int columnNo) throws RDFParseException {
        RDFParserHelper.reportFatalError(msg, lineNo, columnNo, this.getParseErrorListener());
    }

    protected void reportFatalError(Exception e) throws RDFParseException {
        RDFParserHelper.reportFatalError(e, this.getParseErrorListener());
    }

    protected void reportFatalError(Exception e, int lineNo, int columnNo) throws RDFParseException {
        RDFParserHelper.reportFatalError(e, lineNo, columnNo, this.getParseErrorListener());
    }

    private final String createUniqueBNodePrefix() {
        return "genid-" + UUID.randomUUID().toString().replaceAll("-", "") + "-";
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("grddl", "http://www.w3.org/2003/g/data-view#");
        map.put("ma", "http://www.w3.org/ns/ma-ont#");
        map.put("owl", "http://www.w3.org/2002/07/owl#");
        map.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        map.put("rdfa", "http://www.w3.org/ns/rdfa#");
        map.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        map.put("rif", "http://www.w3.org/2007/rif#");
        map.put("skos", "http://www.w3.org/2004/02/skos/core#");
        map.put("skosxl", "http://www.w3.org/2008/05/skos-xl#");
        map.put("wdr", "http://www.w3.org/2007/05/powder#");
        map.put("void", "http://rdfs.org/ns/void#");
        map.put("wdrs", "http://www.w3.org/2007/05/powder-s#");
        map.put("xhv", "http://www.w3.org/1999/xhtml/vocab#");
        map.put("xml", "http://www.w3.org/XML/1998/namespace");
        map.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        defaultPrefix = Collections.unmodifiableMap(new HashMap(map));
    }
}

