/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

class GUIDGenerator {
    private static String MACHINE_DESCRIPTOR = GUIDGenerator.getMachineDescriptor();

    GUIDGenerator() {
    }

    public static String generate() {
        StringBuffer stringBuffer = new StringBuffer();
        GUIDGenerator.encode(stringBuffer, MACHINE_DESCRIPTOR);
        GUIDGenerator.encode(stringBuffer, Runtime.getRuntime());
        GUIDGenerator.encode(stringBuffer, Thread.currentThread());
        GUIDGenerator.encode(stringBuffer, System.currentTimeMillis());
        GUIDGenerator.encode(stringBuffer, GUIDGenerator.getRandomInt());
        return stringBuffer.toString();
    }

    private static String getMachineDescriptor() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("os.name"));
        stringBuffer.append("::");
        stringBuffer.append(System.getProperty("os.arch"));
        stringBuffer.append("::");
        stringBuffer.append(System.getProperty("os.version"));
        stringBuffer.append("::");
        stringBuffer.append(System.getProperty("user.name"));
        stringBuffer.append("::");
        StringBuffer stringBuffer2 = GUIDGenerator.buildNetworkInterfaceDescriptor();
        if (stringBuffer2 != null) {
            stringBuffer.append(stringBuffer2);
        } else {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                stringBuffer.append(inetAddress.getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    private static StringBuffer buildNetworkInterfaceDescriptor() {
        Enumeration<NetworkInterface> enumeration;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (Throwable throwable) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            StringBuffer stringBuffer2 = GUIDGenerator.getMACAddressDescriptor(networkInterface);
            StringBuffer stringBuffer3 = GUIDGenerator.getInetAddressDescriptor(networkInterface);
            StringBuffer stringBuffer4 = new StringBuffer();
            if (stringBuffer2 != null) {
                stringBuffer4.append(stringBuffer2);
            }
            if (stringBuffer3 != null) {
                if (stringBuffer4.length() > 0) {
                    stringBuffer4.append('=');
                }
                stringBuffer4.append(stringBuffer3);
            }
            if (stringBuffer4.length() <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(stringBuffer4);
        }
        return stringBuffer;
    }

    private static StringBuffer getMACAddressDescriptor(NetworkInterface networkInterface) {
        byte[] byArray;
        try {
            byArray = networkInterface.getHardwareAddress();
        }
        catch (Throwable throwable) {
            byArray = null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null) {
            for (int i = 0; i < byArray.length; ++i) {
                String string;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("-");
                }
                if ((string = Integer.toHexString(0xFF & byArray[i])).length() == 1) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer;
    }

    private static StringBuffer getInetAddressDescriptor(NetworkInterface networkInterface) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
        while (enumeration.hasMoreElements()) {
            InetAddress inetAddress = enumeration.nextElement();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(inetAddress.getHostAddress());
        }
        return stringBuffer;
    }

    private static int getRandomInt() {
        return (int)Math.round(Math.random() * 2.147483647E9);
    }

    private static void encode(StringBuffer stringBuffer, Object object) {
        GUIDGenerator.encode(stringBuffer, object.hashCode());
    }

    private static void encode(StringBuffer stringBuffer, int n) {
        String string = Integer.toHexString(n);
        int n2 = string.length();
        for (int i = 8; i > n2; --i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
    }

    private static void encode(StringBuffer stringBuffer, long l) {
        String string = Long.toHexString(l);
        int n = string.length();
        for (int i = 16; i > n; --i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
    }
}

