/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class StereoAudioInputStream
extends AudioInputStream {
    protected int inputChannels;
    protected int outputMode;
    protected AudioFormat newFormat;

    public StereoAudioInputStream(AudioInputStream input) {
        this(input, 3);
    }

    public StereoAudioInputStream(AudioInputStream input, int outputMode) {
        super(input, input.getFormat(), input.getFrameLength());
        this.newFormat = new AudioFormat(input.getFormat().getEncoding(), input.getFormat().getSampleRate(), input.getFormat().getSampleSizeInBits(), 2, 2 * input.getFormat().getFrameSize() / input.getFormat().getChannels(), input.getFormat().getFrameRate(), input.getFormat().isBigEndian());
        this.inputChannels = input.getFormat().getChannels();
        this.outputMode = outputMode;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int sampleSizeInBytes = this.frameSize / this.inputChannels;
        int outputFrameSize = sampleSizeInBytes * 2;
        int nFrames = len / outputFrameSize;
        byte[] inputBytes = new byte[nFrames * this.frameSize];
        int nInputBytes = super.read(inputBytes, 0, inputBytes.length);
        if (nInputBytes <= 0) {
            return nInputBytes;
        }
        if (this.inputChannels == 1) {
            if (this.outputMode == 3) {
                int i = 0;
                int j = off;
                while (i < nInputBytes) {
                    for (int k = 0; k < sampleSizeInBytes; ++k) {
                        byte by = inputBytes[i + k];
                        b[j + sampleSizeInBytes + k] = by;
                        b[j + k] = by;
                    }
                    i += this.frameSize;
                    j += outputFrameSize;
                }
            } else if (this.outputMode == 1) {
                if (!this.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                    throw new IllegalArgumentException("Channel muting supported only for PCM_SIGNED encoding, got " + this.getFormat().getEncoding());
                }
                int i = 0;
                int j = off;
                while (i < nInputBytes) {
                    for (int k = 0; k < sampleSizeInBytes; ++k) {
                        b[j + k] = inputBytes[i + k];
                        b[j + sampleSizeInBytes + k] = 0;
                    }
                    i += this.frameSize;
                    j += outputFrameSize;
                }
            } else {
                assert (this.outputMode == 2) : "Unexpected output mode: " + this.outputMode;
                if (!this.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                    throw new IllegalArgumentException("Channel muting supported only for PCM_SIGNED encoding, got " + this.getFormat().getEncoding());
                }
                int i = 0;
                int j = off;
                while (i < nInputBytes) {
                    for (int k = 0; k < sampleSizeInBytes; ++k) {
                        b[j + k] = 0;
                        b[j + sampleSizeInBytes + k] = inputBytes[i + k];
                    }
                    i += this.frameSize;
                    j += outputFrameSize;
                }
            }
        } else if (this.outputMode == 3) {
            int i = 0;
            int j = off;
            while (i < nInputBytes) {
                System.arraycopy(inputBytes, i, b, j, outputFrameSize);
                i += this.frameSize;
                j += outputFrameSize;
            }
        } else if (this.outputMode == 1) {
            if (!this.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                throw new IllegalArgumentException("Channel muting supported only for PCM_SIGNED encoding, got " + this.getFormat().getEncoding());
            }
            int i = 0;
            int j = off;
            while (i < nInputBytes) {
                for (int k = 0; k < sampleSizeInBytes; ++k) {
                    b[j + k] = inputBytes[i + k];
                    b[j + sampleSizeInBytes + k] = 0;
                }
                i += this.frameSize;
                j += outputFrameSize;
            }
        } else {
            assert (this.outputMode == 2) : "Unexpected output mode: " + this.outputMode;
            if (!this.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                throw new IllegalArgumentException("Channel muting supported only for PCM_SIGNED encoding, got " + this.getFormat().getEncoding());
            }
            int i = 0;
            int j = off;
            while (i < nInputBytes) {
                for (int k = 0; k < sampleSizeInBytes; ++k) {
                    b[j + k] = 0;
                    b[j + sampleSizeInBytes + k] = inputBytes[i + sampleSizeInBytes + k];
                }
                i += this.frameSize;
                j += outputFrameSize;
            }
        }
        return 2 * nInputBytes / this.inputChannels;
    }

    @Override
    public long skip(long n) throws IOException {
        return 2L * super.skip(n / 2L * (long)this.inputChannels);
    }

    @Override
    public int available() throws IOException {
        int av = super.available();
        if (av <= 0) {
            return av;
        }
        return 2 * av / this.inputChannels;
    }

    @Override
    public AudioFormat getFormat() {
        return this.newFormat;
    }
}

