/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import java.util.concurrent.ArrayBlockingQueue;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;

public abstract class ProducingDoubleDataSource
extends BufferedDoubleDataSource
implements Runnable {
    private static final Double END_OF_STREAM = Double.NEGATIVE_INFINITY;
    protected ArrayBlockingQueue<Double> queue = new ArrayBlockingQueue(1024);
    private Thread dataProducingThread = null;
    private boolean hasSentEndOfStream = false;
    private boolean hasReceivedEndOfStream = false;

    protected ProducingDoubleDataSource() {
        this(-1L);
    }

    protected ProducingDoubleDataSource(long numDataThatWillBeProduced) {
        this(numDataThatWillBeProduced, null);
    }

    protected ProducingDoubleDataSource(InlineDataProcessor dataProcessor) {
        this(-1L, dataProcessor);
    }

    protected ProducingDoubleDataSource(long numDataThatWillBeProduced, InlineDataProcessor dataProcessor) {
        super((DoubleDataSource)null, dataProcessor);
        this.dataLength = numDataThatWillBeProduced;
    }

    public void start() {
        this.dataProducingThread = new Thread(this);
        this.dataProducingThread.setDaemon(true);
        this.dataProducingThread.start();
    }

    @Override
    public abstract void run();

    public void putOneDataPoint(double value) {
        try {
            this.queue.put(value);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unexpected interruption", e);
        }
    }

    protected void putEndOfStream() {
        this.putOneDataPoint(END_OF_STREAM);
        this.hasSentEndOfStream = true;
    }

    @Override
    public boolean hasMoreData() {
        this.checkStarted();
        return !this.isAllProductionDataRead() || this.available() > 0;
    }

    @Override
    public int available() {
        this.checkStarted();
        return this.currentlyInBuffer() + this.currentlyInQueue();
    }

    private int currentlyInQueue() {
        if (this.isAllProductionDataRead()) {
            return 0;
        }
        int inQueue = this.queue.size();
        if (this.hasSentEndOfStream && !this.hasReceivedEndOfStream) {
            --inQueue;
        }
        return inQueue;
    }

    @Override
    protected boolean readIntoBuffer(int minLength) {
        int readSum;
        this.checkStarted();
        if (this.isAllProductionDataRead()) {
            return false;
        }
        if (this.bufferSpaceLeft() < minLength) {
            this.increaseBufferSize(minLength + this.currentlyInBuffer());
        } else if (this.buf.length - this.writePos < minLength) {
            this.compact();
        }
        for (readSum = 0; readSum < minLength; ++readSum) {
            double data = this.getOneDataPoint();
            if (data == END_OF_STREAM) {
                this.hasReceivedEndOfStream = true;
                break;
            }
            this.buf[this.writePos] = data;
            ++this.writePos;
        }
        if (this.dataProcessor != null) {
            this.dataProcessor.applyInline(this.buf, this.writePos - readSum, readSum);
        }
        return readSum == minLength;
    }

    private double getOneDataPoint() {
        try {
            return this.queue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unexpected interruption", e);
        }
    }

    private void checkStarted() throws IllegalStateException {
        if (!this.isStarted()) {
            throw new IllegalStateException("Producer thread has not been started -- call start()");
        }
    }

    private boolean isStarted() {
        return this.dataProducingThread != null;
    }

    private boolean isAllProductionDataRead() {
        return this.hasReceivedEndOfStream;
    }
}

