/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.CepstrumSpeechAnalyser;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.analysis.RegularizedPostWarpedCepstrumEstimator;
import marytts.signalproc.analysis.RegularizedPreWarpedCepstrumEstimator;
import marytts.signalproc.analysis.SeevocAnalyser;
import marytts.signalproc.analysis.SpectrumWithPeakIndices;
import marytts.signalproc.sinusoidal.BaseSinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.FreqIndicesWithAmplitudes;
import marytts.signalproc.sinusoidal.NonharmonicSinusoidalSpeechFrame;
import marytts.signalproc.sinusoidal.NonharmonicSinusoidalSpeechSignal;
import marytts.signalproc.sinusoidal.Sinusoid;
import marytts.signalproc.sinusoidal.SinusoidalAnalysisParams;
import marytts.signalproc.sinusoidal.SinusoidalTrack;
import marytts.signalproc.sinusoidal.SinusoidalTracks;
import marytts.signalproc.sinusoidal.TrackGenerator;
import marytts.signalproc.sinusoidal.hntm.analysis.pitch.HnmPitchVoicingAnalyzer;
import marytts.signalproc.sinusoidal.hntm.analysis.pitch.VoicingAnalysisOutputData;
import marytts.signalproc.window.Window;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.io.FileUtils;
import marytts.util.math.ArrayUtils;
import marytts.util.math.ComplexArray;
import marytts.util.math.FFT;
import marytts.util.math.FFTMixedRadix;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class SinusoidalAnalyzer
extends BaseSinusoidalAnalyzer {
    public SinusoidalAnalysisParams params;

    public SinusoidalAnalyzer(SinusoidalAnalysisParams paramsIn) {
        this.params = new SinusoidalAnalysisParams(paramsIn);
    }

    public static int[] setNeighFreq(int fftSize, boolean bAdjustNeighFreqDependent, float fs) {
        int maxFreq = (int)(Math.floor(0.5 * (double)fftSize + 0.5) + 1.0);
        int[] freqSampNeighs = new int[maxFreq];
        if (!bAdjustNeighFreqDependent) {
            for (int i = 0; i < maxFreq; ++i) {
                freqSampNeighs[i] = 2;
            }
        } else {
            int i;
            int[] vals = new int[6];
            float maxSeparationInHz = 100.0f;
            for (i = 0; i < vals.length; ++i) {
                vals[i] = Math.min(i + 1, (int)Math.floor(0.5 * (double)maxSeparationInHz / (double)fs * (double)fftSize + 0.5));
            }
            for (i = 0; i < maxFreq; ++i) {
                float freq = (float)i / ((float)maxFreq - 1.0f) * 0.5f * fs;
                freqSampNeighs[i] = freq < 500.0f ? vals[0] : (freq < 1270.0f ? vals[1] : (freq < 2700.0f ? vals[2] : (freq < 6400.0f ? vals[3] : (freq < 15500.0f ? vals[4] : vals[5]))));
            }
        }
        return freqSampNeighs;
    }

    public SinusoidalTracks analyzeFixedRate(double[] x) {
        return this.analyzeFixedRate(x, 0.02f);
    }

    public SinusoidalTracks analyzeFixedRate(double[] x, float winSizeInSeconds) {
        return this.analyzeFixedRate(x, winSizeInSeconds, 0.01f);
    }

    public SinusoidalTracks analyzeFixedRate(double[] x, float winSizeInSeconds, float skipSizeInSeconds) {
        return this.analyzeFixedRate(x, winSizeInSeconds, skipSizeInSeconds, 50.0f);
    }

    public SinusoidalTracks analyzeFixedRate(double[] x, float winSizeInSeconds, float skipSizeInSeconds, float deltaInHz) {
        return this.analyzeFixedRate(x, winSizeInSeconds, skipSizeInSeconds, deltaInHz, 0);
    }

    public SinusoidalTracks analyzeFixedRate(double[] x, float winSizeInSeconds, float skipSizeInSeconds, float deltaInHz, int spectralEnvelopeType) {
        return this.analyzeFixedRate(x, winSizeInSeconds, skipSizeInSeconds, deltaInHz, spectralEnvelopeType, null, -1.0f, -1.0f);
    }

    public SinusoidalTracks analyzeFixedRate(double[] x, float winSizeInSeconds, float skipSizeInSeconds, float deltaInHz, int spectralEnvelopeType, double[] f0s, float ws_f0, float ss_f0) {
        TrackGenerator tg = new TrackGenerator();
        NonharmonicSinusoidalSpeechSignal sinSignal = this.extractSinusoidsFixedRate(x, winSizeInSeconds, skipSizeInSeconds, deltaInHz, spectralEnvelopeType, f0s, ws_f0, ss_f0);
        SinusoidalTracks sinTracks = tg.generateTracks(sinSignal, deltaInHz, this.params.fs);
        if (sinTracks != null) {
            sinTracks.getTrackStatistics(winSizeInSeconds, skipSizeInSeconds);
            SinusoidalAnalyzer.getGrossStatistics(sinTracks);
        }
        sinTracks.absMaxOriginal = (float)this.params.absMax;
        sinTracks.totalEnergy = (float)this.params.totalEnergy;
        return sinTracks;
    }

    public NonharmonicSinusoidalSpeechSignal extractSinusoidsFixedRate(double[] x, float winSizeInSeconds, float skipSizeInSeconds, float deltaInHz) {
        return this.extractSinusoidsFixedRate(x, winSizeInSeconds, skipSizeInSeconds, deltaInHz, 0);
    }

    public NonharmonicSinusoidalSpeechSignal extractSinusoidsFixedRate(double[] x, float winSizeInSeconds, float skipSizeInSeconds, float deltaInHz, int spectralEnvelopeType) {
        return this.extractSinusoidsFixedRate(x, winSizeInSeconds, skipSizeInSeconds, deltaInHz, spectralEnvelopeType, null, -1.0f, -1.0f);
    }

    public NonharmonicSinusoidalSpeechSignal extractSinusoidsFixedRate(double[] x, float winSizeInSeconds, float skipSizeInSeconds, float deltaInHz, int spectralEnvelopeType, double[] f0s, float ws_f0, float ss_f0) {
        int i;
        this.params.absMax = MathUtils.getAbsMax(x);
        this.params.totalEnergy = SignalProcUtils.energy(x);
        this.params.ws = (int)Math.floor((double)(winSizeInSeconds * (float)this.params.fs) + 0.5);
        if (this.params.ws % 2 == 0) {
            ++this.params.ws;
        }
        this.params.ws = Math.max(this.params.ws, this.params.minWindowSize);
        this.params.ss = (int)Math.floor((double)(skipSizeInSeconds * (float)this.params.fs) + 0.5);
        this.params.win = Window.get(this.params.windowType, this.params.ws);
        this.params.win.normalize(1.0f);
        int totalFrm = (int)(((double)x.length - 0.5 * (double)this.params.ws) / (double)this.params.ss);
        double[] frm = new double[this.params.ws];
        NonharmonicSinusoidalSpeechSignal sinSignal = new NonharmonicSinusoidalSpeechSignal(totalFrm);
        boolean[] isSinusoidNulls = new boolean[totalFrm];
        Arrays.fill(isSinusoidNulls, false);
        int totalNonNull = 0;
        boolean isOutputToTextFile = false;
        for (i = 0; i < totalFrm; ++i) {
            int j;
            Arrays.fill(frm, 0.0);
            for (j = i * this.params.ss; j < Math.min(i * this.params.ss + this.params.ws, x.length); ++j) {
                frm[j - i * this.params.ss] = x[j];
            }
            this.params.win.applyInline(frm, 0, this.params.ws);
            float currentTime = (float)(((double)(i * this.params.ss) + 0.5 * (double)this.params.ws) / (double)this.params.fs);
            if (spectralEnvelopeType == 1 && f0s != null) {
                int f0Ind = (int)Math.floor(((double)currentTime - 0.5 * (double)ws_f0) / (double)ss_f0 + 0.5);
                f0Ind = Math.min(f0Ind, f0s.length - 1);
                f0Ind = Math.max(0, f0Ind);
                boolean isVoiced = false;
                if (f0s[f0Ind] > 10.0) {
                    isVoiced = true;
                }
                sinSignal.framesSins[i] = SinusoidalAnalyzer.analyze_frame(frm, isOutputToTextFile, spectralEnvelopeType, isVoiced, (float)f0s[f0Ind], this.params);
            } else {
                sinSignal.framesSins[i] = SinusoidalAnalyzer.analyze_frame(frm, isOutputToTextFile, spectralEnvelopeType, true, this.params);
            }
            if (sinSignal.framesSins[i] != null) {
                for (j = 0; j < sinSignal.framesSins[i].sinusoids.length; ++j) {
                    sinSignal.framesSins[i].sinusoids[j].frameIndex = i;
                }
            }
            int peakCount = 0;
            if (sinSignal.framesSins[i] == null) {
                isSinusoidNulls[i] = true;
            } else {
                isSinusoidNulls[i] = false;
                ++totalNonNull;
                peakCount = sinSignal.framesSins[i].sinusoids.length;
            }
            if (sinSignal.framesSins[i] == null) continue;
            sinSignal.framesSins[i].time = currentTime;
            System.out.println("Analysis complete at " + String.valueOf(sinSignal.framesSins[i].time) + "s. for frame " + String.valueOf(i + 1) + " of " + String.valueOf(totalFrm) + "(found " + String.valueOf(peakCount) + " peaks)");
        }
        NonharmonicSinusoidalSpeechSignal sinSignal2 = null;
        if (totalNonNull > 0) {
            sinSignal2 = new NonharmonicSinusoidalSpeechSignal(totalNonNull);
            int ind = 0;
            for (i = 0; i < totalFrm; ++i) {
                if (isSinusoidNulls[i]) continue;
                sinSignal2.framesSins[ind] = new NonharmonicSinusoidalSpeechFrame(sinSignal.framesSins[i]);
                if (++ind > totalNonNull - 1) break;
            }
            sinSignal2.originalDurationInSeconds = (float)x.length / (float)this.params.fs;
        }
        return sinSignal2;
    }

    public static void getGrossStatistics(SinusoidalTracks sinTracks) {
        int totalSins = 0;
        for (int i = 0; i < sinTracks.totalTracks; ++i) {
            for (int j = 0; j < sinTracks.tracks[i].totalSins; ++j) {
                if (sinTracks.tracks[i].states[j] != SinusoidalTrack.ACTIVE) continue;
                ++totalSins;
            }
        }
        System.out.println("Total sinusoids to model this file = " + String.valueOf(totalSins));
    }

    public static NonharmonicSinusoidalSpeechFrame analyze_frame(double[] frm, boolean isOutputToTextFile, boolean isVoiced, SinusoidalAnalysisParams params) {
        return SinusoidalAnalyzer.analyze_frame(frm, isOutputToTextFile, 0, isVoiced, -1.0f, params);
    }

    public static NonharmonicSinusoidalSpeechFrame analyze_frame(double[] frm, boolean isOutputToTextFile, int spectralEnvelopeType, boolean isVoiced, SinusoidalAnalysisParams params) {
        if (spectralEnvelopeType == 1) {
            return SinusoidalAnalyzer.analyze_frame(frm, isOutputToTextFile, spectralEnvelopeType, isVoiced, 100.0f, params);
        }
        return SinusoidalAnalyzer.analyze_frame(frm, isOutputToTextFile, spectralEnvelopeType, isVoiced, -1.0f, params);
    }

    public static NonharmonicSinusoidalSpeechFrame analyze_frame(double[] frm, boolean isOutputToTextFile, int spectralEnvelopeType, boolean isVoiced, float f0, SinusoidalAnalysisParams params) {
        return SinusoidalAnalyzer.analyze_frame(frm, isOutputToTextFile, spectralEnvelopeType, isVoiced, f0, -1.0f, false, params, null);
    }

    public static NonharmonicSinusoidalSpeechFrame analyze_frame(double[] windowedFrm, boolean isOutputToTextFile, int spectralEnvelopeType, boolean isVoiced, float f0, float maxFreqOfVoicing, boolean bEstimateHNMVoicing, SinusoidalAnalysisParams params, float[] initialPeakLocationsInHz) {
        int i;
        VoicingAnalysisOutputData vo = null;
        float maxVoicingFreqInHz = 0.0f;
        NonharmonicSinusoidalSpeechFrame frameSins = null;
        if (params.fftSize < windowedFrm.length) {
            params.fftSize = windowedFrm.length;
        }
        if (params.fftSize % 2 == 1) {
            ++params.fftSize;
        }
        int[] freqSampNeighs = SinusoidalAnalyzer.setNeighFreq(params.fftSize, params.bAdjustNeighFreqDependent, params.fs);
        int maxFreqInd = SignalProcUtils.halfSpectrumSize(params.fftSize) - 1;
        ComplexArray frameDft = new ComplexArray(params.fftSize);
        int midPoint = (int)Math.floor(0.5 * (double)windowedFrm.length + 0.5);
        System.arraycopy(windowedFrm, midPoint, frameDft.real, 0, windowedFrm.length - midPoint);
        System.arraycopy(windowedFrm, 0, frameDft.real, params.fftSize - midPoint, midPoint);
        ComplexArray windowedFrameDerivativeFFT = null;
        if (params.bSpectralReassignment) {
            windowedFrameDerivativeFFT = new ComplexArray(params.fftSize);
            double[] dfrm = new double[windowedFrm.length];
            dfrm[0] = windowedFrm[0];
            for (i = 1; i < windowedFrm.length; ++i) {
                dfrm[i] = windowedFrm[i] - windowedFrm[i - 1];
            }
            System.arraycopy(dfrm, midPoint, windowedFrameDerivativeFFT.real, 0, dfrm.length - midPoint);
            System.arraycopy(dfrm, 0, windowedFrameDerivativeFFT.real, params.fftSize - midPoint, midPoint);
        }
        if (MathUtils.isPowerOfTwo(params.fftSize)) {
            FFT.transform(frameDft.real, frameDft.imag, false);
        } else {
            frameDft = FFTMixedRadix.fftComplex(frameDft);
        }
        double[] frameDftAbs = MathUtils.abs(frameDft, 0, maxFreqInd);
        double[] frameDftDB = MathUtils.amp2db(frameDftAbs);
        Object freqIndsLow = null;
        Object freqIndsHigh = null;
        int[] freqInds = null;
        Object freqIndsLowest = null;
        double frmEn = SignalProcUtils.getEnergy(windowedFrm);
        if (frmEn > 1.0E-50) {
            boolean bManualPeakPickingTest = false;
            if (bManualPeakPickingTest) {
                int w;
                int numSins = 0;
                int numNoises = 0;
                float noiseRange1 = 0.0f;
                float noiseRange2 = 0.0f;
                float deltaNoise = 1.0f;
                numSins = 4;
                float[] sinFreqs = new float[numSins];
                sinFreqs[0] = 180.0f;
                sinFreqs[1] = 1580.0f;
                sinFreqs[2] = 2580.0f;
                sinFreqs[3] = 4780.0f;
                freqInds = new int[numSins + numNoises];
                for (w = 0; w < numSins; ++w) {
                    freqInds[w] = SignalProcUtils.freq2index(sinFreqs[w], (double)params.fs, maxFreqInd);
                }
                for (w = numSins; w < numSins + numNoises; ++w) {
                    freqInds[w] = SignalProcUtils.freq2index(noiseRange1 + (float)(w - numSins) * deltaNoise, (double)params.fs, maxFreqInd);
                }
            }
            double[] vocalTractSpec = null;
            if (spectralEnvelopeType == 0) {
                vocalTractSpec = LpcAnalyser.calcSpecFrameLinear(windowedFrm, params.LPOrder, params.fftSize);
            } else if (spectralEnvelopeType == 1) {
                SpectrumWithPeakIndices swpi = SeevocAnalyser.calcSpecEnvelopeLinear(frameDftDB, params.fs, f0);
                vocalTractSpec = swpi.spec;
            } else if (spectralEnvelopeType == 2) {
                SpectrumWithPeakIndices swpi = SeevocAnalyser.calcSpecEnvelopeLinear(frameDftDB, params.fs, f0);
                int cepsOrderPre = 13;
                int cepsOrder = 19;
                int numPeaks = swpi.indices.length;
                double[] linearAmps = new double[numPeaks];
                double[] freqsInHz = new double[numPeaks];
                for (i = 0; i < numPeaks; ++i) {
                    linearAmps[i] = frameDftAbs[swpi.indices[i]];
                    freqsInHz[i] = SignalProcUtils.index2freq(swpi.indices[i], params.fs, maxFreqInd);
                }
                if (params.regularizedCepstrumWarpingMethod == 1) {
                    vocalTractSpec = RegularizedPreWarpedCepstrumEstimator.spectralEnvelopeLinear(linearAmps, freqsInHz, params.fs, cepsOrder, params.fftSize);
                } else if (params.regularizedCepstrumWarpingMethod == 2) {
                    vocalTractSpec = RegularizedPostWarpedCepstrumEstimator.spectralEnvelopeLinear(linearAmps, freqsInHz, params.fs, cepsOrderPre, cepsOrder, params.fftSize);
                }
            }
            if (maxFreqOfVoicing < 0.0f) {
                vo = HnmPitchVoicingAnalyzer.estimateMaxFrequencyOfVoicingsFrame(frameDftDB, params.fs, f0, isVoiced, params.hnmPitchVoicingAnalyzerParams);
                maxVoicingFreqInHz = (float)Math.min((double)vo.maxFreqOfVoicing, 5000.0);
                if (maxVoicingFreqInHz > 0.0f) {
                    maxVoicingFreqInHz = (float)Math.max((double)maxVoicingFreqInHz, 4000.0);
                }
            } else {
                maxVoicingFreqInHz = maxFreqOfVoicing;
            }
            float upperFreqSamplingStepInHz = 100.0f;
            int startIndLow = SignalProcUtils.freq2index(params.startFreq, (double)params.fs, maxFreqInd);
            int endIndLow = SignalProcUtils.freq2index(maxVoicingFreqInHz, (double)params.fs, maxFreqInd);
            int startIndHigh = endIndLow + 1;
            int endIndHigh = SignalProcUtils.freq2index(params.endFreq, (double)params.fs, maxFreqInd);
            int halfF0Ind = SignalProcUtils.freq2index(0.5 * (double)f0, (double)params.fs, maxFreqInd);
            if (initialPeakLocationsInHz != null) {
                freqInds = new int[initialPeakLocationsInHz.length];
                for (i = 0; i < initialPeakLocationsInHz.length; ++i) {
                    freqInds[i] = SignalProcUtils.freq2index(initialPeakLocationsInHz[i], (double)params.fs, maxFreqInd);
                }
            } else if (!bManualPeakPickingTest && !ArrayUtils.isOneOf(freqInds = MathUtils.getExtrema(frameDftDB, freqSampNeighs, freqSampNeighs, true, startIndLow, endIndHigh, -200.0), 0)) {
                freqInds = ArrayUtils.appendToStart(freqInds, 0);
            }
            if (freqInds != null) {
                int numFrameSinusoids = freqInds.length;
                frameSins = new NonharmonicSinusoidalSpeechFrame(numFrameSinusoids);
                FreqIndicesWithAmplitudes fiwa = new FreqIndicesWithAmplitudes(numFrameSinusoids);
                float[] ampsDB = new float[numFrameSinusoids];
                for (i = 0; i < numFrameSinusoids; ++i) {
                    ampsDB[i] = (float)frameDftDB[freqInds[i]];
                }
                if (params.bRefinePeakEstimatesParabola) {
                    fiwa = SinusoidalAnalyzer.refinePeakEstimatesParabola(frameDftDB, freqInds);
                } else {
                    System.arraycopy(ampsDB, 0, fiwa.ampsRefined, 0, numFrameSinusoids);
                    for (i = 0; i < numFrameSinusoids; ++i) {
                        fiwa.freqIndsRefined[i] = freqInds[i];
                    }
                }
                if (params.bSpectralReassignment) {
                    fiwa.freqIndsRefined = SinusoidalAnalyzer.refineBySpectralReassignment(frameDft, windowedFrameDerivativeFFT, fiwa.freqIndsRefined, params.fftSize, params.fs);
                }
                if (initialPeakLocationsInHz == null) {
                    for (i = 0; i < numFrameSinusoids; ++i) {
                        frameSins.sinusoids[i] = new Sinusoid(MathUtils.db2amp(fiwa.ampsRefined[i]), (float)(Math.PI * (double)fiwa.freqIndsRefined[i] / (double)maxFreqInd), (float)Math.atan2(frameDft.imag[freqInds[i]], frameDft.real[freqInds[i]]));
                    }
                } else {
                    for (i = 0; i < numFrameSinusoids; ++i) {
                        frameSins.sinusoids[i] = new Sinusoid((float)frameDftAbs[freqInds[i]], (float)(Math.PI * (double)fiwa.freqIndsRefined[i] / (double)maxFreqInd), (float)Math.atan2(frameDft.imag[freqInds[i]], frameDft.real[freqInds[i]]));
                    }
                }
                if (isOutputToTextFile) {
                    FileUtils.writeToTextFile((double[])vocalTractSpec, (String)"d:/out_vt.txt");
                    FileUtils.writeToTextFile((double[])frameDftAbs, (String)"d:/out_spec.txt");
                }
                double[] vocalTractPhase = null;
                if (vocalTractSpec != null) {
                    double[] tmpSpec = null;
                    tmpSpec = new double[params.fftSize];
                    System.arraycopy(vocalTractSpec, 0, tmpSpec, 0, vocalTractSpec.length);
                    for (i = params.fftSize - 1; i >= vocalTractSpec.length; --i) {
                        tmpSpec[i] = tmpSpec[params.fftSize - i];
                    }
                    tmpSpec = MathUtils.amp2neper(tmpSpec);
                    double[] tmpPhase = CepstrumSpeechAnalyser.minimumPhaseResponseInRadians(tmpSpec);
                    vocalTractPhase = new double[params.fftSize / 2 + 1];
                    System.arraycopy(tmpPhase, 0, vocalTractPhase, 0, vocalTractPhase.length);
                    frameSins.setSystemAmps(vocalTractSpec);
                    frameSins.setSystemPhases(vocalTractPhase);
                    frameSins.setFrameDfts(frameDft);
                    float[] ceps = SignalProcUtils.specLinear2cepstrum(vocalTractSpec, 32);
                    frameSins.setSystemCeps(ceps);
                }
            }
        }
        if (frameSins != null) {
            frameSins.voicing = isVoiced ? 1.0f : 0.0f;
            frameSins.maxFreqOfVoicing = SignalProcUtils.hz2radian(maxVoicingFreqInHz, params.fs);
        }
        return frameSins;
    }

    public static FreqIndicesWithAmplitudes refinePeakEstimatesParabola(double[] powSpecdB, int[] freqInds) {
        FreqIndicesWithAmplitudes fiwa = new FreqIndicesWithAmplitudes(freqInds.length);
        for (int i = 0; i < freqInds.length; ++i) {
            if (freqInds[i] > 0 && freqInds[i] < freqInds.length - 1) {
                double alpha = powSpecdB[freqInds[i] - 1];
                double beta = powSpecdB[freqInds[i]];
                double gamma = powSpecdB[freqInds[i] + 1];
                double p = 0.5 * (alpha - gamma) / (alpha - 2.0 * beta + gamma);
                fiwa.freqIndsRefined[i] = (float)((double)freqInds[i] + p);
                fiwa.ampsRefined[i] = (float)(beta - 0.25 * p * (alpha - gamma));
                continue;
            }
            fiwa.freqIndsRefined[i] = freqInds[i];
            fiwa.ampsRefined[i] = (float)powSpecdB[freqInds[i]];
        }
        return fiwa;
    }

    public static FreqIndicesWithAmplitudes refinePeakEstimatesBias(double[] powSpecdB, float[] freqInds, int windowType) {
        double ZpA;
        double Zpf;
        FreqIndicesWithAmplitudes fiwa = new FreqIndicesWithAmplitudes(freqInds.length);
        double[] c = new double[4];
        switch (windowType) {
            case 3: {
                Zpf = 1.5;
                ZpA = 1.9;
                c[0] = 0.24756;
                c[1] = 0.084372;
                c[2] = -0.090608;
                c[3] = -0.055781;
                break;
            }
            case 1: {
                Zpf = 1.5;
                ZpA = 2.0;
                c[0] = 0.256498;
                c[1] = 0.075977;
                c[2] = -0.116927;
                c[3] = -0.062882;
                break;
            }
            case 2: {
                Zpf = 1.2;
                ZpA = 1.7;
                c[0] = 0.124188;
                c[1] = 0.013752;
                c[2] = -0.038073;
                c[3] = -0.006195;
                break;
            }
            default: {
                Zpf = 2.9;
                ZpA = 3.5;
                c[0] = 1.279369;
                c[1] = 1.756245;
                c[2] = -1.173273;
                c[3] = -3.241966;
            }
        }
        double EZpf = c[0] * Math.pow(Zpf, -2.0) + c[1] * Math.pow(Zpf, -4.0);
        double nZpA = c[2] * Math.pow(ZpA, -4.0) + c[3] * Math.pow(ZpA, -6.0);
        for (int i = 0; i < freqInds.length; ++i) {
            double delHat = fiwa.freqIndsRefined[i] - freqInds[i];
            fiwa.freqIndsRefined[i] = fiwa.freqIndsRefined[i] + (float)(delHat + EZpf * (delHat - 0.5) * (delHat + 0.5) * delHat);
            fiwa.ampsRefined[i] = (float)((double)fiwa.ampsRefined[i] + nZpA * delHat * delHat);
        }
        return fiwa;
    }

    public static float[] refineBySpectralReassignment(ComplexArray windowedFrameFFT, ComplexArray windowedFrameDerivativeFFT, float[] freqInds, int fftSize, int fs) {
        float[] freqIndsRefined = null;
        if (freqInds != null) {
            freqIndsRefined = new float[freqInds.length];
            if (windowedFrameFFT != null && windowedFrameDerivativeFFT != null) {
                int maxFreqInd = fftSize / 2 + 1 - 1;
                for (int i = 0; i < freqInds.length; ++i) {
                    int km = (int)Math.floor((double)freqInds[i] + 0.5);
                    double f0InRadians = SignalProcUtils.hz2radian(SignalProcUtils.index2freq(km, fs, maxFreqInd), fs);
                    double f0RefinedInRadians = f0InRadians - (windowedFrameFFT.real[km] * windowedFrameDerivativeFFT.imag[km] - windowedFrameFFT.imag[km] * windowedFrameDerivativeFFT.real[km]) / (windowedFrameFFT.real[km] * windowedFrameFFT.real[km] + windowedFrameFFT.imag[km] * windowedFrameFFT.imag[km]) / (Math.PI * 2);
                    double f0RefinedInHz = SignalProcUtils.radian2hz(f0RefinedInRadians, fs);
                    freqIndsRefined[i] = (float)SignalProcUtils.freq2indexDouble(f0RefinedInHz, (double)fs, maxFreqInd);
                }
            } else {
                freqIndsRefined = new float[freqInds.length];
                System.arraycopy(freqInds, 0, freqIndsRefined, 0, freqInds.length);
            }
        }
        return freqIndsRefined;
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        double startFreqInHz = 0.0;
        double endFreqInHz = 0.5 * (double)samplingRate;
        int windowType = 1;
        boolean bRefinePeakEstimatesParabola = false;
        boolean bRefinePeakEstimatesBias = false;
        boolean bSpectralReassignment = true;
        boolean bAdjustNeighFreqDependent = false;
        SinusoidalAnalysisParams params = new SinusoidalAnalysisParams(samplingRate, startFreqInHz, endFreqInHz, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent);
        SinusoidalAnalyzer sa = new SinusoidalAnalyzer(params);
        float winSizeInSeconds = 0.02f;
        float skipSizeInSeconds = 0.01f;
        float deltaInHz = 50.0f;
        int spectralEnvelopeType = 1;
        String strPitchFile = args[0].substring(0, args[0].length() - 4) + ".ptc";
        PitchReaderWriter f0 = new PitchReaderWriter(strPitchFile);
        float ws_f0 = (float)f0.header.windowSizeInSeconds;
        float ss_f0 = (float)f0.header.skipSizeInSeconds;
        SinusoidalTracks st = sa.analyzeFixedRate(x, winSizeInSeconds, skipSizeInSeconds, deltaInHz, spectralEnvelopeType, f0.contour, ws_f0, ss_f0);
    }
}

