/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import marytts.signalproc.analysis.Lsfs;
import marytts.signalproc.analysis.MfccFileHeader;
import marytts.util.io.MaryRandomAccessFile;
import marytts.util.io.StreamUtils;

public class Mfccs {
    public double[][] mfccs;
    public MfccFileHeader params;

    public Mfccs() {
        this("");
    }

    public Mfccs(String mfccFile) {
        this.readMfccFile(mfccFile);
    }

    public Mfccs(int numfrmIn, int dimensionIn) {
        this.params = new MfccFileHeader();
        this.allocate(numfrmIn, dimensionIn);
    }

    public void readMfccFile(String mfccFile) {
        this.mfccs = null;
        this.params = new MfccFileHeader();
        if (mfccFile != "") {
            DataInputStream stream = null;
            try {
                stream = this.params.readHeader(mfccFile, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (stream != null) {
                try {
                    this.mfccs = Mfccs.readMfccs(stream, this.params);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void writeMfccFile(String mfccFile) {
        if (mfccFile != "") {
            DataOutputStream stream = null;
            try {
                stream = this.params.writeHeader(mfccFile, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (stream != null) {
                try {
                    Mfccs.writeMfccs(stream, this.mfccs);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void allocate() {
        this.allocate(this.params.numfrm, this.params.dimension);
    }

    public void allocate(int numEntries, int dimension) {
        this.mfccs = null;
        this.params.numfrm = 0;
        this.params.dimension = 0;
        if (numEntries > 0) {
            this.mfccs = new double[numEntries][];
            this.params.numfrm = numEntries;
            if (dimension > 0) {
                this.params.dimension = dimension;
                for (int i = 0; i < numEntries; ++i) {
                    this.mfccs[i] = new double[dimension];
                }
            }
        }
    }

    public static void writeMfccFile(double[][] mfccs, String mfccFileOut, MfccFileHeader params) throws IOException {
        params.numfrm = mfccs.length;
        DataOutputStream stream = params.writeHeader(mfccFileOut, true);
        Mfccs.writeMfccs(stream, mfccs);
    }

    public static void writeMfccsFloat(MaryRandomAccessFile stream, double[][] mfccs) throws IOException {
        if (stream != null && mfccs != null && mfccs.length > 0) {
            for (int i = 0; i < mfccs.length; ++i) {
                for (int j = 0; j < mfccs[i].length; ++j) {
                    stream.writeFloat((float)mfccs[i][j]);
                }
            }
            stream.close();
        }
    }

    public static void writeMfccs(DataOutputStream stream, double[][] mfccs) throws IOException {
        if (stream != null && mfccs != null && mfccs.length > 0) {
            for (int i = 0; i < mfccs.length; ++i) {
                StreamUtils.writeDoubleArray((DataOutput)stream, (double[])mfccs[i]);
            }
            stream.close();
        }
    }

    public static void writeRawMfccFile(double[][] mfccs, String mfccFileOut) throws IOException {
        MaryRandomAccessFile stream = new MaryRandomAccessFile(mfccFileOut, "rw");
        if (stream != null) {
            Mfccs.writeMfccsFloat(stream, mfccs);
            stream.close();
        }
    }

    public static double[][] readMfccsFromFile(String mfccFile) throws IOException {
        MfccFileHeader params = new MfccFileHeader();
        DataInputStream stream = params.readHeader(mfccFile, true);
        return Mfccs.readMfccs(stream, params);
    }

    public static double[][] readMfccs(DataInputStream stream, MfccFileHeader params) throws IOException {
        Object mfccs = null;
        if (stream != null && params.numfrm > 0 && params.dimension > 0) {
            mfccs = new double[params.numfrm][];
            for (int i = 0; i < ((double[][])mfccs).length; ++i) {
                mfccs[i] = StreamUtils.readDoubleArray((DataInput)stream, (int)params.dimension);
            }
            stream.close();
        }
        return mfccs;
    }

    public static double[][] readMfccsFromFloat(MaryRandomAccessFile stream, MfccFileHeader params) throws IOException {
        double[][] mfccs = null;
        if (stream != null && params.numfrm > 0 && params.dimension > 0) {
            mfccs = new double[params.numfrm][params.dimension];
            for (int i = 0; i < mfccs.length; ++i) {
                for (int j = 0; j < mfccs[i].length; ++j) {
                    mfccs[i][j] = stream.readFloat();
                }
            }
            stream.close();
        }
        return mfccs;
    }

    public static void readMfccsFromFloat(MaryRandomAccessFile stream, MfccFileHeader params, double[][] outputMfccs) throws IOException {
        if (stream != null && params.numfrm > 0 && params.dimension > 0) {
            for (int i = 0; i < params.numfrm; ++i) {
                for (int j = 0; j < params.dimension; ++j) {
                    outputMfccs[i][j] = stream.readFloat();
                }
            }
            stream.close();
        }
    }

    public static void main(String[] args) throws Exception {
        Mfccs l1 = new Mfccs();
        l1.params.dimension = 5;
        l1.params.numfrm = 1;
        l1.allocate();
        l1.mfccs[0][0] = 1.5;
        l1.mfccs[0][1] = 2.5;
        l1.mfccs[0][2] = 3.5;
        l1.mfccs[0][3] = 4.5;
        l1.mfccs[0][4] = 5.5;
        String mfccFile = "d:/1.lsf";
        l1.writeMfccFile(mfccFile);
        Lsfs l2 = new Lsfs(mfccFile);
        System.out.println("Test of class Lsfs completed...");
    }
}

