/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import marytts.exceptions.InvalidDataException;
import marytts.signalproc.analysis.AlignmentData;
import marytts.signalproc.analysis.Label;
import marytts.util.dom.DomUtils;
import marytts.util.io.FileUtils;
import marytts.util.string.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class Labels
extends AlignmentData {
    public Label[] items;

    public Labels(Label[] items) {
        this.items = this.deepCopy(items);
    }

    public Labels(String[] lines) {
        this(lines, 3);
    }

    public Labels(String[] lines, int minItemsPerLine) {
        this.initFromLines(lines, minItemsPerLine);
    }

    public Labels(Labels e) {
        if (e != null) {
            this.items = this.deepCopy(e.items);
        }
    }

    public Labels(InputStream in) throws IOException {
        this.initFromStream(in);
    }

    public Labels(String labelFile) throws IOException {
        this.initFromStream(new FileInputStream(labelFile));
    }

    public Labels(Document acoustparams) {
        this.initFromAcoustparams(acoustparams);
    }

    public String[] getLabelSymbols() {
        if (this.items == null) {
            return null;
        }
        String[] symbols = new String[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            symbols[i] = this.items[i].phn;
        }
        return symbols;
    }

    private void initFromStream(InputStream in) throws IOException {
        String allText = FileUtils.getStreamAsString((InputStream)in, (String)"ASCII");
        String[] lines = allText.split("\n");
        this.initFromLines(lines, 3);
    }

    private void initFromLines(String[] lines, int minimumItemsInOneLine) {
        ArrayList<Label> labels = new ArrayList<Label>();
        for (int i = 0; i < lines.length; ++i) {
            String[] labelInfos = lines[i].trim().split("\\s+");
            if (labelInfos.length < minimumItemsInOneLine || !StringUtils.isNumeric((String)labelInfos[0]) || !StringUtils.isNumeric((String)labelInfos[1])) continue;
            Label l = new Label();
            labels.add(l);
            if (labelInfos.length > 0) {
                l.time = Float.parseFloat(labelInfos[0]);
            }
            if (labelInfos.length > 1) {
                l.status = Integer.parseInt(labelInfos[1]);
            }
            if (labelInfos.length > 2) {
                l.phn = labelInfos[2].trim();
            }
            int restStartMin = 4;
            if (labelInfos.length > 3 && StringUtils.isNumeric((String)labelInfos[3])) {
                l.ll = Float.parseFloat(labelInfos[3]);
            } else {
                restStartMin = 3;
                l.ll = Double.NEGATIVE_INFINITY;
            }
            if (labelInfos.length <= restStartMin) continue;
            boolean numericCount = false;
            l.rest = new String[labelInfos.length - restStartMin];
            l.valuesRest = new double[labelInfos.length - restStartMin];
            for (int j = 0; j < l.rest.length; ++j) {
                l.rest[j] = labelInfos[j + restStartMin];
                l.valuesRest[j] = StringUtils.isNumeric((String)l.rest[j]) ? Double.valueOf(l.rest[j]) : Double.NEGATIVE_INFINITY;
            }
        }
        this.items = labels.toArray(new Label[0]);
    }

    private void initFromAcoustparams(Document acoustparams) {
        ArrayList<Label> labels = new ArrayList<Label>();
        String PHONE = "ph";
        String A_PHONE_DURATION = "d";
        String A_PHONE_SYMBOL = "p";
        String A_PHONE_END = "end";
        String BOUNDARY = "boundary";
        String A_BOUNDARY_DURATION = "duration";
        NodeIterator it = DomUtils.createNodeIterator((Node)acoustparams, (String[])new String[]{PHONE, BOUNDARY});
        Element e = null;
        double startTime = 0.0;
        double endTime = 0.0;
        double duration = 0.0;
        double endResetCorrection = 0.0;
        while ((e = (Element)it.nextNode()) != null) {
            String phoneSymbol;
            startTime = endTime;
            if (e.getTagName().equals(PHONE)) {
                phoneSymbol = e.getAttribute(A_PHONE_SYMBOL);
                double endValue = Double.parseDouble(e.getAttribute(A_PHONE_END));
                if (endValue < startTime) {
                    endResetCorrection = startTime;
                }
                endTime = endResetCorrection + endValue;
            } else {
                assert (e.getTagName().equals(BOUNDARY));
                if (!e.hasAttribute(A_BOUNDARY_DURATION)) {
                    throw new InvalidDataException("No duration for boundary");
                }
                duration = 0.001 * Double.parseDouble(e.getAttribute(A_BOUNDARY_DURATION));
                endTime = startTime + duration;
                phoneSymbol = "_";
            }
            labels.add(new Label(endTime, phoneSymbol));
        }
        this.items = labels.toArray(new Label[0]);
    }

    public void print() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].print();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.items.length; ++i) {
            sb.append("(").append(this.items[i]).append(") ");
        }
        sb.append("]");
        return sb.toString();
    }

    public int getLabelIndexAtTime(double time) {
        if (this.items == null) {
            return -1;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (!(this.items[i].time >= time)) continue;
            return i;
        }
        return -1;
    }

    private Label[] deepCopy(Label[] in) {
        if (in == null) {
            return null;
        }
        Label[] out = new Label[in.length];
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == null) continue;
            out[i] = new Label(in[i]);
        }
        return out;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Labels)) {
            return false;
        }
        Labels o = (Labels)other;
        return Arrays.deepEquals(this.items, o.items);
    }

    public int hashCode() {
        return 0;
    }
}

