/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.codebook;

import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.adaptation.BaselineAdaptationSet;
import marytts.signalproc.adaptation.BaselineFeatureExtractor;
import marytts.signalproc.adaptation.BaselinePreprocessor;
import marytts.signalproc.adaptation.codebook.WeightedCodebookFileHeader;
import marytts.signalproc.adaptation.codebook.WeightedCodebookTrainer;
import marytts.signalproc.adaptation.codebook.WeightedCodebookTrainerParams;
import marytts.signalproc.adaptation.outlier.TotalStandardDeviations;
import marytts.signalproc.adaptation.prosody.PitchMappingFile;
import marytts.util.string.StringUtils;

public class WeightedCodebookParallelTrainer
extends WeightedCodebookTrainer {
    public WeightedCodebookParallelTrainer(BaselinePreprocessor pp, BaselineFeatureExtractor fe, WeightedCodebookTrainerParams pa) {
        super(pp, fe, pa);
    }

    @Override
    public void run() throws IOException, UnsupportedAudioFileException {
        if (this.checkParams()) {
            BaselineAdaptationSet sourceTrainingSet = new BaselineAdaptationSet(this.wcParams.sourceTrainingFolder);
            BaselineAdaptationSet targetTrainingSet = new BaselineAdaptationSet(this.wcParams.targetTrainingFolder);
            this.train(sourceTrainingSet, targetTrainingSet);
        }
    }

    public void train(BaselineAdaptationSet sourceTrainingSet, BaselineAdaptationSet targetTrainingSet) throws IOException, UnsupportedAudioFileException {
        int[] map = this.getIndexedMapping(sourceTrainingSet, targetTrainingSet);
        this.train(sourceTrainingSet, targetTrainingSet, map);
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        WeightedCodebookParallelTrainer.mainQuickTest2();
    }

    public static void mainAngryF() throws UnsupportedAudioFileException, IOException {
        BaselinePreprocessor pp = new BaselinePreprocessor();
        BaselineFeatureExtractor fe = new BaselineFeatureExtractor();
        WeightedCodebookTrainerParams pa = new WeightedCodebookTrainerParams();
        pa.codebookHeader.codebookType = WeightedCodebookFileHeader.FRAMES;
        pa.codebookHeader.sourceTag = "neutralF";
        pa.codebookHeader.targetTag = "angryF";
        pa.trainingBaseFolder = "D:/Oytun/DFKI/voices/Interspeech08_out/neutral2angry";
        pa.sourceTrainingFolder = "D:/Oytun/DFKI/voices/Interspeech08/neutral/train_200";
        pa.targetTrainingFolder = "D:/Oytun/DFKI/voices/Interspeech08/angry/train_200";
        pa.indexMapFileExtension = ".imf";
        pa.codebookHeader.lsfParams.dimension = 20;
        pa.codebookHeader.lsfParams.preCoef = 0.97f;
        pa.codebookHeader.lsfParams.skipsize = 0.01f;
        pa.codebookHeader.lsfParams.winsize = 0.02f;
        pa.codebookHeader.lsfParams.windowType = 1;
        String baseFile = StringUtils.checkLastSlash((String)pa.trainingBaseFolder) + pa.codebookHeader.sourceTag + "_X_" + pa.codebookHeader.targetTag;
        pa.codebookFile = baseFile + "_200" + ".wcf";
        pa.pitchMappingFile = baseFile + "_200" + PitchMappingFile.DEFAULT_EXTENSION;
        pa.isForcedAnalysis = false;
        pa.codebookHeader.ptcParams.windowSizeInSeconds = 0.04;
        pa.codebookHeader.ptcParams.skipSizeInSeconds = 0.005;
        pa.codebookHeader.ptcParams.voicingThreshold = 0.3;
        pa.codebookHeader.ptcParams.isDoublingCheck = false;
        pa.codebookHeader.ptcParams.isHalvingCheck = false;
        pa.codebookHeader.ptcParams.minimumF0 = 40.0;
        pa.codebookHeader.ptcParams.maximumF0 = 400.0;
        pa.codebookHeader.ptcParams.centerClippingRatio = 0.3;
        pa.codebookHeader.ptcParams.cutOff1 = pa.codebookHeader.ptcParams.minimumF0 - 20.0;
        pa.codebookHeader.ptcParams.cutOff2 = pa.codebookHeader.ptcParams.maximumF0 + 200.0;
        pa.codebookHeader.energyParams.windowSizeInSeconds = 0.02;
        pa.codebookHeader.energyParams.skipSizeInSeconds = 0.01;
        TotalStandardDeviations tsd = new TotalStandardDeviations();
        tsd.lsf = 1.5;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 2.0;
        pa.gaussianEliminatorParams.isActive = true;
        pa.gaussianEliminatorParams.isCheckLsfOutliers = true;
        pa.gaussianEliminatorParams.isEliminateTooSimilarLsf = true;
        pa.gaussianEliminatorParams.isCheckF0Outliers = true;
        pa.gaussianEliminatorParams.isCheckDurationOutliers = true;
        pa.gaussianEliminatorParams.isCheckEnergyOutliers = true;
        pa.gaussianEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        pa.kmeansEliminatorParams.isActive = true;
        pa.kmeansEliminatorParams.eliminationAlgorithm = 2;
        pa.kmeansEliminatorParams.distanceType = 3;
        pa.kmeansEliminatorParams.isGlobalVariance = true;
        pa.kmeansEliminatorParams.isSeparateClustering = false;
        tsd.general = 0.1;
        pa.kmeansEliminatorParams.numClusters = 30;
        tsd.lsf = 1.0;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 1.0;
        pa.kmeansEliminatorParams.numClustersLsf = 30;
        pa.kmeansEliminatorParams.numClustersF0 = 50;
        pa.kmeansEliminatorParams.numClustersDuration = 5;
        pa.kmeansEliminatorParams.numClustersEnergy = 5;
        pa.kmeansEliminatorParams.isCheckLsfOutliers = true;
        pa.kmeansEliminatorParams.isCheckF0Outliers = false;
        pa.kmeansEliminatorParams.isCheckDurationOutliers = false;
        pa.kmeansEliminatorParams.isCheckEnergyOutliers = false;
        pa.kmeansEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        WeightedCodebookParallelTrainer t = new WeightedCodebookParallelTrainer(pp, fe, pa);
        t.run();
        System.out.println("Training completed...");
    }

    public static void mainHappyF() throws UnsupportedAudioFileException, IOException {
        BaselinePreprocessor pp = new BaselinePreprocessor();
        BaselineFeatureExtractor fe = new BaselineFeatureExtractor();
        WeightedCodebookTrainerParams pa = new WeightedCodebookTrainerParams();
        pa.codebookHeader.codebookType = WeightedCodebookFileHeader.FRAMES;
        pa.codebookHeader.sourceTag = "neutralF";
        pa.codebookHeader.targetTag = "happyF";
        pa.trainingBaseFolder = "D:/Oytun/DFKI/voices/Interspeech08_out/neutral2happy";
        pa.sourceTrainingFolder = "D:/Oytun/DFKI/voices/Interspeech08/neutral/train_200";
        pa.targetTrainingFolder = "D:/Oytun/DFKI/voices/Interspeech08/happy/train_200";
        pa.indexMapFileExtension = ".imf";
        pa.codebookHeader.lsfParams.dimension = 20;
        pa.codebookHeader.lsfParams.preCoef = 0.97f;
        pa.codebookHeader.lsfParams.skipsize = 0.01f;
        pa.codebookHeader.lsfParams.winsize = 0.02f;
        pa.codebookHeader.lsfParams.windowType = 1;
        String baseFile = StringUtils.checkLastSlash((String)pa.trainingBaseFolder) + pa.codebookHeader.sourceTag + "_X_" + pa.codebookHeader.targetTag;
        pa.codebookFile = baseFile + "_200" + ".wcf";
        pa.pitchMappingFile = baseFile + "_200" + PitchMappingFile.DEFAULT_EXTENSION;
        pa.isForcedAnalysis = false;
        pa.codebookHeader.ptcParams.windowSizeInSeconds = 0.04;
        pa.codebookHeader.ptcParams.skipSizeInSeconds = 0.005;
        pa.codebookHeader.ptcParams.voicingThreshold = 0.3;
        pa.codebookHeader.ptcParams.isDoublingCheck = false;
        pa.codebookHeader.ptcParams.isHalvingCheck = false;
        pa.codebookHeader.ptcParams.minimumF0 = 40.0;
        pa.codebookHeader.ptcParams.maximumF0 = 400.0;
        pa.codebookHeader.ptcParams.centerClippingRatio = 0.3;
        pa.codebookHeader.ptcParams.cutOff1 = pa.codebookHeader.ptcParams.minimumF0 - 20.0;
        pa.codebookHeader.ptcParams.cutOff2 = pa.codebookHeader.ptcParams.maximumF0 + 200.0;
        pa.codebookHeader.energyParams.windowSizeInSeconds = 0.02;
        pa.codebookHeader.energyParams.skipSizeInSeconds = 0.01;
        TotalStandardDeviations tsd = new TotalStandardDeviations();
        tsd.lsf = 1.5;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 2.0;
        pa.gaussianEliminatorParams.isActive = true;
        pa.gaussianEliminatorParams.isCheckLsfOutliers = true;
        pa.gaussianEliminatorParams.isEliminateTooSimilarLsf = true;
        pa.gaussianEliminatorParams.isCheckF0Outliers = true;
        pa.gaussianEliminatorParams.isCheckDurationOutliers = true;
        pa.gaussianEliminatorParams.isCheckEnergyOutliers = true;
        pa.gaussianEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        pa.kmeansEliminatorParams.isActive = true;
        pa.kmeansEliminatorParams.eliminationAlgorithm = 2;
        pa.kmeansEliminatorParams.distanceType = 3;
        pa.kmeansEliminatorParams.isGlobalVariance = true;
        pa.kmeansEliminatorParams.isSeparateClustering = false;
        tsd.general = 0.1;
        pa.kmeansEliminatorParams.numClusters = 30;
        tsd.lsf = 1.0;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 1.0;
        pa.kmeansEliminatorParams.numClustersLsf = 30;
        pa.kmeansEliminatorParams.numClustersF0 = 50;
        pa.kmeansEliminatorParams.numClustersDuration = 5;
        pa.kmeansEliminatorParams.numClustersEnergy = 5;
        pa.kmeansEliminatorParams.isCheckLsfOutliers = true;
        pa.kmeansEliminatorParams.isCheckF0Outliers = false;
        pa.kmeansEliminatorParams.isCheckDurationOutliers = false;
        pa.kmeansEliminatorParams.isCheckEnergyOutliers = false;
        pa.kmeansEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        WeightedCodebookParallelTrainer t = new WeightedCodebookParallelTrainer(pp, fe, pa);
        t.run();
        System.out.println("Training completed...");
    }

    public static void mainSadF() throws UnsupportedAudioFileException, IOException {
        BaselinePreprocessor pp = new BaselinePreprocessor();
        BaselineFeatureExtractor fe = new BaselineFeatureExtractor();
        WeightedCodebookTrainerParams pa = new WeightedCodebookTrainerParams();
        pa.codebookHeader.codebookType = WeightedCodebookFileHeader.FRAMES;
        pa.codebookHeader.sourceTag = "neutralF";
        pa.codebookHeader.targetTag = "sadF";
        pa.trainingBaseFolder = "D:/Oytun/DFKI/voices/Interspeech08_out/neutral2sad";
        pa.sourceTrainingFolder = "D:/Oytun/DFKI/voices/Interspeech08/neutral/train_200";
        pa.targetTrainingFolder = "D:/Oytun/DFKI/voices/Interspeech08/sad/train_200";
        pa.indexMapFileExtension = ".imf";
        pa.codebookHeader.lsfParams.dimension = 20;
        pa.codebookHeader.lsfParams.preCoef = 0.97f;
        pa.codebookHeader.lsfParams.skipsize = 0.01f;
        pa.codebookHeader.lsfParams.winsize = 0.02f;
        pa.codebookHeader.lsfParams.windowType = 1;
        String baseFile = StringUtils.checkLastSlash((String)pa.trainingBaseFolder) + pa.codebookHeader.sourceTag + "_X_" + pa.codebookHeader.targetTag;
        pa.codebookFile = baseFile + "_200" + ".wcf";
        pa.pitchMappingFile = baseFile + "_200" + PitchMappingFile.DEFAULT_EXTENSION;
        pa.isForcedAnalysis = false;
        pa.codebookHeader.ptcParams.windowSizeInSeconds = 0.04;
        pa.codebookHeader.ptcParams.skipSizeInSeconds = 0.005;
        pa.codebookHeader.ptcParams.voicingThreshold = 0.3;
        pa.codebookHeader.ptcParams.isDoublingCheck = false;
        pa.codebookHeader.ptcParams.isHalvingCheck = false;
        pa.codebookHeader.ptcParams.minimumF0 = 40.0;
        pa.codebookHeader.ptcParams.maximumF0 = 400.0;
        pa.codebookHeader.ptcParams.centerClippingRatio = 0.3;
        pa.codebookHeader.ptcParams.cutOff1 = pa.codebookHeader.ptcParams.minimumF0 - 20.0;
        pa.codebookHeader.ptcParams.cutOff2 = pa.codebookHeader.ptcParams.maximumF0 + 200.0;
        pa.codebookHeader.energyParams.windowSizeInSeconds = 0.02;
        pa.codebookHeader.energyParams.skipSizeInSeconds = 0.01;
        TotalStandardDeviations tsd = new TotalStandardDeviations();
        tsd.lsf = 1.5;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 2.0;
        pa.gaussianEliminatorParams.isActive = true;
        pa.gaussianEliminatorParams.isCheckLsfOutliers = true;
        pa.gaussianEliminatorParams.isEliminateTooSimilarLsf = true;
        pa.gaussianEliminatorParams.isCheckF0Outliers = true;
        pa.gaussianEliminatorParams.isCheckDurationOutliers = true;
        pa.gaussianEliminatorParams.isCheckEnergyOutliers = true;
        pa.gaussianEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        pa.kmeansEliminatorParams.isActive = true;
        pa.kmeansEliminatorParams.eliminationAlgorithm = 2;
        pa.kmeansEliminatorParams.distanceType = 3;
        pa.kmeansEliminatorParams.isGlobalVariance = true;
        pa.kmeansEliminatorParams.isSeparateClustering = false;
        tsd.general = 0.1;
        pa.kmeansEliminatorParams.numClusters = 30;
        tsd.lsf = 1.0;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 1.0;
        pa.kmeansEliminatorParams.numClustersLsf = 30;
        pa.kmeansEliminatorParams.numClustersF0 = 50;
        pa.kmeansEliminatorParams.numClustersDuration = 5;
        pa.kmeansEliminatorParams.numClustersEnergy = 5;
        pa.kmeansEliminatorParams.isCheckLsfOutliers = true;
        pa.kmeansEliminatorParams.isCheckF0Outliers = false;
        pa.kmeansEliminatorParams.isCheckDurationOutliers = false;
        pa.kmeansEliminatorParams.isCheckEnergyOutliers = false;
        pa.kmeansEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        WeightedCodebookParallelTrainer t = new WeightedCodebookParallelTrainer(pp, fe, pa);
        t.run();
        System.out.println("Training completed...");
    }

    public static void mainQuickTest2() throws UnsupportedAudioFileException, IOException {
        BaselinePreprocessor pp = new BaselinePreprocessor();
        BaselineFeatureExtractor fe = new BaselineFeatureExtractor();
        WeightedCodebookTrainerParams pa = new WeightedCodebookTrainerParams();
        pa.codebookHeader.codebookType = WeightedCodebookFileHeader.FRAMES;
        pa.codebookHeader.sourceTag = "neutralF";
        pa.codebookHeader.targetTag = "angryF";
        pa.trainingBaseFolder = "/project/mary/marcela/VoiceConversion/Neutral-Spike-Conversion/codebook/neutral2angry";
        pa.sourceTrainingFolder = "/project/mary/marcela/VoiceConversion/Neutral-Spike-Conversion/codebook/neutral/train_99";
        pa.targetTrainingFolder = "/project/mary/marcela/VoiceConversion/Neutral-Spike-Conversion/codebook/angry/train_99";
        pa.indexMapFileExtension = ".imf";
        pa.codebookHeader.lsfParams.dimension = 20;
        pa.codebookHeader.lsfParams.preCoef = 0.97f;
        pa.codebookHeader.lsfParams.skipsize = 0.01f;
        pa.codebookHeader.lsfParams.winsize = 0.02f;
        pa.codebookHeader.lsfParams.windowType = 1;
        String baseFile = StringUtils.checkLastSlash((String)pa.trainingBaseFolder) + pa.codebookHeader.sourceTag + "_X_" + pa.codebookHeader.targetTag;
        pa.codebookFile = baseFile + "_99" + ".wcf";
        pa.pitchMappingFile = baseFile + "_99" + PitchMappingFile.DEFAULT_EXTENSION;
        pa.isForcedAnalysis = false;
        pa.codebookHeader.ptcParams.windowSizeInSeconds = 0.04;
        pa.codebookHeader.ptcParams.skipSizeInSeconds = 0.005;
        pa.codebookHeader.ptcParams.voicingThreshold = 0.3;
        pa.codebookHeader.ptcParams.isDoublingCheck = false;
        pa.codebookHeader.ptcParams.isHalvingCheck = false;
        pa.codebookHeader.ptcParams.minimumF0 = 40.0;
        pa.codebookHeader.ptcParams.maximumF0 = 400.0;
        pa.codebookHeader.ptcParams.centerClippingRatio = 0.3;
        pa.codebookHeader.ptcParams.cutOff1 = pa.codebookHeader.ptcParams.minimumF0 - 20.0;
        pa.codebookHeader.ptcParams.cutOff2 = pa.codebookHeader.ptcParams.maximumF0 + 200.0;
        pa.codebookHeader.energyParams.windowSizeInSeconds = 0.02;
        pa.codebookHeader.energyParams.skipSizeInSeconds = 0.01;
        TotalStandardDeviations tsd = new TotalStandardDeviations();
        tsd.lsf = 1.5;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 2.0;
        pa.gaussianEliminatorParams.isActive = true;
        pa.gaussianEliminatorParams.isCheckLsfOutliers = true;
        pa.gaussianEliminatorParams.isEliminateTooSimilarLsf = true;
        pa.gaussianEliminatorParams.isCheckF0Outliers = true;
        pa.gaussianEliminatorParams.isCheckDurationOutliers = true;
        pa.gaussianEliminatorParams.isCheckEnergyOutliers = true;
        pa.gaussianEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        pa.kmeansEliminatorParams.isActive = true;
        pa.kmeansEliminatorParams.eliminationAlgorithm = 2;
        pa.kmeansEliminatorParams.distanceType = 3;
        pa.kmeansEliminatorParams.isGlobalVariance = true;
        pa.kmeansEliminatorParams.isSeparateClustering = false;
        tsd.general = 0.1;
        pa.kmeansEliminatorParams.numClusters = 30;
        tsd.lsf = 1.0;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 1.0;
        pa.kmeansEliminatorParams.numClustersLsf = 30;
        pa.kmeansEliminatorParams.numClustersF0 = 50;
        pa.kmeansEliminatorParams.numClustersDuration = 5;
        pa.kmeansEliminatorParams.numClustersEnergy = 5;
        pa.kmeansEliminatorParams.isCheckLsfOutliers = true;
        pa.kmeansEliminatorParams.isCheckF0Outliers = false;
        pa.kmeansEliminatorParams.isCheckDurationOutliers = false;
        pa.kmeansEliminatorParams.isCheckEnergyOutliers = false;
        pa.kmeansEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        WeightedCodebookParallelTrainer t = new WeightedCodebookParallelTrainer(pp, fe, pa);
        t.run();
        System.out.println("Training completed...");
    }
}

