/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation;

import java.io.IOException;
import marytts.signalproc.adaptation.BaselineFeatureExtractor;
import marytts.signalproc.adaptation.FileMap;
import marytts.signalproc.adaptation.IndexMap;
import marytts.signalproc.analysis.FeatureFileHeader;
import marytts.signalproc.analysis.Labels;
import marytts.signalproc.analysis.LsfFileHeader;
import marytts.signalproc.analysis.MfccFileHeader;
import marytts.util.data.AlignLabelsUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;
import marytts.util.string.StringUtils;

public class AdaptationUtils {
    public static int ALL_AVAILABLE_TRAINING_FRAMES = -1;

    public static IndexMap mapFramesFeatures(String sourceLabelFile, String targetLabelFile, String sourceFeatureFile, String targetFeatureFile, int vocalTractFeature, String[] labelsToExcludeFromTraining) throws IOException {
        int[][] labelMap;
        IndexMap im = null;
        Labels sourceLabels = new Labels(sourceLabelFile);
        Labels targetLabels = new Labels(targetLabelFile);
        FeatureFileHeader hdr1 = null;
        FeatureFileHeader hdr2 = null;
        if (vocalTractFeature == BaselineFeatureExtractor.LSF_FEATURES) {
            hdr1 = new LsfFileHeader(sourceFeatureFile);
            hdr2 = new LsfFileHeader(targetFeatureFile);
        } else if (vocalTractFeature == BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES) {
            hdr1 = new MfccFileHeader(sourceFeatureFile);
            hdr2 = new MfccFileHeader(targetFeatureFile);
        }
        if (hdr1 != null && hdr2 != null && sourceLabels.items != null && targetLabels.items != null && (labelMap = AlignLabelsUtils.alignLabels(sourceLabels.items, targetLabels.items)) != null) {
            int srcLabInd = 0;
            int count = 0;
            im = new IndexMap(1);
            im.files[0] = new FileMap(hdr1.numfrm, 2);
            for (int j = 0; j < hdr1.numfrm; ++j) {
                int tgtLabInd;
                double time1 = SignalProcUtils.frameIndex2Time(j, hdr1.winsize, hdr1.skipsize);
                while (time1 > sourceLabels.items[srcLabInd].time) {
                    if (++srcLabInd <= sourceLabels.items.length - 1) continue;
                    srcLabInd = sourceLabels.items.length - 1;
                    break;
                }
                if ((tgtLabInd = StringUtils.findInMap((int[][])labelMap, (int)srcLabInd)) < 0 || sourceLabels.items[srcLabInd].phn.compareTo(targetLabels.items[tgtLabInd].phn) != 0) continue;
                boolean isLabelDesired = true;
                if (labelsToExcludeFromTraining != null) {
                    boolean bl = isLabelDesired = !StringUtils.isOneOf((String)sourceLabels.items[srcLabInd].phn, (String[])labelsToExcludeFromTraining);
                }
                if (!isLabelDesired) continue;
                double srcStartTime = srcLabInd > 0 ? sourceLabels.items[srcLabInd - 1].time : 0.0;
                double tgtStartTime = tgtLabInd > 0 ? targetLabels.items[tgtLabInd - 1].time : 0.0;
                double srcEndTime = sourceLabels.items[srcLabInd].time;
                double tgtEndTime = targetLabels.items[tgtLabInd].time;
                double time2 = MathUtils.linearMap(time1, srcStartTime, srcEndTime, tgtStartTime, tgtEndTime);
                int tgtFrmInd = SignalProcUtils.time2frameIndex(time2, (double)hdr2.winsize, (double)hdr2.skipsize);
                tgtFrmInd = Math.max(0, tgtFrmInd);
                tgtFrmInd = Math.min(tgtFrmInd, hdr2.numfrm - 1);
                im.files[0].indicesMap[count][0] = j;
                im.files[0].indicesMap[count][1] = tgtFrmInd;
                if (++count > hdr1.numfrm - 1) break;
            }
        }
        return im;
    }

    public static IndexMap mapFrameGroupsFeatures(String sourceLabelFile, String targetLabelFile, String sourceFeatureFile, String targetFeatureFile, int numNeighbours, int vocalTractFeature, String[] labelsToExcludeFromTraining) throws IOException {
        int[][] labelMap;
        IndexMap im = null;
        Labels sourceLabels = new Labels(sourceLabelFile);
        Labels targetLabels = new Labels(targetLabelFile);
        FeatureFileHeader hdr1 = null;
        FeatureFileHeader hdr2 = null;
        if (vocalTractFeature == BaselineFeatureExtractor.LSF_FEATURES) {
            hdr1 = new LsfFileHeader(sourceFeatureFile);
            hdr2 = new LsfFileHeader(targetFeatureFile);
        } else if (vocalTractFeature == BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES) {
            hdr1 = new MfccFileHeader(sourceFeatureFile);
            hdr2 = new MfccFileHeader(targetFeatureFile);
        }
        if (hdr1 != null && hdr2 != null && sourceLabels.items != null && targetLabels.items != null && (labelMap = AlignLabelsUtils.alignLabels(sourceLabels.items, targetLabels.items)) != null) {
            int srcLabInd = 0;
            int count = 0;
            im = new IndexMap(1);
            im.files[0] = new FileMap(hdr1.numfrm, 4);
            for (int j = 0; j < hdr1.numfrm; ++j) {
                int tgtLabInd;
                double time1 = SignalProcUtils.frameIndex2Time(j, hdr1.winsize, hdr1.skipsize);
                while (time1 > sourceLabels.items[srcLabInd].time) {
                    if (++srcLabInd <= sourceLabels.items.length - 1) continue;
                    srcLabInd = sourceLabels.items.length - 1;
                    break;
                }
                if ((tgtLabInd = StringUtils.findInMap((int[][])labelMap, (int)srcLabInd)) < 0 || sourceLabels.items[srcLabInd].phn.compareTo(targetLabels.items[tgtLabInd].phn) != 0) continue;
                boolean isLabelDesired = true;
                if (labelsToExcludeFromTraining != null) {
                    boolean bl = isLabelDesired = !StringUtils.isOneOf((String)sourceLabels.items[srcLabInd].phn, (String[])labelsToExcludeFromTraining);
                }
                if (!isLabelDesired) continue;
                double srcStartTime = srcLabInd > 0 ? sourceLabels.items[srcLabInd - 1].time : 0.0;
                double tgtStartTime = tgtLabInd > 0 ? targetLabels.items[tgtLabInd - 1].time : 0.0;
                double srcEndTime = sourceLabels.items[srcLabInd].time;
                double tgtEndTime = targetLabels.items[tgtLabInd].time;
                double time2 = MathUtils.linearMap(time1, srcStartTime, srcEndTime, tgtStartTime, tgtEndTime);
                int tgtFrmInd = SignalProcUtils.time2frameIndex(time2, (double)hdr2.winsize, (double)hdr2.skipsize);
                im.files[0].indicesMap[count][0] = Math.max(0, j - numNeighbours);
                im.files[0].indicesMap[count][1] = Math.min(j + numNeighbours, hdr1.numfrm - 1);
                im.files[0].indicesMap[count][2] = Math.max(0, tgtFrmInd - numNeighbours);
                im.files[0].indicesMap[count][3] = Math.min(tgtFrmInd + numNeighbours, hdr2.numfrm - 1);
                if (++count > hdr1.numfrm - 1) break;
            }
        }
        return im;
    }

    public static IndexMap mapLabelsFeatures(String sourceLabelFile, String targetLabelFile, String sourceFeatureFile, String targetFeatureFile, int vocalTractFeature, String[] labelsToExcludeFromTraining) throws IOException {
        int[][] labelMap;
        IndexMap im = null;
        Labels sourceLabels = new Labels(sourceLabelFile);
        Labels targetLabels = new Labels(targetLabelFile);
        FeatureFileHeader hdr1 = null;
        FeatureFileHeader hdr2 = null;
        if (vocalTractFeature == BaselineFeatureExtractor.LSF_FEATURES) {
            hdr1 = new LsfFileHeader(sourceFeatureFile);
            hdr2 = new LsfFileHeader(targetFeatureFile);
        } else if (vocalTractFeature == BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES) {
            hdr1 = new MfccFileHeader(sourceFeatureFile);
            hdr2 = new MfccFileHeader(targetFeatureFile);
        }
        if (hdr1 != null && hdr2 != null && sourceLabels.items != null && targetLabels.items != null && (labelMap = AlignLabelsUtils.alignLabels(sourceLabels.items, targetLabels.items)) != null) {
            int count = 0;
            im = new IndexMap(1);
            im.files[0] = new FileMap(sourceLabels.items.length, 4);
            for (int j = 0; j < sourceLabels.items.length; ++j) {
                double srcStartTime = j > 0 ? sourceLabels.items[j - 1].time : 0.0;
                int tgtLabInd = StringUtils.findInMap((int[][])labelMap, (int)j);
                if (tgtLabInd < 0 || sourceLabels.items[j].phn.compareTo(targetLabels.items[tgtLabInd].phn) != 0) continue;
                boolean isLabelDesired = true;
                if (labelsToExcludeFromTraining != null) {
                    boolean bl = isLabelDesired = !StringUtils.isOneOf((String)sourceLabels.items[j].phn, (String[])labelsToExcludeFromTraining);
                }
                if (!isLabelDesired) continue;
                double tgtStartTime = tgtLabInd > 0 ? targetLabels.items[tgtLabInd - 1].time : 0.0;
                double srcEndTime = sourceLabels.items[j].time;
                double tgtEndTime = targetLabels.items[tgtLabInd].time;
                im.files[0].indicesMap[count][0] = SignalProcUtils.time2frameIndex(srcStartTime, (double)hdr1.winsize, (double)hdr1.skipsize);
                im.files[0].indicesMap[count][1] = SignalProcUtils.time2frameIndex(srcEndTime, (double)hdr1.winsize, (double)hdr1.skipsize);
                im.files[0].indicesMap[count][2] = SignalProcUtils.time2frameIndex(tgtStartTime, (double)hdr2.winsize, (double)hdr2.skipsize);
                im.files[0].indicesMap[count][3] = SignalProcUtils.time2frameIndex(tgtEndTime, (double)hdr2.winsize, (double)hdr2.skipsize);
                if (++count > sourceLabels.items.length - 1) break;
            }
        }
        return im;
    }

    public static IndexMap mapLabelGroupsFeatures(String sourceLabelFile, String targetLabelFile, String sourceFeatureFile, String targetFeatureFile, int numNeighbours, int vocalTractFeature, String[] labelsToExcludeFromTraining) throws IOException {
        int[][] labelMap;
        IndexMap im = null;
        Labels sourceLabels = new Labels(sourceLabelFile);
        Labels targetLabels = new Labels(targetLabelFile);
        FeatureFileHeader hdr1 = null;
        FeatureFileHeader hdr2 = null;
        if (vocalTractFeature == BaselineFeatureExtractor.LSF_FEATURES) {
            hdr1 = new LsfFileHeader(sourceFeatureFile);
            hdr2 = new LsfFileHeader(targetFeatureFile);
        } else if (vocalTractFeature == BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES) {
            hdr1 = new MfccFileHeader(sourceFeatureFile);
            hdr2 = new MfccFileHeader(targetFeatureFile);
        }
        if (hdr1 != null && hdr2 != null && sourceLabels.items != null && targetLabels.items != null && (labelMap = AlignLabelsUtils.alignLabels(sourceLabels.items, targetLabels.items)) != null) {
            int count = 0;
            im = new IndexMap(1);
            im.files[0] = new FileMap(sourceLabels.items.length, 4);
            for (int j = 0; j < sourceLabels.items.length; ++j) {
                double srcStartTime = j - numNeighbours - 1 >= 0 ? sourceLabels.items[j - numNeighbours - 1].time : 0.0;
                int tgtLabInd = StringUtils.findInMap((int[][])labelMap, (int)j);
                if (tgtLabInd < 0 || sourceLabels.items[j].phn.compareTo(targetLabels.items[tgtLabInd].phn) != 0) continue;
                boolean isLabelDesired = true;
                if (labelsToExcludeFromTraining != null) {
                    boolean bl = isLabelDesired = !StringUtils.isOneOf((String)sourceLabels.items[j].phn, (String[])labelsToExcludeFromTraining);
                }
                if (!isLabelDesired) continue;
                double tgtStartTime = tgtLabInd - numNeighbours - 1 >= 0 ? targetLabels.items[tgtLabInd - numNeighbours - 1].time : 0.0;
                double srcEndTime = sourceLabels.items[Math.min((int)(j + numNeighbours), (int)(sourceLabels.items.length - 1))].time;
                double tgtEndTime = targetLabels.items[Math.min((int)(tgtLabInd + numNeighbours), (int)(targetLabels.items.length - 1))].time;
                im.files[0].indicesMap[count][0] = SignalProcUtils.time2frameIndex(srcStartTime, (double)hdr1.winsize, (double)hdr1.skipsize);
                im.files[0].indicesMap[count][1] = SignalProcUtils.time2frameIndex(srcEndTime, (double)hdr1.winsize, (double)hdr1.skipsize);
                im.files[0].indicesMap[count][2] = SignalProcUtils.time2frameIndex(tgtStartTime, (double)hdr2.winsize, (double)hdr2.skipsize);
                im.files[0].indicesMap[count][3] = SignalProcUtils.time2frameIndex(tgtEndTime, (double)hdr2.winsize, (double)hdr2.skipsize);
                if (++count > sourceLabels.items.length - 1) break;
            }
        }
        return im;
    }

    public static IndexMap mapSpeechFeatures() {
        IndexMap im = new IndexMap(1);
        im.files[0] = new FileMap(1, 1);
        im.files[0].indicesMap[0][0] = ALL_AVAILABLE_TRAINING_FRAMES;
        return im;
    }
}

