/*
 * Decompiled with CFR 0.152.
 */
package marytts.machinelearning;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import marytts.machinelearning.GMMTrainerParams;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.util.io.MaryRandomAccessFile;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;
import marytts.util.string.StringUtils;

public class ContextualGMMParams {
    public static final int FRICATIVE = Integer.parseInt("000000000001", 2);
    public static final int GLIDE = Integer.parseInt("000000000010", 2);
    public static final int LIQUID = Integer.parseInt("000000000100", 2);
    public static final int NASAL = Integer.parseInt("000000001000", 2);
    public static final int PAUSE = Integer.parseInt("000000010000", 2);
    public static final int PLOSIVE = Integer.parseInt("000000100000", 2);
    public static final int SONORANT = Integer.parseInt("000001000000", 2);
    public static final int SYLLABIC = Integer.parseInt("000010000000", 2);
    public static final int VOICED = Integer.parseInt("000100000000", 2);
    public static final int VOWEL = Integer.parseInt("001000000000", 2);
    public int contextClassificationType;
    public static final int NO_PHONEME_CLASS = -1;
    public static final int SILENCE_SPEECH = 1;
    public static final int VOWEL_SILENCE_CONSONANT = 2;
    public static final int PHONOLOGY_CLASS = 3;
    public static final int FRICATIVE_GLIDELIQUID_NASAL_PLOSIVE_VOWEL_OTHER = 4;
    public static final int PHONEME_IDENTITY = 5;
    public static final int FRICATIVE_MULTIPLIER = 1;
    public static final int GLIDELIQUID_MULTIPLIER = 1;
    public static final int NASAL_MULTIPLIER = 1;
    public static final int PLOSIVE_MULTIPLIER = 1;
    public static final int VOWEL_MULTIPLIER = 8;
    public static final int OTHER_MULTIPLIER = 1;
    public static final int CONSONANT_MULTIPLIER = 4;
    public static final int SILENCE_MULTIPLIER = 1;
    public static final int SPEECH_MULTIPLIER = 8;
    public String[][] phoneClasses;
    public GMMTrainerParams[] classTrainerParams;

    public ContextualGMMParams() {
        this(null, null);
    }

    public ContextualGMMParams(AllophoneSet allophoneSet, GMMTrainerParams commonParams) {
        this(allophoneSet, commonParams, -1);
    }

    public ContextualGMMParams(AllophoneSet allophoneSet, GMMTrainerParams commonParams, int contextClassificationTypeIn) {
        this.contextClassificationType = contextClassificationTypeIn;
        if (allophoneSet != null) {
            Set tmpPhonemes = allophoneSet.getAllophoneNames();
            this.allocate(tmpPhonemes.size());
            int count = 0;
            Allophone[] phns = new Allophone[tmpPhonemes.size()];
            Iterator it = tmpPhonemes.iterator();
            while (it.hasNext()) {
                phns[count] = allophoneSet.getAllophone((String)it.next());
                if (++count < tmpPhonemes.size()) continue;
            }
            this.setClasses(phns, commonParams);
        } else {
            this.allocate(0);
        }
    }

    public static Allophone[] getAllophones(AllophoneSet allophoneSet) {
        Set tmpPhonemes = allophoneSet.getAllophoneNames();
        int count = 0;
        Allophone[] phns = new Allophone[tmpPhonemes.size()];
        Iterator it = tmpPhonemes.iterator();
        while (it.hasNext()) {
            phns[count] = allophoneSet.getAllophone((String)it.next());
            if (++count < tmpPhonemes.size()) continue;
            break;
        }
        return phns;
    }

    public ContextualGMMParams(AllophoneSet allophoneSet, GMMTrainerParams[] params, int contextClassificationTypeIn) {
        this.contextClassificationType = contextClassificationTypeIn;
        if (allophoneSet != null) {
            Allophone[] phns = ContextualGMMParams.getAllophones(allophoneSet);
            this.allocate(phns.length);
            this.setClasses(phns, params);
        } else {
            this.allocate(0);
        }
    }

    public ContextualGMMParams(int numPhonemeClasses) {
        this.allocate(numPhonemeClasses);
    }

    public ContextualGMMParams(ContextualGMMParams existing) {
        if (existing != null) {
            if (existing.phoneClasses != null && existing.classTrainerParams != null && existing.phoneClasses.length == existing.classTrainerParams.length) {
                this.allocate(existing.phoneClasses.length);
                this.setClasses(existing.phoneClasses, existing.classTrainerParams);
            } else {
                this.allocate(0);
            }
        } else {
            this.allocate(0);
        }
    }

    public void allocate(int numPhonemeClasses) {
        if (numPhonemeClasses > 0) {
            this.phoneClasses = new String[numPhonemeClasses][];
            this.classTrainerParams = new GMMTrainerParams[numPhonemeClasses];
            for (int i = 0; i < numPhonemeClasses; ++i) {
                this.classTrainerParams[i] = new GMMTrainerParams();
            }
        } else {
            this.phoneClasses = null;
            this.classTrainerParams = null;
        }
    }

    public void setClassFromSinglePhoneme(int classIndex, String phone) {
        this.setClassFromSinglePhoneme(classIndex, phone, null);
    }

    public void setClassFromSinglePhoneme(int classIndex, String phone, GMMTrainerParams currentClassTrainerParams) {
        String[] phones = new String[]{phone};
        this.setClass(classIndex, phones, currentClassTrainerParams);
    }

    public void setClasses(String[][] phoneClassesIn) {
        if (phoneClassesIn != null) {
            for (int i = 0; i < phoneClassesIn.length; ++i) {
                this.setClass(i, phoneClassesIn[i], null);
            }
        }
    }

    public void setClasses(String[][] phoneClassesIn, GMMTrainerParams[] classTrainerParamsIn) {
        if (phoneClassesIn != null && classTrainerParamsIn != null) {
            for (int i = 0; i < Math.min(phoneClassesIn.length, classTrainerParamsIn.length); ++i) {
                this.setClass(i, phoneClassesIn[i], classTrainerParamsIn[i]);
            }
        }
    }

    public void setClasses(Allophone[] phns, GMMTrainerParams commonParams) {
        GMMTrainerParams[] params = new GMMTrainerParams[]{new GMMTrainerParams(commonParams)};
        this.setClasses(phns, params);
    }

    public void setClasses(Allophone[] phns, GMMTrainerParams[] params) {
        if (phns != null) {
            if (this.contextClassificationType == -1) {
                this.phoneClasses = new String[1][phns.length];
                this.classTrainerParams = new GMMTrainerParams[1];
                this.classTrainerParams[0] = new GMMTrainerParams(params[0]);
                for (int i = 0; i < phns.length; ++i) {
                    this.phoneClasses[0][i] = phns[i].name();
                }
            } else if (this.contextClassificationType == 1) {
                int j;
                int i;
                int[] phonologyClasses = ContextualGMMParams.getPhonologyClasses(phns);
                int[] differentPhonologyClasses = StringUtils.getDifferentItemsList((int[])phonologyClasses);
                int[][] inds = new int[2][];
                inds[0] = ContextualGMMParams.findIndices(phonologyClasses, PAUSE);
                int totalOther = 0;
                for (i = 0; i < phonologyClasses.length; ++i) {
                    boolean bFound = false;
                    for (j = 0; j < inds.length - 1; ++j) {
                        if (MathUtils.find(inds[j], 0, i) == null) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    ++totalOther;
                }
                int count = 0;
                if (totalOther > 0) {
                    inds[1] = new int[totalOther];
                    for (i = 0; i < phonologyClasses.length; ++i) {
                        boolean bFound = false;
                        for (j = 0; j < inds.length - 1; ++j) {
                            if (MathUtils.find(inds[j], 0, i) == null) continue;
                            bFound = true;
                            break;
                        }
                        if (!bFound) {
                            inds[1][count] = i;
                            ++count;
                        }
                        if (count >= totalOther) break;
                    }
                }
                int total = 0;
                for (i = 0; i < inds.length; ++i) {
                    if (inds[i] == null) continue;
                    ++total;
                }
                this.phoneClasses = new String[total][];
                this.classTrainerParams = new GMMTrainerParams[total];
                count = 0;
                for (i = 0; i < total; ++i) {
                    if (inds[i] == null) continue;
                    this.phoneClasses[count] = new String[inds[i].length];
                    for (j = 0; j < inds[i].length; ++j) {
                        this.phoneClasses[count][j] = phns[inds[i][j]].name();
                    }
                    this.classTrainerParams[count] = i < params.length ? new GMMTrainerParams(params[i]) : new GMMTrainerParams(params[0]);
                    if (i == 0) {
                        this.classTrainerParams[count].totalComponents *= 1;
                    } else if (i == 1) {
                        this.classTrainerParams[count].totalComponents *= 8;
                    }
                    ++count;
                }
            } else if (this.contextClassificationType == 2) {
                int j;
                int i;
                int[] phonologyClasses = ContextualGMMParams.getPhonologyClasses(phns);
                int[] differentPhonologyClasses = StringUtils.getDifferentItemsList((int[])phonologyClasses);
                int[][] inds = new int[3][];
                inds[0] = ContextualGMMParams.findIndices(phonologyClasses, VOWEL);
                inds[1] = ContextualGMMParams.findIndices(phonologyClasses, PAUSE);
                int totalOther = 0;
                for (i = 0; i < phonologyClasses.length; ++i) {
                    boolean bFound = false;
                    for (j = 0; j < inds.length - 1; ++j) {
                        if (MathUtils.find(inds[j], 0, i) == null) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    ++totalOther;
                }
                int count = 0;
                if (totalOther > 0) {
                    inds[2] = new int[totalOther];
                    for (i = 0; i < phonologyClasses.length; ++i) {
                        boolean bFound = false;
                        for (j = 0; j < inds.length - 1; ++j) {
                            if (MathUtils.find(inds[j], 0, i) == null) continue;
                            bFound = true;
                            break;
                        }
                        if (!bFound) {
                            inds[2][count] = i;
                            ++count;
                        }
                        if (count >= totalOther) break;
                    }
                }
                int total = 0;
                for (i = 0; i < inds.length; ++i) {
                    if (inds[i] == null) continue;
                    ++total;
                }
                this.phoneClasses = new String[total][];
                this.classTrainerParams = params != null ? new GMMTrainerParams[total] : null;
                count = 0;
                for (i = 0; i < total; ++i) {
                    if (inds[i] == null) continue;
                    this.phoneClasses[count] = new String[inds[i].length];
                    for (j = 0; j < inds[i].length; ++j) {
                        this.phoneClasses[count][j] = phns[inds[i][j]].name();
                    }
                    if (params != null) {
                        this.classTrainerParams[count] = i < params.length ? new GMMTrainerParams(params[i]) : new GMMTrainerParams(params[0]);
                        if (i == 0) {
                            this.classTrainerParams[count].totalComponents *= 8;
                        } else if (i == 1) {
                            this.classTrainerParams[count].totalComponents *= 1;
                        } else if (i == 2) {
                            this.classTrainerParams[count].totalComponents *= 4;
                        }
                    }
                    ++count;
                }
            } else if (this.contextClassificationType == 3) {
                int[] phonologyClasses = ContextualGMMParams.getPhonologyClasses(phns);
                int[] differentPhonologyClasses = StringUtils.getDifferentItemsList((int[])phonologyClasses);
                this.phoneClasses = new String[differentPhonologyClasses.length][];
                this.classTrainerParams = new GMMTrainerParams[differentPhonologyClasses.length];
                for (int i = 0; i < differentPhonologyClasses.length; ++i) {
                    int[] indices = MathUtils.find(phonologyClasses, 0, differentPhonologyClasses[i]);
                    this.phoneClasses[i] = new String[indices.length];
                    this.classTrainerParams[i] = i < params.length ? new GMMTrainerParams(params[i]) : new GMMTrainerParams(params[0]);
                    for (int j = 0; j < indices.length; ++j) {
                        this.phoneClasses[i][j] = phns[indices[j]].name();
                    }
                }
            } else if (this.contextClassificationType == 4) {
                int j;
                int i;
                int[] phonologyClasses = ContextualGMMParams.getPhonologyClasses(phns);
                int[] differentPhonologyClasses = StringUtils.getDifferentItemsList((int[])phonologyClasses);
                int[][] inds = new int[6][];
                inds[0] = ContextualGMMParams.findIndices(phonologyClasses, FRICATIVE);
                int[] tmpInds1 = ContextualGMMParams.findIndices(phonologyClasses, GLIDE);
                int[] tmpInds2 = ContextualGMMParams.findIndices(phonologyClasses, LIQUID);
                int[] tmpInds = SignalProcUtils.merge(tmpInds1, tmpInds2);
                MathUtils.quickSort(tmpInds);
                inds[1] = StringUtils.getDifferentItemsList((int[])tmpInds);
                inds[2] = ContextualGMMParams.findIndices(phonologyClasses, NASAL);
                inds[3] = ContextualGMMParams.findIndices(phonologyClasses, PLOSIVE);
                inds[4] = ContextualGMMParams.findIndices(phonologyClasses, VOWEL);
                int totalOther = 0;
                for (i = 0; i < phonologyClasses.length; ++i) {
                    boolean bFound = false;
                    for (j = 0; j < inds.length - 1; ++j) {
                        if (MathUtils.find(inds[j], 0, i) == null) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) continue;
                    ++totalOther;
                }
                int count = 0;
                if (totalOther > 0) {
                    inds[5] = new int[totalOther];
                    for (i = 0; i < phonologyClasses.length; ++i) {
                        boolean bFound = false;
                        for (j = 0; j < inds.length - 1; ++j) {
                            if (MathUtils.find(inds[j], 0, i) == null) continue;
                            bFound = true;
                            break;
                        }
                        if (!bFound) {
                            inds[5][count] = i;
                            ++count;
                        }
                        if (count >= totalOther) break;
                    }
                }
                int total = 0;
                for (i = 0; i < inds.length; ++i) {
                    if (inds[i] == null) continue;
                    ++total;
                }
                this.phoneClasses = new String[total][];
                this.classTrainerParams = new GMMTrainerParams[total];
                count = 0;
                for (i = 0; i < total; ++i) {
                    if (inds[i] == null) continue;
                    this.phoneClasses[count] = new String[inds[i].length];
                    for (j = 0; j < inds[i].length; ++j) {
                        this.phoneClasses[count][j] = phns[inds[i][j]].name();
                    }
                    this.classTrainerParams[count] = i < params.length ? new GMMTrainerParams(params[i]) : new GMMTrainerParams(params[0]);
                    if (i == 0) {
                        this.classTrainerParams[count].totalComponents *= 1;
                    } else if (i == 1) {
                        this.classTrainerParams[count].totalComponents *= 1;
                    } else if (i == 2) {
                        this.classTrainerParams[count].totalComponents *= 1;
                    } else if (i == 3) {
                        this.classTrainerParams[count].totalComponents *= 1;
                    } else if (i == 4) {
                        this.classTrainerParams[count].totalComponents *= 8;
                    } else if (i == 5) {
                        this.classTrainerParams[count].totalComponents *= 1;
                    }
                    ++count;
                }
            } else if (this.contextClassificationType == 5) {
                int i;
                String[] allPhonemes = new String[phns.length];
                for (i = 0; i < phns.length; ++i) {
                    allPhonemes[i] = phns[i].name();
                }
                String[] differentPhonemes = StringUtils.getDifferentItemsList((String[])allPhonemes);
                this.phoneClasses = new String[differentPhonemes.length][1];
                this.classTrainerParams = new GMMTrainerParams[differentPhonemes.length];
                for (i = 0; i < differentPhonemes.length; ++i) {
                    this.phoneClasses[i][0] = differentPhonemes[i];
                    this.classTrainerParams[i] = i < params.length ? new GMMTrainerParams(params[i]) : new GMMTrainerParams(params[0]);
                }
            } else {
                this.phoneClasses = null;
                this.classTrainerParams = null;
            }
        }
    }

    public static int[] getPhonologyClasses(Allophone[] phns) {
        int[] phonologyClasses = null;
        if (phns != null) {
            phonologyClasses = new int[phns.length];
            for (int i = 0; i < phns.length; ++i) {
                phonologyClasses[i] = 0;
                if (phns[i].isFricative()) {
                    int n = i;
                    phonologyClasses[n] = phonologyClasses[n] + FRICATIVE;
                }
                if (phns[i].isGlide()) {
                    int n = i;
                    phonologyClasses[n] = phonologyClasses[n] + GLIDE;
                }
                if (phns[i].isLiquid()) {
                    int n = i;
                    phonologyClasses[n] = phonologyClasses[n] + LIQUID;
                }
                if (phns[i].isNasal()) {
                    int n = i;
                    phonologyClasses[n] = phonologyClasses[n] + NASAL;
                }
                if (phns[i].isPause()) {
                    int n = i;
                    phonologyClasses[n] = phonologyClasses[n] + PAUSE;
                }
                if (phns[i].isPlosive()) {
                    int n = i;
                    phonologyClasses[n] = phonologyClasses[n] + PLOSIVE;
                }
                if (phns[i].isSonorant()) {
                    int n = i;
                    phonologyClasses[n] = phonologyClasses[n] + SONORANT;
                }
                if (phns[i].isSyllabic()) {
                    int n = i;
                    phonologyClasses[n] = phonologyClasses[n] + SYLLABIC;
                }
                if (phns[i].isVoiced()) {
                    int n = i;
                    phonologyClasses[n] = phonologyClasses[n] + VOICED;
                }
                if (!phns[i].isVowel()) continue;
                int n = i;
                phonologyClasses[n] = phonologyClasses[n] + VOWEL;
            }
        }
        return phonologyClasses;
    }

    public static int[] findIndices(int[] phonologyClasses, int desiredClasses) {
        int i;
        int[] indices = null;
        boolean[] desireds = new boolean[phonologyClasses.length];
        int total = 0;
        for (i = 0; i < phonologyClasses.length; ++i) {
            desireds[i] = StringUtils.isDesired((int)phonologyClasses[i], (int)desiredClasses);
            if (!desireds[i]) continue;
            ++total;
        }
        if (total > 0) {
            indices = new int[total];
            int count = 0;
            for (i = 0; i < desireds.length; ++i) {
                if (!desireds[i]) continue;
                indices[count] = i;
                if (++count >= total) break;
            }
        }
        return indices;
    }

    public void setClass(int classIndex, String[] phones) {
        this.setClass(classIndex, phones, null);
    }

    public void setClass(int classIndex, String[] phones, GMMTrainerParams currentClassTrainerParams) {
        if (this.phoneClasses != null && this.classTrainerParams != null && classIndex >= 0 && classIndex < this.phoneClasses.length && this.phoneClasses.length == this.classTrainerParams.length) {
            this.phoneClasses[classIndex] = null;
            if (phones != null) {
                this.phoneClasses[classIndex] = new String[phones.length];
                for (int i = 0; i < phones.length; ++i) {
                    this.phoneClasses[classIndex][i] = phones[i];
                }
            }
            this.classTrainerParams[classIndex] = new GMMTrainerParams(currentClassTrainerParams);
        }
    }

    public int getClassIndex(String phone) {
        int classInd = -1;
        if (this.phoneClasses != null) {
            for (int i = 0; i < this.phoneClasses.length; ++i) {
                if (this.phoneClasses[i] == null) continue;
                for (int j = 0; j < this.phoneClasses[i].length; ++j) {
                    if (phone.compareTo(this.phoneClasses[i][j]) != 0) continue;
                    return i;
                }
            }
        }
        return classInd;
    }

    public void write(MaryRandomAccessFile stream) {
        block31: {
            if (stream == null) break block31;
            if (this.phoneClasses != null) {
                int i;
                try {
                    stream.writeInt(this.phoneClasses.length);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (i = 0; i < this.phoneClasses.length; ++i) {
                    if (this.phoneClasses[i].length > 0) {
                        try {
                            stream.writeInt(this.phoneClasses[i].length);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        for (int j = 0; j < this.phoneClasses[i].length; ++j) {
                            if (this.phoneClasses[i][j].length() > 0) {
                                try {
                                    stream.writeInt(this.phoneClasses[i][j].length());
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                try {
                                    stream.writeChar(this.phoneClasses[i][j].toCharArray());
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                                continue;
                            }
                            try {
                                stream.writeInt(0);
                                continue;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        continue;
                    }
                    try {
                        stream.writeInt(0);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.classTrainerParams != null) {
                    if (this.classTrainerParams.length > 0) {
                        try {
                            stream.writeInt(this.classTrainerParams.length);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        for (i = 0; i < this.classTrainerParams.length; ++i) {
                            this.classTrainerParams[i].write(stream);
                        }
                    } else {
                        try {
                            stream.writeInt(0);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    try {
                        stream.writeInt(0);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    stream.writeInt(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void read(MaryRandomAccessFile stream) {
        if (stream != null) {
            int tmpLen = 0;
            try {
                tmpLen = stream.readInt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (tmpLen > 0) {
                this.phoneClasses = new String[tmpLen][];
            }
            if (this.phoneClasses != null) {
                int i;
                for (i = 0; i < this.phoneClasses.length; ++i) {
                    tmpLen = 0;
                    try {
                        tmpLen = stream.readInt();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (tmpLen > 0) {
                        this.phoneClasses[i] = new String[tmpLen];
                    }
                    if (this.phoneClasses[i].length <= 0) continue;
                    for (int j = 0; j < this.phoneClasses[i].length; ++j) {
                        try {
                            tmpLen = stream.readInt();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (tmpLen <= 0) continue;
                        try {
                            this.phoneClasses[i][j] = String.copyValueOf(stream.readChar(tmpLen));
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                tmpLen = 0;
                try {
                    tmpLen = stream.readInt();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.classTrainerParams = null;
                if (tmpLen > 0) {
                    this.classTrainerParams = new GMMTrainerParams[tmpLen];
                }
                if (this.classTrainerParams.length > 0) {
                    for (i = 0; i < this.classTrainerParams.length; ++i) {
                        this.classTrainerParams[i] = new GMMTrainerParams(stream);
                    }
                }
            }
        }
    }
}

