/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.zlib;

import io.netty.buffer.ByteBuf;
import io.nodyn.CallbackResult;
import io.nodyn.NodeProcess;
import io.nodyn.handle.HandleWrap;
import io.nodyn.zlib.Flush;
import io.nodyn.zlib.Level;
import io.nodyn.zlib.Mode;
import io.nodyn.zlib.Strategy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;

public class NodeZlib
extends HandleWrap {
    private Mode mode;
    private int strategy;
    private byte[] dictionary;
    private int level;
    private AtomicBoolean initDone = new AtomicBoolean(false);
    private AtomicBoolean writeInProgress = new AtomicBoolean(false);
    private AtomicBoolean closed = new AtomicBoolean(false);
    private AtomicBoolean pendingClose = new AtomicBoolean(false);

    public NodeZlib(NodeProcess process, int mode) {
        super(process, false);
        this.mode = Mode.values()[mode];
    }

    public void init(int windowBits, int level, int memLevel, int strategy, byte[] dictionary) {
        this.level = level;
        this.strategy = Strategy.mapDeflaterStrategy(strategy);
        this.dictionary = dictionary;
        this.initDone.set(true);
        this.ref();
    }

    public void params(int level, int strategy) {
        this.level = level;
        this.strategy = Strategy.mapDeflaterStrategy(strategy);
    }

    public void reset() {
        this.level = Level.Z_DEFAULT_COMPRESSION.ordinal();
        this.strategy = Strategy.Z_DEFAULT_STRATEGY.ordinal();
    }

    @Override
    public void close() {
        if (this.writeInProgress.get()) {
            this.pendingClose.set(true);
            return;
        }
        this.mode = Mode.NONE;
        this.closed.set(true);
        this.emit("close", CallbackResult.createSuccess());
        this.unref();
    }

    public void write(final int flush, final byte[] chunk, final int inOffset, final int inLen, final ByteBuf buffer, final int outOffset, final int outLen) {
        this.process.getEventLoop().submitBlockingTask(new Runnable(){

            @Override
            public void run() {
                try {
                    NodeZlib.this.__write(flush, chunk, inOffset, inLen, buffer, outOffset, outLen);
                }
                catch (Throwable t) {
                    System.err.println("Got error " + t);
                    t.printStackTrace();
                    NodeZlib.this.emit("error", CallbackResult.createError(t));
                }
            }
        });
    }

    public void writeSync(int flush, byte[] chunk, int inOffset, int inLen, ByteBuf buffer, int outOffset, int outLen) throws IOException, DataFormatException {
        this.__write(flush, chunk, inOffset, inLen, buffer, outOffset, outLen);
    }

    private void __write(int flush, byte[] chunk, int inOffset, int inLen, ByteBuf buffer, int outOffset, int outLen) throws IOException, DataFormatException {
        if (this.check(this.initDone.get(), "write before init") && this.check(!this.pendingClose.get(), "close is pending") && this.check(!this.closed.get(), "already finalized") && this.check(!this.writeInProgress.get(), "write already in progress")) {
            this.writeInProgress.set(true);
            if (chunk == null || chunk.length == 0) {
                NodeZlib.after(this, null, 0, outLen);
            } else {
                switch (this.mode) {
                    case DEFLATE: {
                        NodeZlib.deflate(this, flush, chunk, inOffset, inLen, buffer, outOffset, outLen, false);
                        break;
                    }
                    case DEFLATERAW: {
                        NodeZlib.deflate(this, flush, chunk, inOffset, inLen, buffer, outOffset, outLen, true);
                        break;
                    }
                    case GZIP: {
                        NodeZlib.gzip(this, flush, chunk, inOffset, inLen, buffer, outOffset, outLen);
                        break;
                    }
                    case INFLATE: {
                        NodeZlib.inflate(this, flush, chunk, inOffset, inLen, buffer, outOffset, outLen, false);
                        break;
                    }
                    case INFLATERAW: {
                        NodeZlib.inflate(this, flush, chunk, inOffset, inLen, buffer, outOffset, outLen, true);
                        break;
                    }
                    case GUNZIP: {
                        NodeZlib.gunzip(this, flush, chunk, inOffset, inLen, buffer, outOffset, outLen);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        this.process.getNodyn().handleThrowable(new RuntimeException("ERROR: Don't know how to handle " + (Object)((Object)this.mode)));
                    }
                }
            }
            this.writeInProgress.set(false);
            if (this.pendingClose.get()) {
                this.close();
            }
        }
    }

    private static void gunzip(NodeZlib ctx, int flush, byte[] chunk, int inOffset, int inLen, ByteBuf buffer, int outOffset, int outLen) throws IOException {
        GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(chunk));
        byte[] result = new byte[outLen];
        int bytesRead = inputStream.read(result, inOffset, Math.min(inLen, result.length));
        inputStream.close();
        buffer.setBytes(outOffset, result, 0, bytesRead);
        NodeZlib.after(ctx, result, 0, outLen - bytesRead);
    }

    private static void gzip(final NodeZlib ctx, int flush, byte[] chunk, int inOffset, int inLen, ByteBuf buffer, int outOffset, int outLen) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(outLen);
        GZIPOutputStream outputStream = new GZIPOutputStream((OutputStream)output){
            {
                super(x0);
                this.def.setLevel(Level.mapDeflaterLevel(ctx.level));
                this.def.setStrategy(ctx.strategy);
            }
        };
        outputStream.write(chunk, inOffset, inLen);
        outputStream.finish();
        byte[] bytes = output.toByteArray();
        buffer.setBytes(outOffset, bytes, 0, Math.min(bytes.length, outLen));
        NodeZlib.after(ctx, bytes, 0, outLen - bytes.length);
    }

    private static void inflate(NodeZlib ctx, int flush, byte[] chunk, int inOffset, int inLen, ByteBuf buffer, int outOffset, int outLen, boolean raw) throws DataFormatException {
        Inflater inflater = new Inflater(raw);
        inflater.setInput(chunk, inOffset, inLen);
        byte[] output = new byte[chunk.length * 2];
        int inflatedLen = inflater.inflate(output);
        if (inflater.needsDictionary()) {
            if (ctx.dictionary == null) {
                ctx.emit("error", CallbackResult.createError(new RuntimeException("Missing dictionary")));
                return;
            }
            try {
                inflater.setDictionary(ctx.dictionary);
                inflatedLen = inflater.inflate(output);
            }
            catch (Throwable t) {
                ctx.emit("error", CallbackResult.createError(new RuntimeException("Bad dictionary")));
            }
        }
        inflater.end();
        buffer.setBytes(outOffset, output, 0, inflatedLen);
        NodeZlib.after(ctx, Arrays.copyOf(output, inflatedLen), 0, outLen - inflatedLen);
    }

    private static void deflate(NodeZlib ctx, int flush, byte[] chunk, int inOffset, int inLen, ByteBuf buffer, int outOffset, int outLen, boolean raw) {
        Deflater deflater = new Deflater(Level.mapDeflaterLevel(ctx.level), raw);
        deflater.setStrategy(ctx.strategy);
        deflater.setLevel(Level.mapDeflaterLevel(ctx.level));
        if (ctx.dictionary != null) {
            deflater.setDictionary(ctx.dictionary);
        }
        deflater.setInput(chunk, inOffset, inLen);
        deflater.finish();
        byte[] output = new byte[chunk.length];
        int compressedLength = deflater.deflate(output, 0, output.length, Flush.mapFlush(flush));
        deflater.end();
        buffer.setBytes(outOffset, output, 0, compressedLength);
        NodeZlib.after(ctx, Arrays.copyOf(output, compressedLength), 0, outLen - compressedLength);
    }

    private static void after(NodeZlib ctx, byte[] output, int inAfter, int outAfter) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("output", output);
        result.put("inAfter", inAfter);
        result.put("outAfter", outAfter);
        ctx.emit("after", CallbackResult.createSuccess(result));
    }

    private boolean check(boolean bool, String msg) {
        if (!bool) {
            this.emit("error", CallbackResult.createError(new RuntimeException(msg)));
        }
        return bool;
    }
}

