/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.tty;

import io.nodyn.NodeProcess;
import io.nodyn.stream.StreamWrap;
import io.nodyn.tty.ReadStream;
import io.nodyn.tty.WriteStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TTYWrap
extends StreamWrap {
    private String ttyConfig;
    private String ttyProps;

    public TTYWrap(NodeProcess process, int fd, boolean readable) throws IOException {
        super(process, true);
        this.channelFuture = readable ? ReadStream.create(process, fd, this) : WriteStream.create(process, fd, this);
    }

    public int getColumns() throws IOException, InterruptedException {
        return this.getTerminalProperty("columns");
    }

    public int getRows() throws IOException, InterruptedException {
        return this.getTerminalProperty("rows");
    }

    public void setRawMode(boolean mode) {
        if (mode) {
            this.enableRawMode();
        } else {
            this.disableRawMode();
        }
    }

    public void enableRawMode() {
        try {
            this.ttyConfig = TTYWrap.stty("-g");
            if (this.ttyConfig.length() == 0 || !this.ttyConfig.contains("=") && !this.ttyConfig.contains(":")) {
                throw new RuntimeException("Unrecognized stty code: " + this.ttyConfig);
            }
            TTYWrap.stty("-ixon -icanon min 1 intr undef icrnl susp undef");
            TTYWrap.stty("-echo");
        }
        catch (IOException ioe) {
        }
        catch (InterruptedException e) {
            this.process.getNodyn().handleThrowable(e);
        }
    }

    public void disableRawMode() {
        if (this.ttyConfig != null) {
            try {
                TTYWrap.stty(this.ttyConfig);
                this.ttyConfig = null;
            }
            catch (InterruptedException e) {
            }
            catch (IOException e) {
                this.process.getNodyn().handleThrowable(e);
            }
        }
    }

    protected static String stty(String args) throws IOException, InterruptedException {
        return TTYWrap.exec("stty " + args + " < /dev/tty").trim();
    }

    private static String exec(String cmd) throws IOException, InterruptedException {
        return TTYWrap.exec(new String[]{"sh", "-c", cmd});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String exec(String[] cmd) throws IOException, InterruptedException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream in = null;
        InputStream err = null;
        OutputStream out = null;
        try {
            int c;
            in = p.getInputStream();
            while ((c = in.read()) != -1) {
                bout.write(c);
            }
            err = p.getErrorStream();
            while ((c = err.read()) != -1) {
                bout.write(c);
            }
            out = p.getOutputStream();
            p.waitFor();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (err != null) {
                    err.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {}
        }
        return new String(bout.toByteArray());
    }

    private int getTerminalProperty(String prop) throws IOException, InterruptedException {
        if (this.ttyProps == null) {
            this.ttyProps = TTYWrap.stty("-a");
        }
        for (String str : this.ttyProps.split(";")) {
            if ((str = str.trim()).startsWith(prop)) {
                int index = str.lastIndexOf(" ");
                return Integer.parseInt(str.substring(index).trim());
            }
            if (!str.endsWith(prop)) continue;
            int index = str.indexOf(" ");
            return Integer.parseInt(str.substring(0, index).trim());
        }
        return -1;
    }
}

