/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.tls;

import io.nodyn.tls.Cipher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class TLSNames {
    private static Map<String, String> names = new HashMap<String, String>();

    private static void loadTlsNames() throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(Cipher.class.getClassLoader().getResourceAsStream("tls-names.txt")));
        String line = null;
        while ((line = in.readLine()) != null) {
            TLSNames.processLine(line);
        }
    }

    private static void processLine(String line) {
        int equalLoc = line.indexOf(61);
        if (equalLoc > 0) {
            String code = line.substring(0, equalLoc);
            String name = line.substring(equalLoc + 1);
            names.put(code, name);
        }
    }

    public static String lookup(String code) {
        return names.get(code);
    }

    static {
        try {
            TLSNames.loadTlsNames();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

