/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.tls;

import io.nodyn.tls.Cipher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class CipherList {
    private Set<Cipher> supported = new HashSet<Cipher>();
    private List<Cipher> ciphers = new ArrayList<Cipher>();
    private Set<Cipher> blacklisted = new HashSet<Cipher>();

    public CipherList(String[] supported, String spec) {
        for (int i = 0; i < supported.length; ++i) {
            this.supported.add(Cipher.getByTLSName(supported[i]));
        }
        this.init(spec);
    }

    public String[] toArray() {
        String[] ciphers = new String[this.ciphers.size()];
        for (int i = 0; i < ciphers.length; ++i) {
            ciphers[i] = this.ciphers.get((int)i).name;
        }
        return ciphers;
    }

    protected void init(String spec) {
        StringTokenizer tokens = new StringTokenizer(spec, ":");
        while (tokens.hasMoreTokens()) {
            this.initSegment(tokens.nextToken());
        }
    }

    protected void initSegment(String segment) {
        if (segment.startsWith("+")) {
            this.processPlus(segment.substring(1));
        } else if (segment.startsWith("-")) {
            this.processMinus(segment.substring(1));
        } else if (segment.startsWith("!")) {
            this.processBlacklist(segment.substring(1));
        } else {
            List<Cipher> matched = this.match(segment);
            matched.removeAll(this.blacklisted);
            matched.retainAll(this.supported);
            this.ciphers.addAll(matched);
        }
    }

    private String namesOf(List<Cipher> ciphers) {
        StringBuffer str = new StringBuffer();
        for (Cipher each : ciphers) {
            str.append(each.name).append(" ");
        }
        return str.toString();
    }

    protected void processPlus(String segment) {
        List<Cipher> matched = this.match(segment);
        matched.retainAll(this.ciphers);
        this.ciphers.removeAll(matched);
        this.ciphers.addAll(matched);
    }

    protected void processMinus(String segment) {
        List<Cipher> matched = this.match(segment);
        this.ciphers.removeAll(matched);
    }

    protected void processBlacklist(String segment) {
        List<Cipher> matched = this.match(segment);
        this.ciphers.removeAll(matched);
        this.blacklisted.addAll(matched);
    }

    protected List<Cipher> match(String segment) {
        StringTokenizer tokens = new StringTokenizer(segment, "+");
        List<Cipher> matched = new ArrayList<Cipher>();
        boolean first = true;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (first) {
                matched = Cipher.get(token);
                first = false;
                continue;
            }
            matched.retainAll(Cipher.get(token));
        }
        return matched;
    }
}

