/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.runtime.dynjs;

import io.nodyn.NodeProcess;
import io.nodyn.Nodyn;
import io.nodyn.runtime.NodynConfig;
import io.nodyn.runtime.Program;
import io.nodyn.runtime.dynjs.DynJSProgram;
import java.io.IOException;
import org.dynjs.Config;
import org.dynjs.debugger.agent.DebuggerAgent;
import org.dynjs.exception.ThrowException;
import org.dynjs.runtime.Compiler;
import org.dynjs.runtime.DynJS;
import org.dynjs.runtime.DynObject;
import org.dynjs.runtime.JSFunction;
import org.dynjs.runtime.JSObject;
import org.dynjs.runtime.PropertyDescriptor;
import org.dynjs.runtime.Runner;
import org.dynjs.runtime.SourceProvider;
import org.dynjs.runtime.builtins.DynJSBuiltin;
import org.dynjs.runtime.builtins.Require;
import org.dynjs.runtime.source.ClassLoaderSourceProvider;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VertxFactory;

public class DynJSRuntime
extends Nodyn {
    private final DynJS runtime;
    private final Runner runner;

    public DynJSRuntime(NodynConfig config) {
        this(VertxFactory.newVertx(), config, true);
    }

    public DynJSRuntime(Vertx vertx, NodynConfig config, boolean controlLifeCycle) {
        super(config, vertx, controlLifeCycle);
        Config dynjsConfig = new Config((ClassLoader)config.getClassLoader());
        dynjsConfig.setExposeDebugAs("v8debug");
        this.runtime = new DynJS(dynjsConfig);
        this.runner = this.runtime.newRunner(config.getDebug());
        if (config.getDebug()) {
            DebuggerAgent agent = new DebuggerAgent(this.runner.getDebugger(), this.getEventLoop().getEventLoopGroup(), this.getConfiguration().getDebugPort());
        }
    }

    @Override
    public Object loadBinding(String name) {
        this.runner.withSource("__native_require('nodyn/bindings/" + name + "');");
        return this.runner.execute();
    }

    @Override
    public Program compile(String source, String fileName, boolean displayErrors) throws Throwable {
        try {
            return new DynJSProgram(this, this.runner.getDebugger(), source, fileName);
        }
        catch (Throwable t) {
            if (displayErrors) {
                this.handleThrowable(t);
            }
            throw t;
        }
    }

    @Override
    public void makeContext(Object global) {
        new DynJS(this.runtime.getConfig(), (JSObject)global);
    }

    @Override
    public boolean isContext(Object global) {
        Object dynjs;
        if (global instanceof DynObject && (dynjs = ((DynObject)global).get((Object)"dynjs")) != null) {
            return ((DynJSBuiltin)dynjs).getRuntime() != null;
        }
        return false;
    }

    @Override
    public void handleThrowable(Throwable t) {
        if (t instanceof ThrowException) {
            ThrowException e = (ThrowException)t;
            Object value = e.getValue();
            if (value != null && value instanceof JSObject) {
                Object stack = ((JSObject)value).get(this.runtime.getDefaultExecutionContext(), "stack");
                System.err.print(stack);
            } else if (t.getCause() != null) {
                this.handleThrowable((Throwable)new ThrowException(null, e.getCause()));
            } else {
                this.handleThrowable((Throwable)new ThrowException(null, (Throwable)e));
            }
        } else {
            this.handleThrowable((Throwable)new ThrowException(null, t));
        }
    }

    @Override
    public Object getGlobalContext() {
        return this.runtime.getGlobalContext().getObject();
    }

    @Override
    protected NodeProcess initialize() {
        try {
            JSObject globalObject = this.runtime.getGlobalContext().getObject();
            globalObject.defineOwnProperty(null, "__vertx", PropertyDescriptor.newDataPropertyDescriptor((Object)this.getVertx(), (boolean)true, (boolean)true, (boolean)false), false);
            globalObject.defineOwnProperty(null, "__dirname", PropertyDescriptor.newDataPropertyDescriptor((Object)System.getProperty("user.dir"), (boolean)true, (boolean)true, (boolean)true), false);
            globalObject.defineOwnProperty(null, "__filename", PropertyDescriptor.newDataPropertyDescriptor((Object)"node.js", (boolean)true, (boolean)true, (boolean)true), false);
            globalObject.defineOwnProperty(null, "__nodyn", PropertyDescriptor.newDataPropertyDescriptor((Object)this, (boolean)true, (boolean)true, (boolean)false), false);
            globalObject.defineOwnProperty(null, "__native_require", PropertyDescriptor.newDataPropertyDescriptor((Object)new Require(this.runtime.getGlobalContext()), (boolean)true, (boolean)true, (boolean)true), false);
            NodeProcess javaProcess = new NodeProcess(this);
            this.getEventLoop().setProcess(javaProcess);
            this.runScript("nodyn/polyfill.js");
            JSFunction processFunction = (JSFunction)this.runScript("nodyn/process.js");
            JSObject jsProcess = (JSObject)this.runtime.getDefaultExecutionContext().call(processFunction, (Object)this.runtime.getGlobalContext().getObject(), new Object[]{javaProcess});
            JSFunction nodeFunction = (JSFunction)this.runScript("node.js");
            this.runtime.getDefaultExecutionContext().call(nodeFunction, (Object)this.runtime.getGlobalContext().getObject(), new Object[]{jsProcess});
            return javaProcess;
        }
        catch (Exception e) {
            System.err.println("Unable to initialize Nodyn. Exiting.");
            e.printStackTrace();
            System.exit(255);
            return null;
        }
    }

    @Override
    protected Object runScript(String scriptName) throws IOException {
        this.runner.withSource((SourceProvider)new ClassLoaderSourceProvider((ClassLoader)this.runtime.getConfig().getClassLoader(), scriptName));
        this.runner.withFileName(scriptName);
        return this.runner.execute();
    }

    protected Compiler newCompiler() {
        return this.runtime.newCompiler();
    }
}

