/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.pipe;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.nodyn.NodeProcess;
import io.nodyn.fs.UnsafeFs;
import io.nodyn.netty.DataEventHandler;
import io.nodyn.netty.EOFEventHandler;
import io.nodyn.netty.pipe.NioDuplexStreamChannel;
import io.nodyn.netty.pipe.NioInputStreamChannel;
import io.nodyn.netty.pipe.NioOutputStreamChannel;
import io.nodyn.netty.pipe.ipc.DuplexIPCChannel;
import io.nodyn.netty.pipe.ipc.IPCRecord;
import io.nodyn.stream.StreamWrap;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import jnr.constants.platform.AddressFamily;
import jnr.constants.platform.Sock;

public class PipeWrap
extends StreamWrap {
    private static final int UPSTREAM = 0;
    private static final int DOWNSTREAM = 1;
    private final boolean ipc;
    private Type type;
    private int[] fileDescriptors = new int[2];

    public PipeWrap(NodeProcess process, boolean ipc) throws NoSuchFieldException, IllegalAccessException, IOException {
        super(process, true);
        this.ipc = ipc;
    }

    public String toString() {
        if (this.fileDescriptors == null) {
            return "[PipeWrap: " + System.identityHashCode(this) + " ipc=" + this.ipc + "; type=" + (Object)((Object)this.type) + "]";
        }
        return "[PipeWrap: " + System.identityHashCode(this) + " ipc=" + this.ipc + "; type=" + (Object)((Object)this.type) + "; fd[0]=" + this.fileDescriptors[0] + "; fd[1]=" + this.fileDescriptors[1] + "]";
    }

    public void create(int downstreamFd) throws IllegalAccessException, NoSuchFieldException, IOException {
        this.process.getPosix().socketpair(AddressFamily.AF_UNIX.intValue(), Sock.SOCK_STREAM.intValue(), 0, this.fileDescriptors);
        boolean readable = downstreamFd != 0;
        boolean writable = downstreamFd != 1 && downstreamFd != 2;
        this.open(this.fileDescriptors[0], readable, writable);
    }

    public void closeDownstream() {
        this.process.getPosix().close(this.fileDescriptors[1]);
    }

    public int getUpstream() {
        return this.fileDescriptors[0];
    }

    public int getDownstream() {
        return this.fileDescriptors[1];
    }

    public void open(int fd, boolean readable, boolean writable) throws NoSuchFieldException, IllegalAccessException, IOException {
        FileDescriptor fileDesc = UnsafeFs.createFileDescriptor(fd);
        if (fd == 0) {
            this.openInput(fd, fileDesc);
        } else if (fd == 1 || fd == 2) {
            this.openOutput(fd, fileDesc);
        } else if (readable && writable) {
            this.openDuplex(fd, fileDesc);
        } else if (readable) {
            this.openInput(fd, fileDesc);
        } else {
            this.openOutput(fd, fileDesc);
        }
    }

    protected void openInput(int fd, FileDescriptor fileDescriptor) throws IOException {
        FileInputStream in = new FileInputStream(fileDescriptor);
        NioInputStreamChannel nioChannel = NioInputStreamChannel.create(this.process, in);
        nioChannel.config().setAutoRead(false);
        nioChannel.pipeline().addLast("emit.data", (ChannelHandler)new DataEventHandler(this.process, this));
        nioChannel.pipeline().addLast("emit.eof", (ChannelHandler)new EOFEventHandler(this.process, this));
        this.channelFuture = nioChannel.newSucceededFuture();
        this.process.getEventLoop().getEventLoopGroup().register((Channel)nioChannel);
        this.type = Type.INPUT;
    }

    public void writeUtf8String(String data, int fd) {
        ByteBuf buffer = this.channelFuture.channel().alloc().buffer();
        buffer.writeBytes(data.getBytes(StandardCharsets.UTF_8));
        this.channelFuture.channel().writeAndFlush((Object)new IPCRecord(buffer, fd));
    }

    protected void openOutput(int fd, FileDescriptor fileDescriptor) throws IOException {
        FileOutputStream out = new FileOutputStream(fileDescriptor);
        NioOutputStreamChannel nioChannel = NioOutputStreamChannel.create(this.process, out);
        nioChannel.config().setAutoRead(false);
        this.channelFuture = nioChannel.newSucceededFuture();
        this.process.getEventLoop().getEventLoopGroup().register((Channel)nioChannel);
        this.type = Type.OUTPUT;
    }

    protected void openDuplex(int fd, FileDescriptor fileDescriptor) throws NoSuchFieldException, IllegalAccessException, IOException {
        if (this.ipc) {
            DuplexIPCChannel channel = new DuplexIPCChannel(this, this.process.getPosix(), fd);
            this.channelFuture = channel.newSucceededFuture();
            this.process.getEventLoop().getEventLoopGroup().register((Channel)channel);
        } else {
            FileInputStream in = new FileInputStream(fileDescriptor);
            FileOutputStream out = new FileOutputStream(fileDescriptor);
            NioDuplexStreamChannel nioChannel = NioDuplexStreamChannel.create(this.process, in, out);
            nioChannel.config().setAutoRead(false);
            nioChannel.config().setOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)true);
            nioChannel.pipeline().addLast("emit.data", (ChannelHandler)new DataEventHandler(this.process, this));
            nioChannel.pipeline().addLast("emit.eof", (ChannelHandler)new EOFEventHandler(this.process, this));
            this.channelFuture = nioChannel.newSucceededFuture();
            this.process.getEventLoop().getEventLoopGroup().register((Channel)nioChannel);
        }
        this.type = Type.DUPLEX;
    }

    @Override
    public void readStart() {
        if (this.type != Type.OUTPUT) {
            super.readStart();
        }
    }

    @Override
    public void readStop() {
        if (this.type != Type.OUTPUT) {
            super.readStop();
        }
    }

    private static enum Type {
        INPUT,
        OUTPUT,
        DUPLEX;

    }
}

