/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.netty.pipe;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import io.nodyn.NodeProcess;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public class NioOutputStreamChannel
extends AbstractChannel {
    private final OutputStream out;
    private final NodeProcess process;
    private final DefaultChannelConfig config;
    private final ChannelMetadata metadata;
    private boolean open;

    public static NioOutputStreamChannel create(NodeProcess process, OutputStream out) throws IOException {
        NioOutputStreamChannel s = new NioOutputStreamChannel(process, out);
        return s;
    }

    protected NioOutputStreamChannel(NodeProcess process, OutputStream out) {
        super(null);
        this.process = process;
        this.out = out;
        this.config = new DefaultChannelConfig((Channel)this);
        this.metadata = new ChannelMetadata(false);
        this.open = true;
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new AbstractChannel.AbstractUnsafe(){

            public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            }
        };
    }

    protected boolean isCompatible(EventLoop loop) {
        return true;
    }

    protected SocketAddress localAddress0() {
        return null;
    }

    protected SocketAddress remoteAddress0() {
        return null;
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
    }

    protected void doDisconnect() throws Exception {
        this.open = false;
    }

    protected void doClose() throws Exception {
        this.open = false;
    }

    protected void doBeginRead() throws Exception {
    }

    protected void doWrite(final ChannelOutboundBuffer in) throws Exception {
        this.process.getEventLoop().submitBlockingTask(new Runnable(){

            @Override
            public void run() {
                ByteBuffer[] buffers = in.nioBuffers();
                for (int i = 0; i < buffers.length; ++i) {
                    ByteBuffer each = buffers[i];
                    int amount = each.limit() - each.position();
                    byte[] bytes = new byte[amount];
                    each.get(bytes);
                    try {
                        NioOutputStreamChannel.this.out.write(bytes);
                        continue;
                    }
                    catch (IOException e) {
                        NioOutputStreamChannel.this.process.getNodyn().handleThrowable(e);
                    }
                }
            }
        });
    }

    public ChannelConfig config() {
        return this.config;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isActive() {
        return this.open;
    }

    public ChannelMetadata metadata() {
        return this.metadata;
    }
}

