/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.netty.pipe;

import io.netty.buffer.ByteBuf;
import io.netty.channel.FileRegion;
import io.nodyn.NodeProcess;
import io.nodyn.netty.pipe.AbstractNioStreamChannel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.ScatteringByteChannel;

public class NioInputStreamChannel
extends AbstractNioStreamChannel {
    private final InputStream in;
    private final Pipe pipe;

    public static NioInputStreamChannel create(NodeProcess process, InputStream in) throws IOException {
        Pipe pipe = Pipe.open();
        return new NioInputStreamChannel(process, in, pipe);
    }

    protected NioInputStreamChannel(NodeProcess process, InputStream in, Pipe pipe) {
        super(process, pipe);
        this.pipe = pipe;
        this.in = in;
        this.startPump();
    }

    protected Pipe.SourceChannel javaChannel() {
        return (Pipe.SourceChannel)super.javaChannel();
    }

    protected void startPump() {
        this.process.getEventLoop().submitBlockingTask(new Runnable(){

            @Override
            public void run() {
                byte[] buf = new byte[1024];
                int numRead = 0;
                try {
                    while ((numRead = NioInputStreamChannel.this.in.read(buf)) >= 0) {
                        NioInputStreamChannel.this.pipe.sink().write(ByteBuffer.wrap(buf, 0, numRead));
                    }
                    NioInputStreamChannel.this.pipe.sink().close();
                }
                catch (IOException e) {
                    NioInputStreamChannel.this.process.getNodyn().handleThrowable(e);
                    try {
                        NioInputStreamChannel.this.pipe.sink().close();
                    }
                    catch (IOException e1) {
                        NioInputStreamChannel.this.process.getNodyn().handleThrowable(e);
                    }
                }
            }
        });
    }

    protected long doWriteFileRegion(FileRegion region) throws Exception {
        return 0L;
    }

    protected int doReadBytes(ByteBuf byteBuf) throws Exception {
        return byteBuf.writeBytes((ScatteringByteChannel)this.javaChannel(), byteBuf.writableBytes());
    }

    protected int doWriteBytes(ByteBuf buf) throws Exception {
        return 0;
    }

    protected void doClose() throws Exception {
        this.pipe.source().close();
    }

    public boolean isActive() {
        return this.pipe.source().isOpen();
    }
}

