/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.netty.pipe;

import io.netty.buffer.ByteBuf;
import io.netty.channel.FileRegion;
import io.nodyn.NodeProcess;
import io.nodyn.netty.pipe.AbstractNioStreamChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ScatteringByteChannel;

public class NioDuplexStreamChannel
extends AbstractNioStreamChannel {
    private final InputStream in;
    private final OutputStream out;
    private final Pipe inPipe;
    private final Pipe outPipe;

    public static NioDuplexStreamChannel create(NodeProcess process, InputStream in, OutputStream out) throws IOException {
        Pipe inPipe = Pipe.open();
        Pipe outPipe = Pipe.open();
        return new NioDuplexStreamChannel(process, in, inPipe, out, outPipe);
    }

    protected NioDuplexStreamChannel(NodeProcess process, InputStream in, Pipe inPipe, OutputStream out, Pipe outPipe) {
        super(process, inPipe);
        this.in = in;
        this.inPipe = inPipe;
        this.out = out;
        this.outPipe = outPipe;
        this.startPumps();
    }

    protected Pipe.SourceChannel javaChannel() {
        return (Pipe.SourceChannel)super.javaChannel();
    }

    protected void startPumps() {
        this.process.getEventLoop().submitBlockingTask(new Runnable(){

            @Override
            public void run() {
                byte[] buf = new byte[1024];
                int numRead = 0;
                try {
                    while ((numRead = NioDuplexStreamChannel.this.in.read(buf)) >= 0) {
                        if (numRead <= 0) continue;
                        NioDuplexStreamChannel.this.inPipe.sink().write(ByteBuffer.wrap(buf, 0, numRead));
                    }
                    NioDuplexStreamChannel.this.inPipe.sink().close();
                }
                catch (IOException e) {
                    NioDuplexStreamChannel.this.process.getNodyn().handleThrowable(e);
                    try {
                        NioDuplexStreamChannel.this.inPipe.sink().close();
                    }
                    catch (IOException e1) {
                        NioDuplexStreamChannel.this.process.getNodyn().handleThrowable(e);
                    }
                }
            }
        });
        this.process.getEventLoop().submitBlockingTask(new Runnable(){

            @Override
            public void run() {
                ByteBuffer buf = ByteBuffer.allocate(1024);
                int numRead = 0;
                try {
                    while ((numRead = NioDuplexStreamChannel.this.outPipe.source().read(buf)) >= 0) {
                        if (numRead <= 0) continue;
                        byte[] writeMe = buf.array();
                        NioDuplexStreamChannel.this.out.write(writeMe, 0, numRead);
                        NioDuplexStreamChannel.this.out.flush();
                        buf.clear();
                    }
                }
                catch (IOException e) {
                    NioDuplexStreamChannel.this.process.getNodyn().handleThrowable(e);
                    try {
                        NioDuplexStreamChannel.this.outPipe.source().close();
                    }
                    catch (IOException e1) {
                        NioDuplexStreamChannel.this.process.getNodyn().handleThrowable(e);
                    }
                }
            }
        });
    }

    protected long doWriteFileRegion(FileRegion region) throws Exception {
        return 0L;
    }

    protected int doReadBytes(ByteBuf byteBuf) throws Exception {
        return byteBuf.writeBytes((ScatteringByteChannel)this.javaChannel(), byteBuf.writableBytes());
    }

    protected int doWriteBytes(ByteBuf buf) throws Exception {
        int expectedWrittenBytes = buf.readableBytes();
        int writtenBytes = buf.readBytes((GatheringByteChannel)this.outPipe.sink(), expectedWrittenBytes);
        return writtenBytes;
    }

    protected void doClose() throws Exception {
        this.inPipe.source().close();
        this.outPipe.sink().close();
    }

    public boolean isActive() {
        return true;
    }
}

