/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.loop;

import io.nodyn.loop.RefCounted;
import io.nodyn.loop.RefHandleHandler;

public class RefHandle {
    private final RefCounted refCounted;
    private final String name;
    private boolean counted;

    public RefHandle(RefCounted refCounted, String name) {
        this(refCounted, true, name);
    }

    public RefHandle(RefCounted refCounted, boolean count, String name) {
        this.refCounted = refCounted;
        this.name = name;
        if (count) {
            this.ref();
        }
    }

    public RefHandle create(String name) {
        return this.refCounted.newHandle(name);
    }

    public RefHandleHandler handler() {
        return new RefHandleHandler(this);
    }

    public synchronized void ref() {
        if (this.counted) {
            return;
        }
        this.counted = true;
        this.refCounted.incrCount(this);
    }

    public synchronized void unref() {
        if (!this.counted) {
            return;
        }
        this.counted = false;
        this.refCounted.decrCount(this);
    }

    public String toString() {
        return this.name;
    }
}

