/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.loop;

import io.nodyn.loop.EventLoop;
import java.util.concurrent.Future;

public class ImmediateCheckHandle
implements Runnable {
    private final EventLoop loop;
    private final Runnable callback;
    private Future<?> future;

    public ImmediateCheckHandle(EventLoop loop, Runnable callback) {
        this.loop = loop;
        this.callback = callback;
    }

    public boolean isActive() {
        return this.future != null;
    }

    public void start() {
        if (this.future != null) {
            return;
        }
        this.future = this.loop.submitUserTask(this, "immediate-check");
    }

    public void stop() {
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
    }

    @Override
    public void run() {
        try {
            this.callback.run();
        }
        catch (Throwable t) {
            this.loop.getProcess().getNodyn().handleThrowable(t);
        }
        finally {
            this.future = null;
        }
    }
}

