/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.loop;

import io.nodyn.loop.EventLoop;
import io.nodyn.loop.RefHandle;

public class Blocking {
    private final EventLoop eventLoop;

    public Blocking(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public void submit(final Runnable action) {
        final RefHandle handle = this.eventLoop.newHandle("blocking");
        this.eventLoop.submitBlockingTask(new Runnable(){

            @Override
            public void run() {
                action.run();
                handle.unref();
            }
        });
    }

    public void unblock(Runnable action) {
        this.eventLoop.submitUserTask(action, "blocking");
    }
}

