/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.nodyn.CallbackResult;
import io.nodyn.EventSource;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HTTPParser
extends EventSource {
    public static final String[] METHODS = new String[]{"DELETE", "GET", "HEAD", "POST", "PUT", "CONNECT", "OPTIONS", "TRACE", "COPY", "LOCK", "MKCOL", "MOVE", "PROPFIND", "PROPPATCH", "SEARCH", "UNLOCK", "REPORT", "MKACTIVITY", "CHECKOUT", "MERGE", "MSEARCH", "NOTIFY", "SUBSCRIBE", "UNSUBSCRIBE", "PATCH", "PURGE"};
    private static final Charset UTF8 = Charset.forName("utf8");
    private static final Charset ASCII = Charset.forName("us-ascii");
    public static final int REQUEST = 1;
    public static final int RESPONSE = 2;
    private boolean shouldReinitialize;
    private int type;
    private State state;
    private Error error;
    private CompositeByteBuf buf;
    private String url;
    private int versionMajor;
    private int versionMinor;
    private Boolean shouldKeepAlive;
    private Integer method;
    private int statusCode;
    private String statusMessage;
    private boolean upgrade;
    private boolean chunked;
    private boolean skipBody;
    private int length;
    private List<String> headers = new ArrayList<String>();
    private List<String> trailers = new ArrayList<String>();
    private Set<String> expectedTrailers = new HashSet<String>();

    public HTTPParser() {
        this.buf = Unpooled.compositeBuffer();
    }

    public String type() {
        if (this.type == 1) {
            return "*** REQUEST";
        }
        if (this.type == 2) {
            return "*** RESPONSE";
        }
        return "UNKNOWN";
    }

    public void reinitialize(int type) {
        this.type = type;
        this.state = this.type == 1 ? State.REQUEST : State.RESPONSE;
        this.buf.clear();
        this.method = null;
        this.url = null;
        this.versionMajor = 0;
        this.versionMinor = 0;
        this.headers.clear();
        this.trailers.clear();
        this.expectedTrailers.clear();
        this.shouldKeepAlive = null;
        this.chunked = false;
        this.skipBody = false;
        this.length = Integer.MAX_VALUE;
        this.statusCode = 0;
        this.statusMessage = "";
        this.upgrade = false;
        this.shouldReinitialize = false;
    }

    public Integer getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean getUpgrade() {
        return this.upgrade;
    }

    public String[] getHeaders() {
        return this.headers.toArray(new String[this.headers.size()]);
    }

    public String[] getTrailers() {
        return this.trailers.toArray(new String[this.headers.size()]);
    }

    public boolean getShouldKeepAlive() {
        if (this.versionMajor == 1 && this.versionMinor == 1) {
            if (this.shouldKeepAlive == null) {
                return true;
            }
            return this.shouldKeepAlive;
        }
        return false;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public Error getError() {
        return this.error;
    }

    protected boolean needsEof() {
        if (this.type == 1) {
            return false;
        }
        if (this.statusCode / 100 == 1 || this.statusCode == 204 || this.statusCode == 304 || this.skipBody) {
            return false;
        }
        return !this.chunked && this.length == Integer.MAX_VALUE;
    }

    public int execute(ByteBuf buf) {
        if (buf.readableBytes() == 0 && this.needsEof()) {
            this.finish();
        }
        this.addBuffer(buf);
        int startingLength = this.buf.readableBytes();
        block10: while (this.buf.readableBytes() > 0) {
            switch (this.state) {
                case REQUEST: {
                    if (!this.readRequestLine()) break block10;
                    this.state = State.HEADERS;
                    continue block10;
                }
                case RESPONSE: {
                    if (!this.readStatusLine()) break block10;
                    this.state = State.HEADERS;
                    continue block10;
                }
                case HEADERS: {
                    int headerResult = this.readHeaders();
                    if (headerResult != 0) break block10;
                    Object result = this.emit("headersComplete", CallbackResult.EMPTY_SUCCESS);
                    this.state = State.BODY;
                    if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                        this.skipBody = true;
                    }
                    if (this.skipBody) {
                        this.finish();
                        break block10;
                    }
                    if (this.chunked) {
                        this.state = State.BODY;
                        continue block10;
                    }
                    if (this.length == 0) {
                        this.finish();
                        break block10;
                    }
                    if (this.length != Integer.MAX_VALUE) {
                        this.state = State.BODY;
                        continue block10;
                    }
                    if (this.type == 1 || !this.needsEof()) {
                        this.finish();
                        break block10;
                    }
                    this.state = State.BODY;
                    continue block10;
                }
                case BODY: {
                    if (this.chunked) {
                        this.state = State.CHUNK_START;
                        continue block10;
                    }
                    ByteBuf body = this.readBody();
                    this.emit("body", CallbackResult.createSuccess((Object)body));
                    if (this.length != 0) continue block10;
                    this.finish();
                    break block10;
                }
                case CHUNK_START: {
                    if (!this.readChunkStart()) break block10;
                    if (this.length == 0) {
                        this.state = State.TRAILERS;
                        continue block10;
                    }
                    this.state = State.CHUNK_BODY;
                    continue block10;
                }
                case CHUNK_BODY: {
                    ByteBuf chunkBody = this.readBody();
                    this.emit("body", CallbackResult.createSuccess((Object)chunkBody));
                    if (this.length != 0) continue block10;
                    this.state = State.CHUNK_END;
                    continue block10;
                }
                case CHUNK_END: {
                    if (!this.readChunkEnd()) break block10;
                    this.state = State.CHUNK_START;
                    continue block10;
                }
                case TRAILERS: {
                    int trailerResult = this.readTrailers();
                    if (trailerResult != 0) break block10;
                    this.finish();
                    break block10;
                }
                default: {
                    continue block10;
                }
            }
        }
        if (this.error != null) {
            return -1 * this.error.ordinal();
        }
        int endingLength = this.buf.readableBytes();
        int numRead = startingLength - endingLength;
        if (this.shouldReinitialize) {
            this.reinitialize(this.type);
        }
        return numRead;
    }

    void addBuffer(ByteBuf buf) {
        this.buf.writeBytes(buf);
    }

    int readableBytes() {
        return this.buf.readableBytes();
    }

    int readerIndex() {
        return this.buf.readerIndex();
    }

    protected ByteBuf readLine() {
        int cr = this.buf.indexOf(this.readerIndex(), this.readerIndex() + this.readableBytes(), (byte)13);
        if (cr < 0) {
            return null;
        }
        if (this.buf.getByte(cr + 1) != 10) {
            return null;
        }
        int len = cr + 2 - this.readerIndex();
        ByteBuf line = this.buf.readSlice(len);
        return line;
    }

    protected boolean readRequestLine() {
        ByteBuf line = this.readLine();
        if (line == null) {
            return false;
        }
        int space = line.indexOf(line.readerIndex(), line.readerIndex() + line.readableBytes(), (byte)32);
        if (space < 0) {
            this.setError(Error.INVALID_METHOD);
            return false;
        }
        int len = space - line.readerIndex();
        ByteBuf methodBuf = line.readSlice(len);
        String methodName = methodBuf.toString(UTF8);
        for (int i = 0; i < METHODS.length; ++i) {
            if (!METHODS[i].equals(methodName)) continue;
            this.method = i;
            break;
        }
        if (this.method == null) {
            this.setError(Error.INVALID_METHOD);
            return false;
        }
        if ("CONNECT".equals(methodName)) {
            this.upgrade = true;
        }
        line.readByte();
        space = line.indexOf(line.readerIndex(), line.readerIndex() + line.readableBytes(), (byte)32);
        ByteBuf urlBuf = null;
        ByteBuf versionBuf = null;
        if (space < 0) {
            urlBuf = line.readSlice(line.readableBytes());
        } else {
            len = space - line.readerIndex();
            urlBuf = line.readSlice(len);
            versionBuf = line.readSlice(line.readableBytes());
        }
        this.url = urlBuf.toString(UTF8).trim();
        if (versionBuf != null) {
            if (!this.readVersion(versionBuf)) {
                this.setError(Error.INVALID_VERSION);
                return false;
            }
        } else {
            this.versionMajor = 1;
            this.versionMinor = 0;
        }
        return true;
    }

    protected boolean readStatusLine() {
        ByteBuf line = this.readLine();
        if (line == null) {
            return false;
        }
        int space = line.indexOf(line.readerIndex(), line.readerIndex() + line.readableBytes(), (byte)32);
        if (space < 0) {
            this.setError(Error.INVALID_VERSION);
            return false;
        }
        int len = space - line.readerIndex();
        ByteBuf versionBuf = line.readSlice(len);
        if (!this.readVersion(versionBuf)) {
            this.setError(Error.INVALID_VERSION);
            return false;
        }
        line.readByte();
        space = line.indexOf(line.readerIndex(), line.readerIndex() + line.readableBytes(), (byte)32);
        if (space < 0) {
            this.setError(Error.INVALID_STATUS);
            return false;
        }
        len = space - line.readerIndex();
        ByteBuf statusBuf = line.readSlice(len);
        int status = -1;
        try {
            status = Integer.parseInt(statusBuf.toString(UTF8));
        }
        catch (NumberFormatException e) {
            this.setError(Error.INVALID_STATUS);
            return false;
        }
        if (status > 999 || status < 100) {
            this.setError(Error.INVALID_STATUS);
            return false;
        }
        this.statusCode = status;
        line.readByte();
        ByteBuf messageBuf = line.readSlice(line.readableBytes());
        this.statusMessage = messageBuf.toString(UTF8).trim();
        return true;
    }

    protected boolean readVersion(ByteBuf versionBuf) {
        int dotLoc = versionBuf.indexOf(versionBuf.readerIndex(), versionBuf.readerIndex() + versionBuf.readableBytes(), (byte)46);
        if (dotLoc < 0) {
            return false;
        }
        char majorChar = (char)versionBuf.getByte(dotLoc - 1);
        char minorChar = (char)versionBuf.getByte(dotLoc + 1);
        try {
            this.versionMajor = Integer.parseInt("" + majorChar);
            this.versionMinor = Integer.parseInt("" + minorChar);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    protected int readHeaders() {
        return this.readHeaders(this.headers, true);
    }

    protected int readTrailers() {
        return this.readHeaders(this.trailers, false);
    }

    protected int readHeaders(List<String> target, boolean analyze) {
        ByteBuf line;
        do {
            if ((line = this.readLine()) == null) {
                return 1;
            }
            if (line.readableBytes() != 2) continue;
            return 0;
        } while (this.readHeader(line, target, analyze));
        this.setError(Error.INVALID_HEADER_TOKEN);
        return -1;
    }

    protected boolean readHeader(ByteBuf line, List<String> target, boolean analyze) {
        int colonLoc = line.indexOf(line.readerIndex(), line.readerIndex() + line.readableBytes(), (byte)58);
        if (colonLoc < 0) {
            char c;
            if (line.readableBytes() > 1 && ((c = (char)line.getByte(0)) == ' ' || c == '\t')) {
                int lastIndex = this.headers.size() - 1;
                String val = this.headers.get(lastIndex);
                val = val + " " + line.toString(ASCII).trim();
                this.headers.set(lastIndex, val);
                return true;
            }
            return false;
        }
        int len = colonLoc - line.readerIndex();
        ByteBuf keyBuf = line.readSlice(len);
        line.readByte();
        ByteBuf valueBuf = line.readSlice(line.readableBytes());
        String key = keyBuf.toString(UTF8).trim();
        String value = valueBuf.toString(UTF8).trim();
        target.add(key);
        target.add(value);
        if (analyze) {
            return this.analyzeHeader(key.toLowerCase(), value);
        }
        return true;
    }

    protected boolean analyzeHeader(String name, String value) {
        if ("content-length".equals(name)) {
            try {
                this.length = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.setError(Error.INVALID_CONTENT_LENGTH);
                return false;
            }
        } else if ("transfer-encoding".equals(name)) {
            if (value.toLowerCase().contains("chunked")) {
                this.chunked = true;
            }
        } else if ("connection".equals(name)) {
            if (value.toLowerCase().contains("close")) {
                this.shouldKeepAlive = false;
            }
        } else if ("upgrade".equals(name)) {
            this.upgrade = true;
        }
        return true;
    }

    protected boolean readChunkStart() {
        ByteBuf line = this.readLine();
        if (line == null) {
            return false;
        }
        try {
            int len;
            this.length = len = Integer.parseInt(line.toString(UTF8).trim(), 16);
        }
        catch (NumberFormatException e) {
            this.setError(Error.INVALID_CHUNK_SIZE);
            return false;
        }
        return true;
    }

    protected boolean readChunkEnd() {
        ByteBuf line = this.readLine();
        if (line == null) {
            return false;
        }
        if (line.readableBytes() != 2) {
            this.setError(Error.INVALID_FRAGMENT);
            return false;
        }
        return true;
    }

    protected ByteBuf readBody() {
        ByteBuf data = null;
        if (this.buf.readableBytes() <= this.length) {
            data = this.buf.readSlice(this.buf.readableBytes());
            this.length -= data.readableBytes();
        } else {
            data = this.buf.readSlice(this.length);
            this.length = 0;
        }
        return data;
    }

    public void finish() {
        if (this.type == 2 && this.statusCode == 100) {
            this.reinitialize(2);
            return;
        }
        if (this.skipBody) {
            return;
        }
        this.emit("messageComplete", CallbackResult.EMPTY_SUCCESS);
        this.shouldReinitialize = true;
    }

    private static enum State {
        REQUEST,
        RESPONSE,
        HEADERS,
        BODY,
        TRAILERS,
        CHUNK_START,
        CHUNK_BODY,
        CHUNK_END;

    }

    public static enum Error {
        INVALID_EOF_STATE("stream ended at an unexpected time"),
        HEADER_OVERFLOW("too many header bytes seen; overflow detected"),
        CLOSED_CONNECTION("data received after completed connection: close message"),
        INVALID_VERSION("invalid HTTP version"),
        INVALID_STATUS("invalid HTTP status code"),
        INVALID_METHOD("invalid HTTP method"),
        INVALID_URL("invalid URL"),
        INVALID_HOST("invalid host"),
        INVALID_PORT("invalid port"),
        INVALID_PATH("invalid path"),
        INVALID_QUERY_STRING("invalid query string"),
        INVALID_FRAGMENT("invalid fragment"),
        LF_EXPECTED("LF character expected"),
        INVALID_HEADER_TOKEN("invalid character in header"),
        INVALID_CONTENT_LENGTH("invalid character in content-length header"),
        INVALID_CHUNK_SIZE("invalid character in chunk size header"),
        INVALID_CONSTANT("invalid constant string"),
        INVALID_INTERNAL_STATE("encountered unexpected internal state"),
        STRICT("strict mode assertion failed"),
        PAUSED("parser is paused"),
        UNKNOWN("an unknown error occurred");

        private String text;

        private Error(String text) {
            this.text = text;
        }
    }
}

