/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.fs;

import io.nodyn.CallbackResult;
import io.nodyn.NodeProcess;
import io.nodyn.handle.HandleWrap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class NodeStatWatcher
extends HandleWrap {
    private File watchedDir;
    private File watchedFile;
    private WatchService watcher;
    private Thread thread;

    public NodeStatWatcher(NodeProcess process) {
        super(process, false);
    }

    public void start(String path, boolean persistent, int interval) {
        if (persistent) {
            this.ref();
        }
        this.watchedDir = new File(path);
        if (!this.watchedDir.isDirectory()) {
            this.watchedFile = this.watchedDir;
            this.watchedDir = this.watchedFile.getParentFile();
        }
        this.thread = new Thread(new Worker());
        try {
            Path toWatch = Paths.get(this.watchedDir.getCanonicalPath(), new String[0]);
            this.watcher = toWatch.getFileSystem().newWatchService();
            toWatch.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.thread.start();
        }
        catch (IOException e) {
            this.getProcess().getNodyn().handleThrowable(e);
        }
    }

    public void stop() {
        try {
            this.unref();
            this.watcher.close();
            this.thread.join();
        }
        catch (Exception e) {
            this.getProcess().getNodyn().handleThrowable(e);
        }
    }

    class Worker
    implements Runnable {
        Worker() {
        }

        @Override
        public void run() {
            try {
                WatchKey key = NodeStatWatcher.this.watcher.take();
                while (key != null && key.isValid()) {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        if (NodeStatWatcher.this.watchedFile != null && !NodeStatWatcher.this.watchedFile.getName().equals(event.context().toString())) continue;
                        NodeStatWatcher.this.emit("change", CallbackResult.createSuccess((Object)event.context().toString()));
                    }
                    key.reset();
                    key = NodeStatWatcher.this.watcher.take();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

