/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.fs;

import io.nodyn.CallbackResult;
import io.nodyn.NodeProcess;
import io.nodyn.handle.HandleWrap;
import io.nodyn.loop.EventLoop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class FsEventWrap
extends HandleWrap {
    private final EventLoop eventLoop;
    private boolean persistent;
    private WatchService watcher;
    private File watched;

    public FsEventWrap(NodeProcess process) {
        super(process, false);
        this.eventLoop = process.getEventLoop();
    }

    public void start(String path, boolean persistent, boolean recursive) {
        File dir = new File(path);
        this.persistent = persistent;
        if (!dir.isDirectory()) {
            this.watched = dir;
            dir = this.watched.getParentFile();
        }
        try {
            if (persistent) {
                this.ref();
            }
            Path toWatch = Paths.get(dir.getCanonicalPath(), new String[0]);
            this.watcher = toWatch.getFileSystem().newWatchService();
            toWatch.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.eventLoop.submitBlockingTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        WatchKey key = FsEventWrap.this.watcher.take();
                        while (key != null && key.isValid()) {
                            for (WatchEvent<?> event : key.pollEvents()) {
                                if (FsEventWrap.this.watched != null && !FsEventWrap.this.watched.getName().equals(event.context().toString())) continue;
                                FsEventWrap.this.emit("change", CallbackResult.createSuccess(event.kind().toString(), event.context().toString()));
                            }
                            key.reset();
                            key = FsEventWrap.this.watcher.take();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (IOException e) {
            this.getProcess().getNodyn().handleThrowable(e);
        }
    }

    @Override
    public void close() {
        try {
            this.unref();
            this.watcher.close();
        }
        catch (Exception e) {
            this.getProcess().getNodyn().handleThrowable(e);
        }
    }
}

