/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.extension;

import io.nodyn.runtime.NodynClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ExtensionLoader {
    private final NodynClassLoader classLoader;

    public ExtensionLoader(NodynClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(String filename) throws IOException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        JarFile jarFile;
        ZipEntry entry;
        String extensionName = null;
        File file = new File(filename);
        if (!file.exists()) {
            throw new FileNotFoundException(filename);
        }
        if (file.isDirectory()) {
            File extensionFile = new File(file, "node.extension");
            if (extensionFile.exists()) {
                FileInputStream in = new FileInputStream(extensionFile);
                try {
                    extensionName = this.readNodeExtension(in);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        } else if (filename.endsWith(".jar") && (entry = (jarFile = new JarFile(file)).getEntry("node.extension")) != null) {
            InputStream in = jarFile.getInputStream(entry);
            try {
                extensionName = this.readNodeExtension(in);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        this.classLoader.append(filename);
        return this.loadExtension(extensionName);
    }

    private Object loadExtension(String extensionName) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        if (extensionName == null) {
            return null;
        }
        Class<?> extClass = this.classLoader.loadClass(extensionName);
        Method[] methods = extClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("require") || !Modifier.isStatic(methods[i].getModifiers()) || methods[i].getParameterTypes().length != 0) continue;
            return this.loadExtension(methods[i]);
        }
        return null;
    }

    private Object loadExtension(Method method) throws InvocationTargetException, IllegalAccessException {
        return method.invoke(null, new Object[0]);
    }

    private String readNodeExtension(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.startsWith("//") || line.equals("")) continue;
            return line;
        }
        return null;
    }
}

