/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.dns;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class ResolverConfig {
    private String[] servers = null;
    private int ndots = -1;
    private static ResolverConfig currentConfig;

    public ResolverConfig() {
        if (this.findProperty()) {
            return;
        }
        if (this.findSunJVM()) {
            return;
        }
        if (this.servers == null) {
            String OS = System.getProperty("os.name");
            String vendor = System.getProperty("java.vendor");
            if (OS.indexOf("Windows") != -1) {
                if (OS.indexOf("95") != -1 || OS.indexOf("98") != -1 || OS.indexOf("ME") != -1) {
                    this.find95();
                } else {
                    this.findNT();
                }
            } else if (OS.indexOf("NetWare") != -1) {
                this.findNetware();
            } else if (vendor.indexOf("Android") != -1) {
                this.findAndroid();
            } else {
                this.findUnix();
            }
        }
    }

    private void addServer(String server, List list) {
        if (list.contains(server)) {
            return;
        }
        list.add(server);
    }

    private int parseNdots(String token) {
        token = token.substring(6);
        try {
            int ndots = Integer.parseInt(token);
            if (ndots >= 0) {
                return ndots;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private void configureFromLists(List lserver) {
        if (this.servers == null && lserver.size() > 0) {
            this.servers = lserver.toArray(new String[0]);
        }
    }

    private void configureNdots(int lndots) {
        if (this.ndots < 0 && lndots > 0) {
            this.ndots = lndots;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean findProperty() {
        ArrayList lserver = new ArrayList(0);
        String prop = System.getProperty("dns.server");
        if (prop != null) {
            StringTokenizer st = new StringTokenizer(prop, ",");
            while (st.hasMoreTokens()) {
                void var3_3;
                this.addServer(var3_3.nextToken(), lserver);
            }
        }
        this.configureFromLists(lserver);
        return this.servers != null;
    }

    private boolean findSunJVM() {
        List lserver_tmp;
        ArrayList lserver = new ArrayList(0);
        try {
            Class[] noClasses = new Class[]{};
            Object[] noObjects = new Object[]{};
            String resConfName = "sun.net.dns.ResolverConfiguration";
            Class<?> resConfClass = Class.forName(resConfName);
            Method open = resConfClass.getDeclaredMethod("open", noClasses);
            Object resConf = open.invoke(null, noObjects);
            Method nameservers = resConfClass.getMethod("nameservers", noClasses);
            lserver_tmp = (List)nameservers.invoke(resConf, noObjects);
        }
        catch (Exception e) {
            return false;
        }
        if (lserver_tmp.size() == 0) {
            return false;
        }
        if (lserver_tmp.size() > 0) {
            Iterator it = lserver_tmp.iterator();
            while (it.hasNext()) {
                this.addServer((String)it.next(), lserver);
            }
        }
        this.configureFromLists(lserver);
        return true;
    }

    private void findResolvConf(String file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return;
        }
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(isr);
        ArrayList lserver = new ArrayList(0);
        int lndots = -1;
        try {
            String line;
            while ((line = br.readLine()) != null) {
                StringTokenizer st;
                if (line.startsWith("nameserver")) {
                    st = new StringTokenizer(line);
                    st.nextToken();
                    this.addServer(st.nextToken(), lserver);
                    continue;
                }
                if (line.startsWith("domain") || line.startsWith("search") || !line.startsWith("options")) continue;
                st = new StringTokenizer(line);
                st.nextToken();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!token.startsWith("ndots:")) continue;
                    lndots = this.parseNdots(token);
                }
            }
            br.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.configureFromLists(lserver);
        this.configureNdots(lndots);
    }

    private void findUnix() {
        this.findResolvConf("/etc/resolv.conf");
    }

    private void findNetware() {
        this.findResolvConf("sys:/etc/resolv.cfg");
    }

    private void findWin(InputStream in, Locale locale) {
        String packageName = ResolverConfig.class.getPackage().getName();
        String resPackageName = packageName + ".windows.DNSServer";
        ResourceBundle res = locale != null ? ResourceBundle.getBundle(resPackageName, locale) : ResourceBundle.getBundle(resPackageName);
        String host_name = res.getString("host_name");
        String primary_dns_suffix = res.getString("primary_dns_suffix");
        String dns_suffix = res.getString("dns_suffix");
        String dns_servers = res.getString("dns_servers");
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            ArrayList lserver = new ArrayList();
            String line = null;
            boolean readingServers = false;
            boolean readingSearches = false;
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                if (!st.hasMoreTokens()) {
                    readingServers = false;
                    readingSearches = false;
                    continue;
                }
                String s = st.nextToken();
                if (line.indexOf(":") != -1) {
                    readingServers = false;
                    readingSearches = false;
                }
                if (line.indexOf(host_name) != -1) {
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                    }
                    continue;
                }
                if (line.indexOf(primary_dns_suffix) != -1) {
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                    }
                    readingSearches = true;
                    continue;
                }
                if (readingSearches || line.indexOf(dns_suffix) != -1) {
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                    }
                    if (s.equals(":")) continue;
                    readingSearches = true;
                    continue;
                }
                if (!readingServers && line.indexOf(dns_servers) == -1) continue;
                while (st.hasMoreTokens()) {
                    s = st.nextToken();
                }
                if (s.equals(":")) continue;
                readingServers = true;
            }
            this.configureFromLists(lserver);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void findWin(InputStream in) {
        String property = "org.xbill.DNS.windows.parse.buffer";
        int defaultBufSize = 8192;
        int bufSize = Integer.getInteger(property, 8192);
        BufferedInputStream b = new BufferedInputStream(in, bufSize);
        b.mark(bufSize);
        this.findWin(b, null);
        if (this.servers == null) {
            try {
                b.reset();
            }
            catch (IOException e) {
                return;
            }
            this.findWin(b, new Locale("", ""));
        }
    }

    private void find95() {
        String s = "winipcfg.out";
        try {
            Process p = Runtime.getRuntime().exec("winipcfg /all /batch " + s);
            p.waitFor();
            File f = new File(s);
            this.findWin(new FileInputStream(f));
            new File(s).delete();
        }
        catch (Exception e) {
            return;
        }
    }

    private void findNT() {
        try {
            Process p = Runtime.getRuntime().exec("ipconfig /all");
            this.findWin(p.getInputStream());
            p.destroy();
        }
        catch (Exception e) {
            return;
        }
    }

    private void findAndroid() {
        String re1 = "^\\d+(\\.\\d+){3}$";
        String re2 = "^[0-9a-f]+(:[0-9a-f]*)+:[0-9a-f]+$";
        ArrayList<String> lserver = new ArrayList<String>();
        try {
            Class<?> SystemProperties = Class.forName("android.os.SystemProperties");
            Method method = SystemProperties.getMethod("get", String.class);
            String[] netdns = new String[]{"net.dns1", "net.dns2", "net.dns3", "net.dns4"};
            for (int i = 0; i < netdns.length; ++i) {
                Object[] args = new Object[]{netdns[i]};
                String v = (String)method.invoke(null, args);
                if (v == null || !v.matches("^\\d+(\\.\\d+){3}$") && !v.matches("^[0-9a-f]+(:[0-9a-f]*)+:[0-9a-f]+$") || lserver.contains(v)) continue;
                lserver.add(v);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.configureFromLists(lserver);
    }

    public String[] servers() {
        return this.servers;
    }

    public String server() {
        if (this.servers == null) {
            return null;
        }
        return this.servers[0];
    }

    public int ndots() {
        if (this.ndots < 0) {
            return 1;
        }
        return this.ndots;
    }

    public static synchronized ResolverConfig getCurrentConfig() {
        return currentConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        ResolverConfig newConfig = new ResolverConfig();
        Class<ResolverConfig> clazz = ResolverConfig.class;
        synchronized (ResolverConfig.class) {
            currentConfig = newConfig;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        ResolverConfig.refresh();
    }
}

