/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.dns;

import io.nodyn.CallbackResult;
import io.nodyn.NodeProcess;
import io.nodyn.dns.AbstractQueryWrap;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class GetAddrInfo6Wrap
extends AbstractQueryWrap {
    public GetAddrInfo6Wrap(NodeProcess process, String name) {
        super(process, name);
    }

    @Override
    public void start() {
        if (this.name.equals("localhost")) {
            this.process.getEventLoop().getEventLoopGroup().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean found = false;
                        InetAddress[] addrs = InetAddress.getAllByName(GetAddrInfo6Wrap.this.name);
                        for (int i = 0; i < addrs.length; ++i) {
                            if (!(addrs[i] instanceof Inet6Address)) continue;
                            GetAddrInfo6Wrap.this.emit("complete", CallbackResult.createSuccess((Object)addrs[i]));
                            found = true;
                            break;
                        }
                        if (!found) {
                            GetAddrInfo6Wrap.this.emit("complete", CallbackResult.createError(new UnknownHostException()));
                        }
                    }
                    catch (UnknownHostException e) {
                        GetAddrInfo6Wrap.this.emit("complete", CallbackResult.createError(e));
                    }
                }
            });
        } else {
            this.dnsClient().lookup6(this.name, this.handler());
        }
    }
}

