/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.crypto.dh;

import io.nodyn.crypto.dh.DiffieHellmanGroupDesc;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.spec.DHParameterSpec;

public class ModpGroupDesc
extends DiffieHellmanGroupDesc {
    private final BigInteger p;
    private final BigInteger g;
    private final String name;

    public ModpGroupDesc(String name, BigInteger p, BigInteger g) {
        this.name = name;
        this.p = p;
        this.g = g;
    }

    @Override
    public BigInteger getP() {
        return this.p;
    }

    @Override
    public BigInteger getG() {
        return this.g;
    }

    @Override
    public KeyPair generateKeys() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("DH", "BC");
        DHParameterSpec paramSpec = new DHParameterSpec(this.p, this.g);
        generator.initialize(paramSpec);
        return generator.generateKeyPair();
    }
}

