/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.crypto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.security.PublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class Verify {
    private CompositeByteBuf data;
    private String algorithm;

    public void init(String algorithm) {
        this.algorithm = algorithm;
        this.data = Unpooled.compositeBuffer();
    }

    public void update(ByteBuf buf) {
        this.data.addComponent(buf);
        this.data.writerIndex(this.data.writerIndex() + buf.writerIndex());
    }

    public boolean verify(ByteBuf objectBuf, ByteBuf signature) throws Exception {
        PublicKey publicKey;
        block7: {
            String objectStr = objectBuf.toString(Charset.forName("utf8"));
            StringReader objectReader = new StringReader(objectStr);
            PEMParser parser = new PEMParser((Reader)objectReader);
            publicKey = null;
            try {
                Object object = parser.readObject();
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
                if (object instanceof SubjectPublicKeyInfo) {
                    publicKey = converter.getPublicKey((SubjectPublicKeyInfo)object);
                    break block7;
                }
                if (object instanceof PEMKeyPair) {
                    publicKey = converter.getKeyPair((PEMKeyPair)object).getPublic();
                    break block7;
                }
                throw new Exception("Invalid public key");
            }
            catch (IOException e) {
                throw new Exception("Invalid public key");
            }
        }
        try {
            byte[] dataBytes = new byte[this.data.readableBytes()];
            this.data.getBytes(this.data.readerIndex(), dataBytes);
            CMSProcessableByteArray message = new CMSProcessableByteArray(dataBytes);
            byte[] signatureBytes = new byte[signature.readableBytes()];
            signature.getBytes(signature.readerIndex(), signatureBytes);
            CMSSignedData signedData = new CMSSignedData((CMSProcessable)message, signatureBytes);
            SignerInformationVerifier verifier = new JcaSimpleSignerInfoVerifierBuilder().build(publicKey);
            for (SignerInformation each : signedData.getSignerInfos().getSigners()) {
                if (!each.verify(verifier)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

