/*
 * Decompiled with CFR 0.152.
 */
package io.nodyn.crypto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.bouncycastle.crypto.digests.MD5Digest;

public class OpenSSLKDF {
    private ByteBuf key;
    private ByteBuf iv;

    public OpenSSLKDF(ByteBuf data, int keyLen, int ivLen) {
        byte[] bytes = new byte[data.readableBytes()];
        data.readBytes(bytes);
        this.kdf(bytes, keyLen / 8, ivLen);
    }

    public ByteBuf getKey() {
        return this.key;
    }

    public ByteBuf getIv() {
        return this.iv;
    }

    protected void kdf(byte[] data, int keyLen, int ivLen) {
        int i;
        int totalLen = keyLen + ivLen;
        int curLen = 0;
        byte[] prev = new byte[]{};
        byte[] kiv = new byte[totalLen];
        for (i = 0; i < totalLen; ++i) {
            kiv[i] = 0;
        }
        while (curLen < totalLen) {
            prev = this.kdf_d(data, prev, 1);
            for (i = 0; i < prev.length; ++i) {
                if (curLen >= kiv.length) continue;
                kiv[curLen] = prev[i];
                ++curLen;
            }
        }
        this.key = Unpooled.buffer((int)keyLen);
        this.iv = Unpooled.buffer((int)ivLen);
        this.key.writeBytes(kiv, 0, keyLen);
        this.iv.writeBytes(kiv, keyLen, ivLen);
    }

    protected byte[] kdf_d(byte[] data, byte[] prev, int iter) {
        int i;
        byte[] bytes = new byte[prev.length + data.length];
        for (i = 0; i < prev.length; ++i) {
            bytes[i] = prev[i];
        }
        for (i = 0; i < data.length; ++i) {
            bytes[prev.length + i] = data[i];
        }
        byte[] cur = bytes;
        for (int i2 = 0; i2 < iter; ++i2) {
            MD5Digest digest = new MD5Digest();
            digest.update(cur, 0, cur.length);
            cur = new byte[digest.getDigestSize()];
            digest.doFinal(cur, 0);
        }
        byte[] out = new byte[16];
        for (int i3 = 0; i3 < out.length; ++i3) {
            out[i3] = cur[i3];
        }
        return out;
    }
}

